% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNCSend1D}
\alias{IndNCSend1D}
\title{The indicator for the presence of an arc from a point to another for
Central Similarity Proximity Catch Digraphs (CS-PCDs) - end interval case}
\usage{
IndNCSend1D(x1, x2, t, int, rv = NULL)
}
\arguments{
\item{x1}{A 1D point for which the CS proximity region is constructed}

\item{x2}{A 1D point to check whether it is inside the proximity region or not}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region}

\item{int}{A vector of two real numbers representing an interval}

\item{rv}{Index of the end interval containing the point, either 1, 2 or \code{NULL} (default=\code{NULL})}
}
\value{
I(\code{x2} in \eqn{NCS(x1,t)}) for points \code{x1} and \code{x2}, that is, returns 1 if \code{x2} is in \eqn{NCS(x1,t)}
(i.e., if there is an arc from \code{x1} to \code{x2}), returns 0 otherwise
}
\description{
Returns I(\code{x2} in \eqn{NCS(x1,t)}) for points \code{x1} and \code{x2}, that is, returns 1 if \code{x2} is in \eqn{NCS(x1,t)}, returns 0
otherwise, where \eqn{NCS(x,t)} is the CS proximity region for point \eqn{x} with expansion parameter \eqn{t>0}
for the region outside the interval \eqn{(a,b)}.

\code{rv} is the index of the end vertex region \code{x1} resides, with default=\code{NULL},
and \eqn{rv=1} for left end interval and \eqn{rv=2} for the right end interval.
If \code{x1} and \code{x2} are distint and either of them are inside interval \code{int}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)
t<-2

IndNCSend1D(15,17,t,int)
IndNCSend1D(15,15,t,int)

IndNCSend1D(1.5,17,t,int)
IndNCSend1D(1.5,1.5,t,int)

IndNCSend1D(-15,17,t,int)

IndNCSend1D(-15,-17,t,int)

a<-0; b<-10; int<-c(a,b)
t<-.5

IndNCSend1D(15,17,t,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCSmid1D}}, \code{\link{IndNPEmid1D}}, and \code{\link{IndNPEend1D}}
}
