% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdgeUG2D.R
\name{plotPEedges.tri}
\alias{plotPEedges.tri}
\title{The plot of the edges of the underlying or reflexivity graph of
the Proportional Edge Proximity Catch Digraph
(PE-PCD) for 2D data - one triangle case}
\usage{
plotPEedges.tri(
  Xp,
  tri,
  r,
  M = c(1, 1, 1),
  ugraph = c("underlying", "reflexivity"),
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  vert.reg = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graphs of the PE-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}
or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.}

\item{ugraph}{The type of the graph based on PE-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}

\item{asp}{A \code{numeric} value,
giving the aspect ratio \eqn{y/x} (default is \code{NA}),
see the official help page for \code{asp} by
typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes,
respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2,
giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{vert.reg}{A logical argument to add vertex regions to the plot,
default is \code{vert.reg=FALSE}.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the edges of the underlying
or reflexivity graphs of the PE-PCD
whose vertices are the points in data set \code{Xp}
and the triangle \code{tri}
}
\description{
Plots the edges of the underlying or reflexivity graph of
the Proportional Edge Proximity Catch Digraph
(PE-PCD) whose vertices are the data points, \code{Xp}
and the triangle \code{tri}.
PE proximity regions
are constructed with respect to the triangle \code{tri}
with expansion parameter \eqn{r \ge 1},
i.e., edges may exist only for \code{Xp} points inside the triangle \code{tri}.

Vertex regions are based on center \eqn{M=(m_1,m_2)}
in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}
or based on the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.
When the center is the circumcenter, \code{CC},
the vertex regions are constructed based on the
orthogonal projections to the edges,
while with any interior center \code{M},
the vertex regions are constructed using the extensions
of the lines combining vertices with \code{M}.
\code{M}-vertex regions are recommended spatial inference,
due to geometry invariance property of the edge density
and domination number the PE-PCDs based on uniform data.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-pcds::runif.tri(n,Tr)$g

M<-as.numeric(pcds::runif.tri(1,Tr)$g)
r<-1.5
plotPEedges.tri(Xp,Tr,r,M,vert.reg = TRUE,xlab="",ylab="")
plotPEedges.tri(Xp,Tr,r,M,ugraph="r",vert.reg = TRUE,xlab="",ylab="")

#can add vertex labels and text to the figure (with vertex regions)
ifelse(isTRUE(all.equal(M,pcds::circumcenter.tri(Tr))),
{Ds<-rbind((B+C)/2,(A+C)/2,(A+B)/2); cent.name="CC"},
{Ds<-pcds::prj.cent2edges(Tr,M); cent.name="M"})

txt<-rbind(Tr,M,Ds)
xc<-txt[,1]+c(-.02,.02,.02,.02,.04,-0.03,-.01)
yc<-txt[,2]+c(.02,.02,.02,.07,.02,.04,-.06)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEedges}}, \code{\link{plotASedges.tri}},
\code{\link{plotCSedges.tri}}, and \code{\link[pcds]{plotPEarcs.tri}}
}
\author{
Elvan Ceyhan
}
