% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceUGFunctions.R
\name{inci.mat.undAS}
\alias{inci.mat.undAS}
\title{Incidence matrix for the underlying or reflexivity graph of
Arc Slice Proximity Catch Digraphs (AS-PCDs) -
multiple triangle case}
\usage{
inci.mat.undAS(Xp, Yp, M = "CC", ugraph = c("underlying", "reflexivity"))
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graph of the AS-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{M}{The center of each triangle.
\code{"CC"} stands for circumcenter of each Delaunay triangle
or 3D point in barycentric
coordinates which serves as a center
in the interior of each Delaunay triangle;
default is \code{M="CC"}, i.e., the circumcenter of each triangle.}

\item{ugraph}{The type of the graph based on AS-PCDs,
\code{"underlying"} is for the underlying graph,
and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Incidence matrix for the underlying or reflexivity graph
of the AS-PCD whose vertices are the 2D data set, \code{Xp}.
AS proximity regions are constructed
with respect to the Delaunay triangles and \code{M}-vertex regions.
}
\description{
Returns the incidence matrix
for the underlying or reflexivity graph of the AS-PCD
whose vertices are the data points in \code{Xp}
in the multiple triangle case.

AS proximity regions are defined
with respect to the Delaunay triangles based on \code{Yp} points and
vertex regions are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the
interior of each Delaunay triangle;
default is \code{M="CC"}, i.e., circumcenter of each triangle.
Loops are allowed, so the diagonal entries are all equal to 1.

Each Delaunay triangle is first converted to
an (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle
(this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned
by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
For the incidence matrix loops are allowed,
so the diagonal entries are all equal to 1.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on the AS-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds.ugraph})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#\donttest{
nx<-20; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)

IM<-inci.mat.undAS(Xp,Yp,M)
IM
pcds::dom.num.greedy(IM)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.mat.undAStri}}, \code{\link{inci.mat.undPE}},
\code{\link{inci.mat.undCS}}, and \code{\link[pcds]{inci.matAS}}
}
\author{
Elvan Ceyhan
}
