% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fst.R
\name{fstCalc}
\alias{fstCalc}
\title{Fst}
\usage{
fstCalc(data, POPs, nPOP, PopSizes, ploidy = 2)
}
\arguments{
\item{data}{a data matrix or a data frame.}

\item{POPs}{a list of integers specifying which subpopulation the individuals belong to.}

\item{nPOP}{an integer specifying the number of populations in the dataset.}

\item{PopSizes}{a list of length \code{nPOP} specifying the number of individuals for each subpopulation.}

\item{ploidy}{an integer specifying the ploidy of the individuals.}
}
\description{
\code{fstCalc} returns the list of Fst associated with each SNP using Weir and Cockerham's formula.
}
\examples{
x <- read4pcadapt("geno3pops",option="example")
popsizes <- c(50,50,50)
pops <- c(rep(1,times=50),rep(2,times=50),rep(3,times=50))
nPOP <- 3
fst <- fstCalc(x,pops,nPOP,popsizes)
}
\references{
Weir, B. S., & Cockerham, C. C. (1984). Estimating F-statistics for the analysis of population structure. Evolution, 1358-1370.
}

