% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{sdevList}
\alias{sdevList}
\title{Auxiliary function}
\usage{
sdevList(V, K, maf, minmaf)
}
\arguments{
\item{V}{a numeric matrix containing the loadings of the Principal Components Analysis.}

\item{K}{an integer specifying the number of retained principal components.}
}
\description{
\code{sdevList} returns a list of estimated standard deviations using the kurtosis-based method.
}
\examples{
x <- replicate(1000, rnorm(100))
x <- floor(abs(x))
freq <- apply(x,2,sum)/(2*dim(x)[1])
minfreq <- pmin(freq,1-freq)
respc <- prcomp(x)
V <- respc$rotation*sqrt(dim(x)[2])
sdevList(V,K=3,maf=minfreq,minmaf=0.05)
}
\keyword{internal}

