% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.pcLasso.R
\name{predict.pcLasso}
\alias{predict.pcLasso}
\title{Make predictions from a "pcLasso" object}
\usage{
\method{predict}{pcLasso}(object, xnew, ...)
}
\arguments{
\item{object}{Fitted "\code{pcLasso}" object.}

\item{xnew}{Matrix of new values for \code{x} at which predictions are to
be made.}

\item{...}{Potentially other arguments to be passed to and from methods;
currently not in use.}
}
\value{
Predictions of \eqn{E(y|xnew)} which the model \code{object} makes at \code{xnew}. 
These are probabilities for the binomial family.
}
\description{
This function returns the predictions from a "\code{pcLasso}" object
for a new data matrix.
}
\details{
Note that \code{xnew} should have the same number of columns as the original
feature space, regardless of whether the groups are overlapping or not.
}
\examples{
set.seed(1)
x <- matrix(rnorm(100 * 20), 100, 20)

# family = "gaussian"
y <- rnorm(100)
fit1 <- pcLasso(x, y, ratio = 0.8)
predict(fit1, xnew = x[1:5, ])

# family = "binomial"
y2 <- sample(0:1, 100, replace = TRUE)
fit2 <- pcLasso(x, y2, ratio = 0.8, family = "binomial")
predict(fit2, xnew = x[1:5, ])

}
\seealso{
\code{\link{pcLasso}}.
}
