// Generated by rstantools.  Do not edit by hand.

/*
    pcFactorStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pcFactorStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pcFactorStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_factor1_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_factor1");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_factor1");
    reader.add_event(15, 2, "include", "/functions/pairwise.stan");
    reader.add_event(15, 0, "start", "/functions/pairwise.stan");
    reader.add_event(94, 79, "end", "/functions/pairwise.stan");
    reader.add_event(94, 3, "restart", "model_factor1");
    reader.add_event(267, 174, "end", "model_factor1");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
cmp_probs(const T0__& scale,
              const T1__& alpha,
              const T2__& pa1,
              const T3__& pa2,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& thr,
              const std::vector<int>& want, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 17;
        int nth(0);
        (void) nth;  // dummy to suppress unused var warning
        stan::math::fill(nth, std::numeric_limits<int>::min());
        stan::math::assign(nth,num_elements(thr));
        current_statement_begin__ = 18;
        int nth2(0);
        (void) nth2;  // dummy to suppress unused var warning
        stan::math::fill(nth2, std::numeric_limits<int>::min());
        stan::math::assign(nth2,(nth * 2));
        current_statement_begin__ = 19;
        validate_non_negative_index("pr", "(1 + nth2)", (1 + nth2));
        std::vector<local_scalar_t__  > pr((1 + nth2), local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(pr, DUMMY_VAR__);
        stan::math::fill(pr, DUMMY_VAR__);
        current_statement_begin__ = 20;
        validate_non_negative_index("out", "(1 + nth2)", (1 + nth2));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> out((1 + nth2));
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 21;
        local_scalar_t__ paDiff(DUMMY_VAR__);
        (void) paDiff;  // dummy to suppress unused var warning
        stan::math::initialize(paDiff, DUMMY_VAR__);
        stan::math::fill(paDiff, DUMMY_VAR__);
        stan::math::assign(paDiff,((alpha * scale) * (pa1 - pa2)));
        current_statement_begin__ = 22;
        validate_non_negative_index("thrAlpha", "nth", nth);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> thrAlpha(nth);
        stan::math::initialize(thrAlpha, DUMMY_VAR__);
        stan::math::fill(thrAlpha, DUMMY_VAR__);
        stan::math::assign(thrAlpha,multiply(thr, alpha));
        current_statement_begin__ = 23;
        stan::model::assign(pr, 
                    stan::model::cons_list(stan::model::index_uni((1 + nth2)), stan::model::nil_index_list()), 
                    1, 
                    "assigning variable pr");
        current_statement_begin__ = 24;
        for (int tx = 1; tx <= nth2; ++tx) {
            current_statement_begin__ = 25;
            if (as_bool((primitive_value(get_base1(want, tx, "want", 1)) || primitive_value(get_base1(want, (tx + 1), "want", 1))))) {
                {
                current_statement_begin__ = 26;
                local_scalar_t__ at(DUMMY_VAR__);
                (void) at;  // dummy to suppress unused var warning
                stan::math::initialize(at, DUMMY_VAR__);
                stan::math::fill(at, DUMMY_VAR__);
                current_statement_begin__ = 27;
                if (as_bool(logical_lte(tx, nth))) {
                    current_statement_begin__ = 28;
                    stan::math::assign(at, -(get_base1(thrAlpha, ((nth + 1) - tx), "thrAlpha", 1)));
                } else {
                    current_statement_begin__ = 30;
                    stan::math::assign(at, get_base1(thrAlpha, (tx - nth), "thrAlpha", 1));
                }
                current_statement_begin__ = 32;
                stan::model::assign(pr, 
                            stan::model::cons_list(stan::model::index_uni(tx), stan::model::nil_index_list()), 
                            (1.0 / (1.0 + stan::math::exp(-((paDiff + at))))), 
                            "assigning variable pr");
                }
            } else {
                current_statement_begin__ = 34;
                stan::model::assign(pr, 
                            stan::model::cons_list(stan::model::index_uni(tx), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable pr");
            }
        }
        current_statement_begin__ = 37;
        stan::model::assign(out, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    get_base1(pr, 1, "pr", 1), 
                    "assigning variable out");
        current_statement_begin__ = 38;
        for (int tx = 2; tx <= num_elements(out); ++tx) {
            current_statement_begin__ = 39;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(tx), stan::model::nil_index_list()), 
                        (get_base1(pr, tx, "pr", 1) - get_base1(pr, (tx - 1), "pr", 1)), 
                        "assigning variable out");
        }
        current_statement_begin__ = 41;
        for (int tx = 1; tx <= num_elements(want); ++tx) {
            current_statement_begin__ = 42;
            if (as_bool((primitive_value(get_base1(want, tx, "want", 1)) && primitive_value((primitive_value(logical_lte(get_base1(out, tx, "out", 1), 0)) || primitive_value(logical_gte(get_base1(out, tx, "out", 1), 1))))))) {
                current_statement_begin__ = 43;
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "out[";
                errmsg_stream__ << tx;
                errmsg_stream__ << "]=";
                errmsg_stream__ << get_base1(out, tx, "out", 1);
                errmsg_stream__ << "; scale=";
                errmsg_stream__ << scale;
                errmsg_stream__ << " alpha=";
                errmsg_stream__ << alpha;
                errmsg_stream__ << " pa1=";
                errmsg_stream__ << pa1;
                errmsg_stream__ << " pa2=";
                errmsg_stream__ << pa2;
                errmsg_stream__ << " th=";
                errmsg_stream__ << thr;
                throw std::domain_error(errmsg_stream__.str());
            }
        }
        current_statement_begin__ = 47;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cmp_probs_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const T0__& scale,
              const T1__& alpha,
              const T2__& pa1,
              const T3__& pa2,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& thr,
              const std::vector<int>& want, std::ostream* pstream__) const {
        return cmp_probs(scale, alpha, pa1, pa2, thr, want, pstream__);
    }
};
template <typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type
pairwise_logprob(const std::vector<int>& rcat,
                     const std::vector<int>& weight,
                     const int& cmpStart,
                     const int& len,
                     const T4__& scale,
                     const T5__& alpha,
                     const T6__& pa1,
                     const T7__& pa2,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 53;
        local_scalar_t__ lp(DUMMY_VAR__);
        (void) lp;  // dummy to suppress unused var warning
        stan::math::initialize(lp, DUMMY_VAR__);
        stan::math::fill(lp, DUMMY_VAR__);
        stan::math::assign(lp,0);
        current_statement_begin__ = 54;
        int nth(0);
        (void) nth;  // dummy to suppress unused var warning
        stan::math::fill(nth, std::numeric_limits<int>::min());
        stan::math::assign(nth,num_elements(cumTh));
        current_statement_begin__ = 55;
        validate_non_negative_index("prob", "(1 + (nth * 2))", (1 + (nth * 2)));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> prob((1 + (nth * 2)));
        stan::math::initialize(prob, DUMMY_VAR__);
        stan::math::fill(prob, DUMMY_VAR__);
        current_statement_begin__ = 56;
        validate_non_negative_index("want", "(1 + (nth * 2))", (1 + (nth * 2)));
        std::vector<int  > want((1 + (nth * 2)), int(0));
        stan::math::fill(want, std::numeric_limits<int>::min());
        current_statement_begin__ = 57;
        for (int ox = 1; ox <= num_elements(want); ++ox) {
            current_statement_begin__ = 57;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(ox), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable want");
        }
        current_statement_begin__ = 58;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            current_statement_begin__ = 59;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(rcat, ox, "rcat", 1)), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable want");
        }
        current_statement_begin__ = 61;
        stan::math::assign(prob, cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__));
        current_statement_begin__ = 62;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            {
            current_statement_begin__ = 63;
            local_scalar_t__ lp1(DUMMY_VAR__);
            (void) lp1;  // dummy to suppress unused var warning
            stan::math::initialize(lp1, DUMMY_VAR__);
            stan::math::fill(lp1, DUMMY_VAR__);
            stan::math::assign(lp1,stan::math::log(get_base1(prob, get_base1(rcat, ox, "rcat", 1), "prob", 1)));
            current_statement_begin__ = 64;
            if (as_bool(logical_eq(get_base1(weight, ox, "weight", 1), 1))) {
                current_statement_begin__ = 65;
                stan::math::assign(lp, (lp + lp1));
            } else {
                current_statement_begin__ = 67;
                stan::math::assign(lp, (lp + (get_base1(weight, ox, "weight", 1) * lp1)));
            }
            }
        }
        current_statement_begin__ = 70;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lp);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pairwise_logprob_functor__ {
    template <typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
        typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type
    operator()(const std::vector<int>& rcat,
                     const std::vector<int>& weight,
                     const int& cmpStart,
                     const int& len,
                     const T4__& scale,
                     const T5__& alpha,
                     const T6__& pa1,
                     const T7__& pa2,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) const {
        return pairwise_logprob(rcat, weight, cmpStart, len, scale, alpha, pa1, pa2, cumTh, pstream__);
    }
};
template <typename T5__, typename T6__, typename T7__, typename T8__, typename T9__>
std::vector<typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>
pairwise_loo(const std::vector<int>& rcat,
                 const std::vector<int>& weight,
                 const int& numOutcome,
                 const int& cmpStart,
                 const int& len,
                 const T5__& scale,
                 const T6__& alpha,
                 const T7__& pa1,
                 const T8__& pa2,
                 const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 76;
        validate_non_negative_index("lp", "numOutcome", numOutcome);
        std::vector<local_scalar_t__  > lp(numOutcome, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(lp, DUMMY_VAR__);
        stan::math::fill(lp, DUMMY_VAR__);
        current_statement_begin__ = 77;
        int cur(0);
        (void) cur;  // dummy to suppress unused var warning
        stan::math::fill(cur, std::numeric_limits<int>::min());
        stan::math::assign(cur,1);
        current_statement_begin__ = 78;
        int nth(0);
        (void) nth;  // dummy to suppress unused var warning
        stan::math::fill(nth, std::numeric_limits<int>::min());
        stan::math::assign(nth,num_elements(cumTh));
        current_statement_begin__ = 79;
        validate_non_negative_index("prob", "(1 + (nth * 2))", (1 + (nth * 2)));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> prob((1 + (nth * 2)));
        stan::math::initialize(prob, DUMMY_VAR__);
        stan::math::fill(prob, DUMMY_VAR__);
        current_statement_begin__ = 80;
        validate_non_negative_index("want", "(1 + (nth * 2))", (1 + (nth * 2)));
        std::vector<int  > want((1 + (nth * 2)), int(0));
        stan::math::fill(want, std::numeric_limits<int>::min());
        current_statement_begin__ = 81;
        for (int ox = 1; ox <= num_elements(want); ++ox) {
            current_statement_begin__ = 81;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(ox), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable want");
        }
        current_statement_begin__ = 82;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            current_statement_begin__ = 83;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(rcat, ox, "rcat", 1)), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable want");
        }
        current_statement_begin__ = 85;
        stan::math::assign(prob, cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__));
        current_statement_begin__ = 86;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            {
            current_statement_begin__ = 87;
            local_scalar_t__ lp1(DUMMY_VAR__);
            (void) lp1;  // dummy to suppress unused var warning
            stan::math::initialize(lp1, DUMMY_VAR__);
            stan::math::fill(lp1, DUMMY_VAR__);
            stan::math::assign(lp1,stan::math::log(get_base1(prob, get_base1(rcat, ox, "rcat", 1), "prob", 1)));
            current_statement_begin__ = 88;
            for (int wx = 1; wx <= get_base1(weight, ox, "weight", 1); ++wx) {
                current_statement_begin__ = 89;
                stan::model::assign(lp, 
                            stan::model::cons_list(stan::model::index_uni(cur), stan::model::nil_index_list()), 
                            lp1, 
                            "assigning variable lp");
                current_statement_begin__ = 90;
                stan::math::assign(cur, (cur + 1));
            }
            }
        }
        current_statement_begin__ = 93;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lp);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pairwise_loo_functor__ {
    template <typename T5__, typename T6__, typename T7__, typename T8__, typename T9__>
        std::vector<typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>
    operator()(const std::vector<int>& rcat,
                 const std::vector<int>& weight,
                 const int& numOutcome,
                 const int& cmpStart,
                 const int& len,
                 const T5__& scale,
                 const T6__& alpha,
                 const T7__& pa1,
                 const T8__& pa2,
                 const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) const {
        return pairwise_loo(rcat, weight, numOutcome, cmpStart, len, scale, alpha, pa1, pa2, cumTh, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_factor1
  : public stan::model::model_base_crtp<model_factor1> {
private:
        double alphaScalePrior;
        int NPA;
        int NCMP;
        int N;
        int numRefresh;
        int NITEMS;
        std::vector<int> NTHRESH;
        std::vector<int> TOFFSET;
        vector_d scale;
        double propShape;
        int NFACTORS;
        std::vector<double> factorScalePrior;
        int NPATHS;
        std::vector<std::vector<int> > factorItemPath;
        std::vector<int> pa1;
        std::vector<int> pa2;
        std::vector<int> weight;
        std::vector<int> pick;
        std::vector<int> refresh;
        std::vector<int> numOutcome;
        std::vector<int> item;
        int totalThresholds;
        std::vector<int> rcat;
        vector_d pathScalePrior;
public:
    model_factor1(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_factor1(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_factor1_namespace::model_factor1";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 97;
            context__.validate_dims("data initialization", "alphaScalePrior", "double", context__.to_vec());
            alphaScalePrior = double(0);
            vals_r__ = context__.vals_r("alphaScalePrior");
            pos__ = 0;
            alphaScalePrior = vals_r__[pos__++];
            current_statement_begin__ = 99;
            context__.validate_dims("data initialization", "NPA", "int", context__.to_vec());
            NPA = int(0);
            vals_i__ = context__.vals_i("NPA");
            pos__ = 0;
            NPA = vals_i__[pos__++];
            check_greater_or_equal(function__, "NPA", NPA, 1);
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "NCMP", "int", context__.to_vec());
            NCMP = int(0);
            vals_i__ = context__.vals_i("NCMP");
            pos__ = 0;
            NCMP = vals_i__[pos__++];
            check_greater_or_equal(function__, "NCMP", NCMP, 1);
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "numRefresh", "int", context__.to_vec());
            numRefresh = int(0);
            vals_i__ = context__.vals_i("numRefresh");
            pos__ = 0;
            numRefresh = vals_i__[pos__++];
            check_greater_or_equal(function__, "numRefresh", numRefresh, 1);
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "NITEMS", "int", context__.to_vec());
            NITEMS = int(0);
            vals_i__ = context__.vals_i("NITEMS");
            pos__ = 0;
            NITEMS = vals_i__[pos__++];
            check_greater_or_equal(function__, "NITEMS", NITEMS, 1);
            current_statement_begin__ = 104;
            validate_non_negative_index("NTHRESH", "NITEMS", NITEMS);
            context__.validate_dims("data initialization", "NTHRESH", "int", context__.to_vec(NITEMS));
            NTHRESH = std::vector<int>(NITEMS, int(0));
            vals_i__ = context__.vals_i("NTHRESH");
            pos__ = 0;
            size_t NTHRESH_k_0_max__ = NITEMS;
            for (size_t k_0__ = 0; k_0__ < NTHRESH_k_0_max__; ++k_0__) {
                NTHRESH[k_0__] = vals_i__[pos__++];
            }
            size_t NTHRESH_i_0_max__ = NITEMS;
            for (size_t i_0__ = 0; i_0__ < NTHRESH_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "NTHRESH[i_0__]", NTHRESH[i_0__], 1);
            }
            current_statement_begin__ = 105;
            validate_non_negative_index("TOFFSET", "NITEMS", NITEMS);
            context__.validate_dims("data initialization", "TOFFSET", "int", context__.to_vec(NITEMS));
            TOFFSET = std::vector<int>(NITEMS, int(0));
            vals_i__ = context__.vals_i("TOFFSET");
            pos__ = 0;
            size_t TOFFSET_k_0_max__ = NITEMS;
            for (size_t k_0__ = 0; k_0__ < TOFFSET_k_0_max__; ++k_0__) {
                TOFFSET[k_0__] = vals_i__[pos__++];
            }
            size_t TOFFSET_i_0_max__ = NITEMS;
            for (size_t i_0__ = 0; i_0__ < TOFFSET_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "TOFFSET[i_0__]", TOFFSET[i_0__], 1);
            }
            current_statement_begin__ = 106;
            validate_non_negative_index("scale", "NITEMS", NITEMS);
            context__.validate_dims("data initialization", "scale", "vector_d", context__.to_vec(NITEMS));
            scale = Eigen::Matrix<double, Eigen::Dynamic, 1>(NITEMS);
            vals_r__ = context__.vals_r("scale");
            pos__ = 0;
            size_t scale_j_1_max__ = NITEMS;
            for (size_t j_1__ = 0; j_1__ < scale_j_1_max__; ++j_1__) {
                scale(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 107;
            context__.validate_dims("data initialization", "propShape", "double", context__.to_vec());
            propShape = double(0);
            vals_r__ = context__.vals_r("propShape");
            pos__ = 0;
            propShape = vals_r__[pos__++];
            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "NFACTORS", "int", context__.to_vec());
            NFACTORS = int(0);
            vals_i__ = context__.vals_i("NFACTORS");
            pos__ = 0;
            NFACTORS = vals_i__[pos__++];
            check_greater_or_equal(function__, "NFACTORS", NFACTORS, 1);
            current_statement_begin__ = 109;
            validate_non_negative_index("factorScalePrior", "NFACTORS", NFACTORS);
            context__.validate_dims("data initialization", "factorScalePrior", "double", context__.to_vec(NFACTORS));
            factorScalePrior = std::vector<double>(NFACTORS, double(0));
            vals_r__ = context__.vals_r("factorScalePrior");
            pos__ = 0;
            size_t factorScalePrior_k_0_max__ = NFACTORS;
            for (size_t k_0__ = 0; k_0__ < factorScalePrior_k_0_max__; ++k_0__) {
                factorScalePrior[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 110;
            context__.validate_dims("data initialization", "NPATHS", "int", context__.to_vec());
            NPATHS = int(0);
            vals_i__ = context__.vals_i("NPATHS");
            pos__ = 0;
            NPATHS = vals_i__[pos__++];
            check_greater_or_equal(function__, "NPATHS", NPATHS, 1);
            current_statement_begin__ = 111;
            validate_non_negative_index("factorItemPath", "2", 2);
            validate_non_negative_index("factorItemPath", "NPATHS", NPATHS);
            context__.validate_dims("data initialization", "factorItemPath", "int", context__.to_vec(2,NPATHS));
            factorItemPath = std::vector<std::vector<int> >(2, std::vector<int>(NPATHS, int(0)));
            vals_i__ = context__.vals_i("factorItemPath");
            pos__ = 0;
            size_t factorItemPath_k_0_max__ = 2;
            size_t factorItemPath_k_1_max__ = NPATHS;
            for (size_t k_1__ = 0; k_1__ < factorItemPath_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < factorItemPath_k_0_max__; ++k_0__) {
                    factorItemPath[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 113;
            validate_non_negative_index("pa1", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "pa1", "int", context__.to_vec(numRefresh));
            pa1 = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("pa1");
            pos__ = 0;
            size_t pa1_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < pa1_k_0_max__; ++k_0__) {
                pa1[k_0__] = vals_i__[pos__++];
            }
            size_t pa1_i_0_max__ = numRefresh;
            for (size_t i_0__ = 0; i_0__ < pa1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pa1[i_0__]", pa1[i_0__], 1);
                check_less_or_equal(function__, "pa1[i_0__]", pa1[i_0__], NPA);
            }
            current_statement_begin__ = 114;
            validate_non_negative_index("pa2", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "pa2", "int", context__.to_vec(numRefresh));
            pa2 = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("pa2");
            pos__ = 0;
            size_t pa2_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < pa2_k_0_max__; ++k_0__) {
                pa2[k_0__] = vals_i__[pos__++];
            }
            size_t pa2_i_0_max__ = numRefresh;
            for (size_t i_0__ = 0; i_0__ < pa2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pa2[i_0__]", pa2[i_0__], 1);
                check_less_or_equal(function__, "pa2[i_0__]", pa2[i_0__], NPA);
            }
            current_statement_begin__ = 115;
            validate_non_negative_index("weight", "NCMP", NCMP);
            context__.validate_dims("data initialization", "weight", "int", context__.to_vec(NCMP));
            weight = std::vector<int>(NCMP, int(0));
            vals_i__ = context__.vals_i("weight");
            pos__ = 0;
            size_t weight_k_0_max__ = NCMP;
            for (size_t k_0__ = 0; k_0__ < weight_k_0_max__; ++k_0__) {
                weight[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 116;
            validate_non_negative_index("pick", "NCMP", NCMP);
            context__.validate_dims("data initialization", "pick", "int", context__.to_vec(NCMP));
            pick = std::vector<int>(NCMP, int(0));
            vals_i__ = context__.vals_i("pick");
            pos__ = 0;
            size_t pick_k_0_max__ = NCMP;
            for (size_t k_0__ = 0; k_0__ < pick_k_0_max__; ++k_0__) {
                pick[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 117;
            validate_non_negative_index("refresh", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "refresh", "int", context__.to_vec(numRefresh));
            refresh = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("refresh");
            pos__ = 0;
            size_t refresh_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < refresh_k_0_max__; ++k_0__) {
                refresh[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 118;
            validate_non_negative_index("numOutcome", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "numOutcome", "int", context__.to_vec(numRefresh));
            numOutcome = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("numOutcome");
            pos__ = 0;
            size_t numOutcome_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < numOutcome_k_0_max__; ++k_0__) {
                numOutcome[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 119;
            validate_non_negative_index("item", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "item", "int", context__.to_vec(numRefresh));
            item = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("item");
            pos__ = 0;
            size_t item_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < item_k_0_max__; ++k_0__) {
                item[k_0__] = vals_i__[pos__++];
            }
            // initialize transformed data variables
            current_statement_begin__ = 122;
            totalThresholds = int(0);
            stan::math::fill(totalThresholds, std::numeric_limits<int>::min());
            stan::math::assign(totalThresholds,sum(NTHRESH));
            current_statement_begin__ = 123;
            validate_non_negative_index("rcat", "NCMP", NCMP);
            rcat = std::vector<int>(NCMP, int(0));
            stan::math::fill(rcat, std::numeric_limits<int>::min());
            current_statement_begin__ = 124;
            validate_non_negative_index("pathScalePrior", "NPATHS", NPATHS);
            pathScalePrior = Eigen::Matrix<double, Eigen::Dynamic, 1>(NPATHS);
            stan::math::fill(pathScalePrior, DUMMY_VAR__);
            // execute transformed data statements
            {
            current_statement_begin__ = 126;
            int cmpStart(0);
            (void) cmpStart;  // dummy to suppress unused var warning
            stan::math::fill(cmpStart, std::numeric_limits<int>::min());
            stan::math::assign(cmpStart,0);
            current_statement_begin__ = 127;
            for (int rx = 1; rx <= numRefresh; ++rx) {
                {
                current_statement_begin__ = 128;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(item, rx, "item", 1));
                current_statement_begin__ = 129;
                for (int cmp = 1; cmp <= get_base1(refresh, rx, "refresh", 1); ++cmp) {
                    current_statement_begin__ = 130;
                    stan::model::assign(rcat, 
                                stan::model::cons_list(stan::model::index_uni((cmpStart + cmp)), stan::model::nil_index_list()), 
                                ((get_base1(pick, (cmpStart + cmp), "pick", 1) + get_base1(NTHRESH, ix, "NTHRESH", 1)) + 1), 
                                "assigning variable rcat");
                }
                current_statement_begin__ = 132;
                stan::math::assign(cmpStart, (cmpStart + get_base1(refresh, rx, "refresh", 1)));
                }
            }
            }
            current_statement_begin__ = 135;
            for (int px = 1; px <= NPATHS; ++px) {
                {
                current_statement_begin__ = 136;
                int fx(0);
                (void) fx;  // dummy to suppress unused var warning
                stan::math::fill(fx, std::numeric_limits<int>::min());
                stan::math::assign(fx,get_base1(get_base1(factorItemPath, 1, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 137;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(get_base1(factorItemPath, 2, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 138;
                if (as_bool((primitive_value(logical_lt(fx, 1)) || primitive_value(logical_gt(fx, NFACTORS))))) {
                    current_statement_begin__ = 139;
                    std::stringstream errmsg_stream__;
                    errmsg_stream__ << "factorItemPath[1,";
                    errmsg_stream__ << "px";
                    errmsg_stream__ << "] names factor ";
                    errmsg_stream__ << fx;
                    errmsg_stream__ << " (NFACTORS=";
                    errmsg_stream__ << NFACTORS;
                    errmsg_stream__ << ")";
                    throw std::domain_error(errmsg_stream__.str());
                }
                current_statement_begin__ = 141;
                if (as_bool((primitive_value(logical_lt(ix, 1)) || primitive_value(logical_gt(ix, NITEMS))))) {
                    current_statement_begin__ = 142;
                    std::stringstream errmsg_stream__;
                    errmsg_stream__ << "factorItemPath[2,";
                    errmsg_stream__ << "px";
                    errmsg_stream__ << "] names item ";
                    errmsg_stream__ << ix;
                    errmsg_stream__ << " (NITEMS=";
                    errmsg_stream__ << NITEMS;
                    errmsg_stream__ << ")";
                    throw std::domain_error(errmsg_stream__.str());
                }
                current_statement_begin__ = 144;
                stan::model::assign(pathScalePrior, 
                            stan::model::cons_list(stan::model::index_uni(px), stan::model::nil_index_list()), 
                            get_base1(factorScalePrior, fx, "factorScalePrior", 1), 
                            "assigning variable pathScalePrior");
                }
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 148;
            validate_non_negative_index("alpha", "NITEMS", NITEMS);
            num_params_r__ += (1 * NITEMS);
            current_statement_begin__ = 149;
            validate_non_negative_index("rawThreshold", "totalThresholds", totalThresholds);
            num_params_r__ += totalThresholds;
            current_statement_begin__ = 150;
            validate_non_negative_index("rawFactor", "NPA", NPA);
            validate_non_negative_index("rawFactor", "NFACTORS", NFACTORS);
            num_params_r__ += (NPA * NFACTORS);
            current_statement_begin__ = 151;
            validate_non_negative_index("rawLoadings", "NPATHS", NPATHS);
            num_params_r__ += NPATHS;
            current_statement_begin__ = 152;
            validate_non_negative_index("rawUniqueTheta", "NPA", NPA);
            validate_non_negative_index("rawUniqueTheta", "NITEMS", NITEMS);
            num_params_r__ += (NPA * NITEMS);
            current_statement_begin__ = 153;
            validate_non_negative_index("rawUnique", "NITEMS", NITEMS);
            num_params_r__ += NITEMS;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_factor1() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 148;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "NITEMS", NITEMS);
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec(NITEMS));
        std::vector<double> alpha(NITEMS, double(0));
        size_t alpha_k_0_max__ = NITEMS;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            alpha[k_0__] = vals_r__[pos__++];
        }
        size_t alpha_i_0_max__ = NITEMS;
        for (size_t i_0__ = 0; i_0__ < alpha_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, alpha[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 149;
        if (!(context__.contains_r("rawThreshold")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawThreshold missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawThreshold");
        pos__ = 0U;
        validate_non_negative_index("rawThreshold", "totalThresholds", totalThresholds);
        context__.validate_dims("parameter initialization", "rawThreshold", "vector_d", context__.to_vec(totalThresholds));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawThreshold(totalThresholds);
        size_t rawThreshold_j_1_max__ = totalThresholds;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            rawThreshold(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rawThreshold);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawThreshold: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 150;
        if (!(context__.contains_r("rawFactor")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawFactor missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawFactor");
        pos__ = 0U;
        validate_non_negative_index("rawFactor", "NPA", NPA);
        validate_non_negative_index("rawFactor", "NFACTORS", NFACTORS);
        context__.validate_dims("parameter initialization", "rawFactor", "matrix_d", context__.to_vec(NPA,NFACTORS));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rawFactor(NPA, NFACTORS);
        size_t rawFactor_j_2_max__ = NFACTORS;
        size_t rawFactor_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawFactor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawFactor_j_1_max__; ++j_1__) {
                rawFactor(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(rawFactor);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawFactor: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 151;
        if (!(context__.contains_r("rawLoadings")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawLoadings missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawLoadings");
        pos__ = 0U;
        validate_non_negative_index("rawLoadings", "NPATHS", NPATHS);
        context__.validate_dims("parameter initialization", "rawLoadings", "vector_d", context__.to_vec(NPATHS));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawLoadings(NPATHS);
        size_t rawLoadings_j_1_max__ = NPATHS;
        for (size_t j_1__ = 0; j_1__ < rawLoadings_j_1_max__; ++j_1__) {
            rawLoadings(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rawLoadings);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawLoadings: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 152;
        if (!(context__.contains_r("rawUniqueTheta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawUniqueTheta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawUniqueTheta");
        pos__ = 0U;
        validate_non_negative_index("rawUniqueTheta", "NPA", NPA);
        validate_non_negative_index("rawUniqueTheta", "NITEMS", NITEMS);
        context__.validate_dims("parameter initialization", "rawUniqueTheta", "matrix_d", context__.to_vec(NPA,NITEMS));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rawUniqueTheta(NPA, NITEMS);
        size_t rawUniqueTheta_j_2_max__ = NITEMS;
        size_t rawUniqueTheta_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawUniqueTheta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawUniqueTheta_j_1_max__; ++j_1__) {
                rawUniqueTheta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(rawUniqueTheta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawUniqueTheta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 153;
        if (!(context__.contains_r("rawUnique")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawUnique missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawUnique");
        pos__ = 0U;
        validate_non_negative_index("rawUnique", "NITEMS", NITEMS);
        context__.validate_dims("parameter initialization", "rawUnique", "vector_d", context__.to_vec(NITEMS));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawUnique(NITEMS);
        size_t rawUnique_j_1_max__ = NITEMS;
        for (size_t j_1__ = 0; j_1__ < rawUnique_j_1_max__; ++j_1__) {
            rawUnique(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rawUnique);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawUnique: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 148;
            std::vector<local_scalar_t__> alpha;
            size_t alpha_d_0_max__ = NITEMS;
            alpha.reserve(alpha_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
                if (jacobian__)
                    alpha.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    alpha.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 149;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawThreshold;
            (void) rawThreshold;  // dummy to suppress unused var warning
            if (jacobian__)
                rawThreshold = in__.vector_lub_constrain(0, 1, totalThresholds, lp__);
            else
                rawThreshold = in__.vector_lub_constrain(0, 1, totalThresholds);
            current_statement_begin__ = 150;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> rawFactor;
            (void) rawFactor;  // dummy to suppress unused var warning
            if (jacobian__)
                rawFactor = in__.matrix_constrain(NPA, NFACTORS, lp__);
            else
                rawFactor = in__.matrix_constrain(NPA, NFACTORS);
            current_statement_begin__ = 151;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawLoadings;
            (void) rawLoadings;  // dummy to suppress unused var warning
            if (jacobian__)
                rawLoadings = in__.vector_lub_constrain(0, 1, NPATHS, lp__);
            else
                rawLoadings = in__.vector_lub_constrain(0, 1, NPATHS);
            current_statement_begin__ = 152;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> rawUniqueTheta;
            (void) rawUniqueTheta;  // dummy to suppress unused var warning
            if (jacobian__)
                rawUniqueTheta = in__.matrix_constrain(NPA, NITEMS, lp__);
            else
                rawUniqueTheta = in__.matrix_constrain(NPA, NITEMS);
            current_statement_begin__ = 153;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawUnique;
            (void) rawUnique;  // dummy to suppress unused var warning
            if (jacobian__)
                rawUnique = in__.vector_lub_constrain(0, 1, NITEMS, lp__);
            else
                rawUnique = in__.vector_lub_constrain(0, 1, NITEMS);
            // transformed parameters
            current_statement_begin__ = 156;
            validate_non_negative_index("threshold", "totalThresholds", totalThresholds);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> threshold(totalThresholds);
            stan::math::initialize(threshold, DUMMY_VAR__);
            stan::math::fill(threshold, DUMMY_VAR__);
            current_statement_begin__ = 157;
            validate_non_negative_index("rawCumTh", "totalThresholds", totalThresholds);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawCumTh(totalThresholds);
            stan::math::initialize(rawCumTh, DUMMY_VAR__);
            stan::math::fill(rawCumTh, DUMMY_VAR__);
            current_statement_begin__ = 158;
            validate_non_negative_index("theta", "NPA", NPA);
            validate_non_negative_index("theta", "NITEMS", NITEMS);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta(NPA, NITEMS);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 159;
            validate_non_negative_index("rawPathProp", "NPATHS", NPATHS);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawPathProp(NPATHS);
            stan::math::initialize(rawPathProp, DUMMY_VAR__);
            stan::math::fill(rawPathProp, DUMMY_VAR__);
            current_statement_begin__ = 160;
            validate_non_negative_index("rawPerComponentVar", "NITEMS", NITEMS);
            validate_non_negative_index("rawPerComponentVar", "(1 + NFACTORS)", (1 + NFACTORS));
            std::vector<std::vector<local_scalar_t__> > rawPerComponentVar(NITEMS, std::vector<local_scalar_t__>((1 + NFACTORS), local_scalar_t__(0)));
            stan::math::initialize(rawPerComponentVar, DUMMY_VAR__);
            stan::math::fill(rawPerComponentVar, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 161;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                current_statement_begin__ = 162;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            multiply(stan::model::rvalue(rawUniqueTheta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "rawUniqueTheta"), ((2 * get_base1(rawUnique, ix, "rawUnique", 1)) - 1)), 
                            "assigning variable theta");
                current_statement_begin__ = 163;
                stan::model::assign(rawPerComponentVar, 
                            stan::model::cons_list(stan::model::index_uni(ix), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            variance(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta")), 
                            "assigning variable rawPerComponentVar");
            }
            current_statement_begin__ = 165;
            for (int fx = 1; fx <= NFACTORS; ++fx) {
                current_statement_begin__ = 166;
                for (int ix = 1; ix <= NITEMS; ++ix) {
                    current_statement_begin__ = 166;
                    stan::model::assign(rawPerComponentVar, 
                                stan::model::cons_list(stan::model::index_uni(ix), stan::model::cons_list(stan::model::index_uni((1 + fx)), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable rawPerComponentVar");
                }
            }
            current_statement_begin__ = 168;
            for (int px = 1; px <= NPATHS; ++px) {
                {
                current_statement_begin__ = 169;
                int fx(0);
                (void) fx;  // dummy to suppress unused var warning
                stan::math::fill(fx, std::numeric_limits<int>::min());
                stan::math::assign(fx,get_base1(get_base1(factorItemPath, 1, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 170;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(get_base1(factorItemPath, 2, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 171;
                validate_non_negative_index("theta1", "NPA", NPA);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta1(NPA);
                stan::math::initialize(theta1, DUMMY_VAR__);
                stan::math::fill(theta1, DUMMY_VAR__);
                stan::math::assign(theta1,multiply(((2 * get_base1(rawLoadings, px, "rawLoadings", 1)) - 1), stan::model::rvalue(rawFactor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "rawFactor")));
                current_statement_begin__ = 172;
                stan::model::assign(rawPerComponentVar, 
                            stan::model::cons_list(stan::model::index_uni(ix), stan::model::cons_list(stan::model::index_uni((1 + fx)), stan::model::nil_index_list())), 
                            variance(theta1), 
                            "assigning variable rawPerComponentVar");
                current_statement_begin__ = 173;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            add(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta"), theta1), 
                            "assigning variable theta");
                }
            }
            current_statement_begin__ = 175;
            for (int px = 1; px <= NPATHS; ++px) {
                {
                current_statement_begin__ = 176;
                int fx(0);
                (void) fx;  // dummy to suppress unused var warning
                stan::math::fill(fx, std::numeric_limits<int>::min());
                stan::math::assign(fx,get_base1(get_base1(factorItemPath, 1, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 177;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(get_base1(factorItemPath, 2, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 178;
                local_scalar_t__ resid(DUMMY_VAR__);
                (void) resid;  // dummy to suppress unused var warning
                stan::math::initialize(resid, DUMMY_VAR__);
                stan::math::fill(resid, DUMMY_VAR__);
                stan::math::assign(resid,0);
                current_statement_begin__ = 179;
                local_scalar_t__ pred(DUMMY_VAR__);
                (void) pred;  // dummy to suppress unused var warning
                stan::math::initialize(pred, DUMMY_VAR__);
                stan::math::fill(pred, DUMMY_VAR__);
                current_statement_begin__ = 180;
                for (int cx = 1; cx <= (1 + NFACTORS); ++cx) {
                    current_statement_begin__ = 181;
                    if (as_bool(logical_eq(cx, (fx + 1)))) {
                        current_statement_begin__ = 182;
                        stan::math::assign(pred, get_base1(get_base1(rawPerComponentVar, ix, "rawPerComponentVar", 1), cx, "rawPerComponentVar", 2));
                    } else {
                        current_statement_begin__ = 184;
                        stan::math::assign(resid, (resid + get_base1(get_base1(rawPerComponentVar, ix, "rawPerComponentVar", 1), cx, "rawPerComponentVar", 2)));
                    }
                }
                current_statement_begin__ = 187;
                stan::model::assign(rawPathProp, 
                            stan::model::cons_list(stan::model::index_uni(px), stan::model::nil_index_list()), 
                            (pred / (pred + resid)), 
                            "assigning variable rawPathProp");
                }
            }
            current_statement_begin__ = 189;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                {
                current_statement_begin__ = 190;
                local_scalar_t__ maxSpan(DUMMY_VAR__);
                (void) maxSpan;  // dummy to suppress unused var warning
                stan::math::initialize(maxSpan, DUMMY_VAR__);
                stan::math::fill(maxSpan, DUMMY_VAR__);
                stan::math::assign(maxSpan,(max(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta")) - min(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta"))));
                current_statement_begin__ = 191;
                int from(0);
                (void) from;  // dummy to suppress unused var warning
                stan::math::fill(from, std::numeric_limits<int>::min());
                stan::math::assign(from,get_base1(TOFFSET, ix, "TOFFSET", 1));
                current_statement_begin__ = 192;
                int to(0);
                (void) to;  // dummy to suppress unused var warning
                stan::math::fill(to, std::numeric_limits<int>::min());
                stan::math::assign(to,((get_base1(TOFFSET, ix, "TOFFSET", 1) + get_base1(NTHRESH, ix, "NTHRESH", 1)) - 1));
                current_statement_begin__ = 193;
                stan::model::assign(threshold, 
                            stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), 
                            multiply(maxSpan, stan::model::rvalue(rawThreshold, stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), "rawThreshold")), 
                            "assigning variable threshold");
                current_statement_begin__ = 194;
                stan::model::assign(rawCumTh, 
                            stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), 
                            cumulative_sum(stan::model::rvalue(threshold, stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), "threshold")), 
                            "assigning variable rawCumTh");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 156;
            size_t threshold_j_1_max__ = totalThresholds;
            for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(threshold(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: threshold" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable threshold: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 157;
            size_t rawCumTh_j_1_max__ = totalThresholds;
            for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(rawCumTh(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rawCumTh" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rawCumTh: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 158;
            size_t theta_j_1_max__ = NPA;
            size_t theta_j_2_max__ = NITEMS;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(theta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: theta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 159;
            size_t rawPathProp_j_1_max__ = NPATHS;
            for (size_t j_1__ = 0; j_1__ < rawPathProp_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(rawPathProp(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rawPathProp" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rawPathProp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 160;
            size_t rawPerComponentVar_k_0_max__ = NITEMS;
            size_t rawPerComponentVar_k_1_max__ = (1 + NFACTORS);
            for (size_t k_0__ = 0; k_0__ < rawPerComponentVar_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < rawPerComponentVar_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(rawPerComponentVar[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: rawPerComponentVar" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rawPerComponentVar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 198;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                current_statement_begin__ = 198;
                lp_accum__.add(normal_log<propto__>(get_base1(alpha, ix, "alpha", 1), 1.749, alphaScalePrior));
                if (get_base1(alpha, ix, "alpha", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, 1.749, alphaScalePrior));
            }
            current_statement_begin__ = 199;
            lp_accum__.add(beta_log<propto__>(rawThreshold, 1.1, 2));
            current_statement_begin__ = 200;
            lp_accum__.add(std_normal_log<propto__>(stan::model::rvalue(rawFactor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "rawFactor")));
            current_statement_begin__ = 201;
            lp_accum__.add(beta_log<propto__>(rawLoadings, propShape, propShape));
            current_statement_begin__ = 202;
            lp_accum__.add(beta_log<propto__>(rawUnique, propShape, propShape));
            current_statement_begin__ = 203;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                current_statement_begin__ = 204;
                lp_accum__.add(std_normal_log<propto__>(stan::model::rvalue(rawUniqueTheta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "rawUniqueTheta")));
            }
            {
            current_statement_begin__ = 207;
            int cmpStart(0);
            (void) cmpStart;  // dummy to suppress unused var warning
            stan::math::fill(cmpStart, std::numeric_limits<int>::min());
            stan::math::assign(cmpStart,1);
            current_statement_begin__ = 208;
            for (int rx = 1; rx <= numRefresh; ++rx) {
                {
                current_statement_begin__ = 209;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(item, rx, "item", 1));
                current_statement_begin__ = 210;
                int from(0);
                (void) from;  // dummy to suppress unused var warning
                stan::math::fill(from, std::numeric_limits<int>::min());
                stan::math::assign(from,get_base1(TOFFSET, ix, "TOFFSET", 1));
                current_statement_begin__ = 211;
                int to(0);
                (void) to;  // dummy to suppress unused var warning
                stan::math::fill(to, std::numeric_limits<int>::min());
                stan::math::assign(to,((get_base1(TOFFSET, ix, "TOFFSET", 1) + get_base1(NTHRESH, ix, "NTHRESH", 1)) - 1));
                current_statement_begin__ = 212;
                lp_accum__.add(pairwise_logprob(rcat, weight, cmpStart, get_base1(refresh, rx, "refresh", 1), get_base1(scale, ix, "scale", 1), get_base1(alpha, ix, "alpha", 1), get_base1(theta, get_base1(pa1, rx, "pa1", 1), ix, "theta", 1), get_base1(theta, get_base1(pa2, rx, "pa2", 1), ix, "theta", 1), stan::model::rvalue(rawCumTh, stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), "rawCumTh"), pstream__));
                current_statement_begin__ = 215;
                stan::math::assign(cmpStart, (cmpStart + get_base1(refresh, rx, "refresh", 1)));
                }
            }
            }
            current_statement_begin__ = 219;
            lp_accum__.add(normal_log(logit(add(0.5, divide(rawPathProp, 2.0))), 0, pathScalePrior));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("rawThreshold");
        names__.push_back("rawFactor");
        names__.push_back("rawLoadings");
        names__.push_back("rawUniqueTheta");
        names__.push_back("rawUnique");
        names__.push_back("threshold");
        names__.push_back("rawCumTh");
        names__.push_back("theta");
        names__.push_back("rawPathProp");
        names__.push_back("rawPerComponentVar");
        names__.push_back("pathProp");
        names__.push_back("factor");
        names__.push_back("residualItemCor");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(NITEMS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(totalThresholds);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPA);
        dims__.push_back(NFACTORS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPATHS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPA);
        dims__.push_back(NITEMS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NITEMS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(totalThresholds);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(totalThresholds);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPA);
        dims__.push_back(NITEMS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPATHS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NITEMS);
        dims__.push_back((1 + NFACTORS));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPATHS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPA);
        dims__.push_back(NFACTORS);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NITEMS);
        dims__.push_back(NITEMS);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_factor1_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> alpha;
        size_t alpha_d_0_max__ = NITEMS;
        alpha.reserve(alpha_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
            alpha.push_back(in__.scalar_lb_constrain(0));
        }
        size_t alpha_k_0_max__ = NITEMS;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawThreshold = in__.vector_lub_constrain(0, 1, totalThresholds);
        size_t rawThreshold_j_1_max__ = totalThresholds;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            vars__.push_back(rawThreshold(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rawFactor = in__.matrix_constrain(NPA, NFACTORS);
        size_t rawFactor_j_2_max__ = NFACTORS;
        size_t rawFactor_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawFactor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawFactor_j_1_max__; ++j_1__) {
                vars__.push_back(rawFactor(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawLoadings = in__.vector_lub_constrain(0, 1, NPATHS);
        size_t rawLoadings_j_1_max__ = NPATHS;
        for (size_t j_1__ = 0; j_1__ < rawLoadings_j_1_max__; ++j_1__) {
            vars__.push_back(rawLoadings(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rawUniqueTheta = in__.matrix_constrain(NPA, NITEMS);
        size_t rawUniqueTheta_j_2_max__ = NITEMS;
        size_t rawUniqueTheta_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawUniqueTheta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawUniqueTheta_j_1_max__; ++j_1__) {
                vars__.push_back(rawUniqueTheta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawUnique = in__.vector_lub_constrain(0, 1, NITEMS);
        size_t rawUnique_j_1_max__ = NITEMS;
        for (size_t j_1__ = 0; j_1__ < rawUnique_j_1_max__; ++j_1__) {
            vars__.push_back(rawUnique(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 156;
            validate_non_negative_index("threshold", "totalThresholds", totalThresholds);
            Eigen::Matrix<double, Eigen::Dynamic, 1> threshold(totalThresholds);
            stan::math::initialize(threshold, DUMMY_VAR__);
            stan::math::fill(threshold, DUMMY_VAR__);
            current_statement_begin__ = 157;
            validate_non_negative_index("rawCumTh", "totalThresholds", totalThresholds);
            Eigen::Matrix<double, Eigen::Dynamic, 1> rawCumTh(totalThresholds);
            stan::math::initialize(rawCumTh, DUMMY_VAR__);
            stan::math::fill(rawCumTh, DUMMY_VAR__);
            current_statement_begin__ = 158;
            validate_non_negative_index("theta", "NPA", NPA);
            validate_non_negative_index("theta", "NITEMS", NITEMS);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(NPA, NITEMS);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 159;
            validate_non_negative_index("rawPathProp", "NPATHS", NPATHS);
            Eigen::Matrix<double, Eigen::Dynamic, 1> rawPathProp(NPATHS);
            stan::math::initialize(rawPathProp, DUMMY_VAR__);
            stan::math::fill(rawPathProp, DUMMY_VAR__);
            current_statement_begin__ = 160;
            validate_non_negative_index("rawPerComponentVar", "NITEMS", NITEMS);
            validate_non_negative_index("rawPerComponentVar", "(1 + NFACTORS)", (1 + NFACTORS));
            std::vector<std::vector<double> > rawPerComponentVar(NITEMS, std::vector<double>((1 + NFACTORS), double(0)));
            stan::math::initialize(rawPerComponentVar, DUMMY_VAR__);
            stan::math::fill(rawPerComponentVar, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 161;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                current_statement_begin__ = 162;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            multiply(stan::model::rvalue(rawUniqueTheta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "rawUniqueTheta"), ((2 * get_base1(rawUnique, ix, "rawUnique", 1)) - 1)), 
                            "assigning variable theta");
                current_statement_begin__ = 163;
                stan::model::assign(rawPerComponentVar, 
                            stan::model::cons_list(stan::model::index_uni(ix), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            variance(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta")), 
                            "assigning variable rawPerComponentVar");
            }
            current_statement_begin__ = 165;
            for (int fx = 1; fx <= NFACTORS; ++fx) {
                current_statement_begin__ = 166;
                for (int ix = 1; ix <= NITEMS; ++ix) {
                    current_statement_begin__ = 166;
                    stan::model::assign(rawPerComponentVar, 
                                stan::model::cons_list(stan::model::index_uni(ix), stan::model::cons_list(stan::model::index_uni((1 + fx)), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable rawPerComponentVar");
                }
            }
            current_statement_begin__ = 168;
            for (int px = 1; px <= NPATHS; ++px) {
                {
                current_statement_begin__ = 169;
                int fx(0);
                (void) fx;  // dummy to suppress unused var warning
                stan::math::fill(fx, std::numeric_limits<int>::min());
                stan::math::assign(fx,get_base1(get_base1(factorItemPath, 1, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 170;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(get_base1(factorItemPath, 2, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 171;
                validate_non_negative_index("theta1", "NPA", NPA);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta1(NPA);
                stan::math::initialize(theta1, DUMMY_VAR__);
                stan::math::fill(theta1, DUMMY_VAR__);
                stan::math::assign(theta1,multiply(((2 * get_base1(rawLoadings, px, "rawLoadings", 1)) - 1), stan::model::rvalue(rawFactor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "rawFactor")));
                current_statement_begin__ = 172;
                stan::model::assign(rawPerComponentVar, 
                            stan::model::cons_list(stan::model::index_uni(ix), stan::model::cons_list(stan::model::index_uni((1 + fx)), stan::model::nil_index_list())), 
                            variance(theta1), 
                            "assigning variable rawPerComponentVar");
                current_statement_begin__ = 173;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            add(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta"), theta1), 
                            "assigning variable theta");
                }
            }
            current_statement_begin__ = 175;
            for (int px = 1; px <= NPATHS; ++px) {
                {
                current_statement_begin__ = 176;
                int fx(0);
                (void) fx;  // dummy to suppress unused var warning
                stan::math::fill(fx, std::numeric_limits<int>::min());
                stan::math::assign(fx,get_base1(get_base1(factorItemPath, 1, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 177;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(get_base1(factorItemPath, 2, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 178;
                local_scalar_t__ resid(DUMMY_VAR__);
                (void) resid;  // dummy to suppress unused var warning
                stan::math::initialize(resid, DUMMY_VAR__);
                stan::math::fill(resid, DUMMY_VAR__);
                stan::math::assign(resid,0);
                current_statement_begin__ = 179;
                local_scalar_t__ pred(DUMMY_VAR__);
                (void) pred;  // dummy to suppress unused var warning
                stan::math::initialize(pred, DUMMY_VAR__);
                stan::math::fill(pred, DUMMY_VAR__);
                current_statement_begin__ = 180;
                for (int cx = 1; cx <= (1 + NFACTORS); ++cx) {
                    current_statement_begin__ = 181;
                    if (as_bool(logical_eq(cx, (fx + 1)))) {
                        current_statement_begin__ = 182;
                        stan::math::assign(pred, get_base1(get_base1(rawPerComponentVar, ix, "rawPerComponentVar", 1), cx, "rawPerComponentVar", 2));
                    } else {
                        current_statement_begin__ = 184;
                        stan::math::assign(resid, (resid + get_base1(get_base1(rawPerComponentVar, ix, "rawPerComponentVar", 1), cx, "rawPerComponentVar", 2)));
                    }
                }
                current_statement_begin__ = 187;
                stan::model::assign(rawPathProp, 
                            stan::model::cons_list(stan::model::index_uni(px), stan::model::nil_index_list()), 
                            (pred / (pred + resid)), 
                            "assigning variable rawPathProp");
                }
            }
            current_statement_begin__ = 189;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                {
                current_statement_begin__ = 190;
                local_scalar_t__ maxSpan(DUMMY_VAR__);
                (void) maxSpan;  // dummy to suppress unused var warning
                stan::math::initialize(maxSpan, DUMMY_VAR__);
                stan::math::fill(maxSpan, DUMMY_VAR__);
                stan::math::assign(maxSpan,(max(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta")) - min(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "theta"))));
                current_statement_begin__ = 191;
                int from(0);
                (void) from;  // dummy to suppress unused var warning
                stan::math::fill(from, std::numeric_limits<int>::min());
                stan::math::assign(from,get_base1(TOFFSET, ix, "TOFFSET", 1));
                current_statement_begin__ = 192;
                int to(0);
                (void) to;  // dummy to suppress unused var warning
                stan::math::fill(to, std::numeric_limits<int>::min());
                stan::math::assign(to,((get_base1(TOFFSET, ix, "TOFFSET", 1) + get_base1(NTHRESH, ix, "NTHRESH", 1)) - 1));
                current_statement_begin__ = 193;
                stan::model::assign(threshold, 
                            stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), 
                            multiply(maxSpan, stan::model::rvalue(rawThreshold, stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), "rawThreshold")), 
                            "assigning variable threshold");
                current_statement_begin__ = 194;
                stan::model::assign(rawCumTh, 
                            stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), 
                            cumulative_sum(stan::model::rvalue(threshold, stan::model::cons_list(stan::model::index_min_max(from, to), stan::model::nil_index_list()), "threshold")), 
                            "assigning variable rawCumTh");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t threshold_j_1_max__ = totalThresholds;
                for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                    vars__.push_back(threshold(j_1__));
                }
                size_t rawCumTh_j_1_max__ = totalThresholds;
                for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                    vars__.push_back(rawCumTh(j_1__));
                }
                size_t theta_j_2_max__ = NITEMS;
                size_t theta_j_1_max__ = NPA;
                for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                        vars__.push_back(theta(j_1__, j_2__));
                    }
                }
                size_t rawPathProp_j_1_max__ = NPATHS;
                for (size_t j_1__ = 0; j_1__ < rawPathProp_j_1_max__; ++j_1__) {
                    vars__.push_back(rawPathProp(j_1__));
                }
                size_t rawPerComponentVar_k_0_max__ = NITEMS;
                size_t rawPerComponentVar_k_1_max__ = (1 + NFACTORS);
                for (size_t k_1__ = 0; k_1__ < rawPerComponentVar_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < rawPerComponentVar_k_0_max__; ++k_0__) {
                        vars__.push_back(rawPerComponentVar[k_0__][k_1__]);
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 222;
            validate_non_negative_index("pathProp", "NPATHS", NPATHS);
            Eigen::Matrix<double, Eigen::Dynamic, 1> pathProp(NPATHS);
            stan::math::initialize(pathProp, DUMMY_VAR__);
            stan::math::fill(pathProp, DUMMY_VAR__);
            stan::math::assign(pathProp,rawPathProp);
            current_statement_begin__ = 223;
            validate_non_negative_index("factor", "NPA", NPA);
            validate_non_negative_index("factor", "NFACTORS", NFACTORS);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> factor(NPA, NFACTORS);
            stan::math::initialize(factor, DUMMY_VAR__);
            stan::math::fill(factor, DUMMY_VAR__);
            stan::math::assign(factor,rawFactor);
            current_statement_begin__ = 224;
            validate_non_negative_index("residualItemCor", "NITEMS", NITEMS);
            validate_non_negative_index("residualItemCor", "NITEMS", NITEMS);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> residualItemCor(NITEMS, NITEMS);
            stan::math::initialize(residualItemCor, DUMMY_VAR__);
            stan::math::fill(residualItemCor, DUMMY_VAR__);
            // generated quantities statements
            {
            current_statement_begin__ = 227;
            validate_non_negative_index("residual", "NPA", NPA);
            validate_non_negative_index("residual", "NITEMS", NITEMS);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> residual(NPA, NITEMS);
            stan::math::initialize(residual, DUMMY_VAR__);
            stan::math::fill(residual, DUMMY_VAR__);
            current_statement_begin__ = 228;
            for (int ix = 1; ix <= NITEMS; ++ix) {
                current_statement_begin__ = 229;
                stan::model::assign(residual, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            multiply(stan::model::rvalue(rawUniqueTheta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "rawUniqueTheta"), ((2 * get_base1(rawUnique, ix, "rawUnique", 1)) - 1)), 
                            "assigning variable residual");
                current_statement_begin__ = 230;
                stan::model::assign(residual, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            stan::model::deep_copy(subtract(stan::model::rvalue(residual, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "residual"), mean(stan::model::rvalue(residual, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "residual")))), 
                            "assigning variable residual");
                current_statement_begin__ = 231;
                stan::model::assign(residual, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), 
                            stan::model::deep_copy(divide(stan::model::rvalue(residual, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "residual"), sd(stan::model::rvalue(residual, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(ix), stan::model::nil_index_list())), "residual")))), 
                            "assigning variable residual");
            }
            current_statement_begin__ = 233;
            stan::math::assign(residualItemCor, crossprod(residual));
            current_statement_begin__ = 234;
            stan::math::assign(residualItemCor, quad_form_diag(residualItemCor, elt_divide(1.0, stan::math::sqrt(diagonal(residualItemCor)))));
            }
            {
            current_statement_begin__ = 238;
            validate_non_negative_index("pathLoadings", "NPATHS", NPATHS);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pathLoadings(NPATHS);
            stan::math::initialize(pathLoadings, DUMMY_VAR__);
            stan::math::fill(pathLoadings, DUMMY_VAR__);
            stan::math::assign(pathLoadings,subtract(multiply(2, rawLoadings), 1));
            current_statement_begin__ = 239;
            validate_non_negative_index("rawSeenFactor", "NFACTORS", NFACTORS);
            std::vector<int  > rawSeenFactor(NFACTORS, int(0));
            stan::math::fill(rawSeenFactor, std::numeric_limits<int>::min());
            current_statement_begin__ = 240;
            validate_non_negative_index("rawNegateFactor", "NFACTORS", NFACTORS);
            std::vector<int  > rawNegateFactor(NFACTORS, int(0));
            stan::math::fill(rawNegateFactor, std::numeric_limits<int>::min());
            current_statement_begin__ = 241;
            for (int fx = 1; fx <= NFACTORS; ++fx) {
                current_statement_begin__ = 241;
                stan::model::assign(rawSeenFactor, 
                            stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable rawSeenFactor");
            }
            current_statement_begin__ = 242;
            for (int px = 1; px <= NPATHS; ++px) {
                {
                current_statement_begin__ = 243;
                int fx(0);
                (void) fx;  // dummy to suppress unused var warning
                stan::math::fill(fx, std::numeric_limits<int>::min());
                stan::math::assign(fx,get_base1(get_base1(factorItemPath, 1, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 244;
                int ix(0);
                (void) ix;  // dummy to suppress unused var warning
                stan::math::fill(ix, std::numeric_limits<int>::min());
                stan::math::assign(ix,get_base1(get_base1(factorItemPath, 2, "factorItemPath", 1), px, "factorItemPath", 2));
                current_statement_begin__ = 245;
                if (as_bool(logical_eq(get_base1(rawSeenFactor, fx, "rawSeenFactor", 1), 0))) {
                    current_statement_begin__ = 246;
                    stan::model::assign(rawSeenFactor, 
                                stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list()), 
                                1, 
                                "assigning variable rawSeenFactor");
                    current_statement_begin__ = 247;
                    stan::model::assign(rawNegateFactor, 
                                stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list()), 
                                logical_lt(get_base1(rawLoadings, px, "rawLoadings", 1), 0.5), 
                                "assigning variable rawNegateFactor");
                }
                current_statement_begin__ = 249;
                if (as_bool(get_base1(rawNegateFactor, fx, "rawNegateFactor", 1))) {
                    current_statement_begin__ = 250;
                    stan::model::assign(pathLoadings, 
                                stan::model::cons_list(stan::model::index_uni(px), stan::model::nil_index_list()), 
                                -(get_base1(pathLoadings, px, "pathLoadings", 1)), 
                                "assigning variable pathLoadings");
                }
                }
            }
            current_statement_begin__ = 253;
            for (int fx = 1; fx <= NFACTORS; ++fx) {
                current_statement_begin__ = 254;
                if (as_bool(logical_negation(get_base1(rawNegateFactor, fx, "rawNegateFactor", 1)))) {
                    current_statement_begin__ = 254;
                    continue;
                }
                current_statement_begin__ = 255;
                stan::model::assign(factor, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), 
                            stan::model::deep_copy(minus(stan::model::rvalue(factor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "factor"))), 
                            "assigning variable factor");
            }
            current_statement_begin__ = 257;
            for (int fx = 1; fx <= NPATHS; ++fx) {
                current_statement_begin__ = 258;
                if (as_bool(logical_lt(get_base1(pathLoadings, fx, "pathLoadings", 1), 0))) {
                    current_statement_begin__ = 258;
                    stan::model::assign(pathProp, 
                                stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list()), 
                                -(get_base1(pathProp, fx, "pathProp", 1)), 
                                "assigning variable pathProp");
                }
            }
            }
            current_statement_begin__ = 261;
            for (int fx = 1; fx <= NFACTORS; ++fx) {
                current_statement_begin__ = 262;
                stan::model::assign(factor, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), 
                            stan::model::deep_copy(subtract(stan::model::rvalue(factor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "factor"), mean(stan::model::rvalue(factor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "factor")))), 
                            "assigning variable factor");
                current_statement_begin__ = 263;
                stan::model::assign(factor, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), 
                            stan::model::deep_copy(divide(stan::model::rvalue(factor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "factor"), sd(stan::model::rvalue(factor, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(fx), stan::model::nil_index_list())), "factor")))), 
                            "assigning variable factor");
            }
            // validate, write generated quantities
            current_statement_begin__ = 222;
            size_t pathProp_j_1_max__ = NPATHS;
            for (size_t j_1__ = 0; j_1__ < pathProp_j_1_max__; ++j_1__) {
                vars__.push_back(pathProp(j_1__));
            }
            current_statement_begin__ = 223;
            size_t factor_j_2_max__ = NFACTORS;
            size_t factor_j_1_max__ = NPA;
            for (size_t j_2__ = 0; j_2__ < factor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < factor_j_1_max__; ++j_1__) {
                    vars__.push_back(factor(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 224;
            size_t residualItemCor_j_2_max__ = NITEMS;
            size_t residualItemCor_j_1_max__ = NITEMS;
            for (size_t j_2__ = 0; j_2__ < residualItemCor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < residualItemCor_j_1_max__; ++j_1__) {
                    vars__.push_back(residualItemCor(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_factor1";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_k_0_max__ = NITEMS;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawThreshold_j_1_max__ = totalThresholds;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawThreshold" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawFactor_j_2_max__ = NFACTORS;
        size_t rawFactor_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawFactor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawFactor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawFactor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rawLoadings_j_1_max__ = NPATHS;
        for (size_t j_1__ = 0; j_1__ < rawLoadings_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawLoadings" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawUniqueTheta_j_2_max__ = NITEMS;
        size_t rawUniqueTheta_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawUniqueTheta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawUniqueTheta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawUniqueTheta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rawUnique_j_1_max__ = NITEMS;
        for (size_t j_1__ = 0; j_1__ < rawUnique_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawUnique" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t threshold_j_1_max__ = totalThresholds;
            for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "threshold" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rawCumTh_j_1_max__ = totalThresholds;
            for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawCumTh" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_2_max__ = NITEMS;
            size_t theta_j_1_max__ = NPA;
            for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rawPathProp_j_1_max__ = NPATHS;
            for (size_t j_1__ = 0; j_1__ < rawPathProp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawPathProp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rawPerComponentVar_k_0_max__ = NITEMS;
            size_t rawPerComponentVar_k_1_max__ = (1 + NFACTORS);
            for (size_t k_1__ = 0; k_1__ < rawPerComponentVar_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < rawPerComponentVar_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rawPerComponentVar" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t pathProp_j_1_max__ = NPATHS;
        for (size_t j_1__ = 0; j_1__ < pathProp_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pathProp" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t factor_j_2_max__ = NFACTORS;
        size_t factor_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < factor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < factor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "factor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t residualItemCor_j_2_max__ = NITEMS;
        size_t residualItemCor_j_1_max__ = NITEMS;
        for (size_t j_2__ = 0; j_2__ < residualItemCor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < residualItemCor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "residualItemCor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_k_0_max__ = NITEMS;
        for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawThreshold_j_1_max__ = totalThresholds;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawThreshold" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawFactor_j_2_max__ = NFACTORS;
        size_t rawFactor_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawFactor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawFactor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawFactor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rawLoadings_j_1_max__ = NPATHS;
        for (size_t j_1__ = 0; j_1__ < rawLoadings_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawLoadings" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawUniqueTheta_j_2_max__ = NITEMS;
        size_t rawUniqueTheta_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < rawUniqueTheta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rawUniqueTheta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawUniqueTheta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rawUnique_j_1_max__ = NITEMS;
        for (size_t j_1__ = 0; j_1__ < rawUnique_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawUnique" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t threshold_j_1_max__ = totalThresholds;
            for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "threshold" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rawCumTh_j_1_max__ = totalThresholds;
            for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawCumTh" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_2_max__ = NITEMS;
            size_t theta_j_1_max__ = NPA;
            for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rawPathProp_j_1_max__ = NPATHS;
            for (size_t j_1__ = 0; j_1__ < rawPathProp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawPathProp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rawPerComponentVar_k_0_max__ = NITEMS;
            size_t rawPerComponentVar_k_1_max__ = (1 + NFACTORS);
            for (size_t k_1__ = 0; k_1__ < rawPerComponentVar_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < rawPerComponentVar_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rawPerComponentVar" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t pathProp_j_1_max__ = NPATHS;
        for (size_t j_1__ = 0; j_1__ < pathProp_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pathProp" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t factor_j_2_max__ = NFACTORS;
        size_t factor_j_1_max__ = NPA;
        for (size_t j_2__ = 0; j_2__ < factor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < factor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "factor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t residualItemCor_j_2_max__ = NITEMS;
        size_t residualItemCor_j_1_max__ = NITEMS;
        for (size_t j_2__ = 0; j_2__ < residualItemCor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < residualItemCor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "residualItemCor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_factor1_namespace::model_factor1 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
