% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbr_me.R
\name{pbr_me}
\alias{pbr_me}
\alias{pbr_me_asap}
\title{Retrieve and print interactive map of closest locations}
\usage{
pbr_me(location, map = TRUE, ...)

pbr_me_asap()
}
\arguments{
\item{location}{A zip code, city name, or regular expression of such}

\item{map}{Logical. Output a leaflet map (TRUE, default) or not (FALSE)}

\item{...}{Additional arguments passed on to \code{\link{format_pbr_url}}}
}
\value{
A leaflet map displaying closest retailer locations, or (optionally) a
data.frame of retailer locations
}
\description{
These functions will retrieve and display the locations of the closest
outlets for a cold one. \code{pbr_me} requires a location to be input. This is handy for
when you're going somewhere and want to scout out the available outlets that
sell what you're looking for. \code{pbr_me_asap} is for when you just need a one now and don't
have time to enter your zip code.
}
\details{
\code{pbr_me} will display a \code{\link[leaflet]{leaflet}} map of the
closest retailer locations. If \code{map = FALSE} it will return a data.frame
of the locations. \code{pbr_me_asap} displays a leaflet map of retailer locations
within your current proximity for those moments when you just need a cold one now
}
\examples{
\donttest{
pbr_me(54481)
pbr_me_asap() # for when you just don't have time to enter your zip code
}
}
