% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_sd.r
\docType{methods}
\name{sd}
\alias{sd}
\alias{sd,ANY-method}
\alias{sd,ddmatrix-method}
\title{Covariance and Correlation}
\usage{
\S4method{sd}{ddmatrix}(x, na.rm = FALSE, reduce = FALSE,
  proc.dest = "all")

\S4method{sd}{ANY}(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric distributed matrices.}

\item{na.rm}{Logical; if TRUE, then \code{na.exclude()} is called first.}

\item{reduce}{logical or string. See details}

\item{proc.dest}{Destination process (or 'all') if a reduction occurs}
}
\value{
Returns a distributed matrix.
}
\description{
\code{sd()} will compute the standard deviations of the columns, equivalent
to calling \code{apply(x, MARGIN=2, FUN=sd)} (which will work for
distributed matrices, by the way). However, this should be much faster and
use less memory than \code{apply()}.  If \code{reduce=FALSE} then the return
is a distributed matrix consisting of one (global) row; otherwise, an
\code{R} vector is returned, with ownership of this vector determined by
\code{proc.dest}.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix("rnorm", nrow=3, ncol=3)

cv <- cov(x)
print(cv)

finalize()
}

}
\keyword{Methods}

