% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_na.r
\docType{methods}
\name{na}
\alias{na}
\alias{na.exclude}
\alias{na.exclude,ddmatrix-method}
\title{Handle Missing Values in Distributed Matrices}
\usage{
na.exclude(object, ...)

\S4method{na.exclude}{ddmatrix}(object, ..., ICTXT)
}
\arguments{
\item{object}{numeric distributed matrix}

\item{...}{extra arguments}

\item{ICTXT}{optional BLACS context number for output}
}
\description{
Dealing with NA's and NaN's.
}
\details{
Removes rows containing NA's and NaN's.

The function relies on reblocking across different BLACS contexts.  The
input distributed matrix will be redistributed along context 1, where
extracting/deleting rows does not destroy block-cyclicality.

Only advanced users should supply an \code{ICTXT} value. Most should simply
leave this argument blank.

The context of the return is dependent on the function arguments.  If the
\code{ICTXT=} argument is missing, then the return will be redistributed
across its input context \code{object@ICTXT}.  Otherwise, the return will be
redistributed across the supplied \code{ICTXT}.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:9, 3)
x[1, 1] <- NA
x <- as.ddmatrix(x)

y <- na.exclude(x)
comm.print(y)

finalize()
}

}
\keyword{Extraction}
\keyword{Methods}
\keyword{Type}

