% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.r
\name{base.ownany}
\alias{base.ownany}
\title{Determining Local Ownership of a Distributed Matrix}
\usage{
base.ownany(dim, bldim, ICTXT = 0)
}
\arguments{
\item{dim}{global dimension}

\item{bldim}{blocking dimension}

\item{ICTXT}{BLACS context}
}
\value{
TRUE or FALSE
}
\description{
For advanced users only. See pbdDMAT for high-level functions.
}
\details{
A simple wrapper of numroc. The return is the answer to
the question 'do I own any of the global matrix?'.  Passing a distributed
matrix is allowed, but often it is convenient to determine that information
without even having a distributed matrix on hand. In this case, explicitly
passing the appropriate information to the arguments \code{dim=},
\code{bldim=} (and \code{CTXT=} as necessary, since it defaults to 0) while
leaving \code{x} missing will produce the desired result. See the examples
below for more clarity.

The return for each function is local.
}
\examples{
spmd.code <- "
  suppressMessages(library(pbdMPI))
  suppressMessages(library(pbdBASE))
  init.grid()

  iown <- base.ownany(dim=c(4, 4), bldim=c(4, 4), ICTXT=0)
  comm.print(iown, all.rank = TRUE)

  finalize()
"
pbdMPI::execmpi(spmd.code = spmd.code, nranks = 2L)

}
\keyword{BLACS}
\keyword{Data}
\keyword{Distributing}
