% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{eventbridgepipes}
\alias{eventbridgepipes}
\title{Amazon EventBridge Pipes}
\usage{
eventbridgepipes(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon EventBridge Pipes connects event sources to targets. Pipes
reduces the need for specialized knowledge and integration code when
developing event driven architectures. This helps ensures consistency
across your company’s applications. With Pipes, the target can be any
available EventBridge target. To set up a pipe, you select the event
source, add optional event filtering, define optional enrichment, and
select the target for the event data.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- eventbridgepipes(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.application.integration:eventbridgepipes_create_pipe]{create_pipe} \tab Create a pipe\cr
\link[paws.application.integration:eventbridgepipes_delete_pipe]{delete_pipe} \tab Delete an existing pipe\cr
\link[paws.application.integration:eventbridgepipes_describe_pipe]{describe_pipe} \tab Get the information about an existing pipe\cr
\link[paws.application.integration:eventbridgepipes_list_pipes]{list_pipes} \tab Get the pipes associated with this account\cr
\link[paws.application.integration:eventbridgepipes_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with a pipe\cr
\link[paws.application.integration:eventbridgepipes_start_pipe]{start_pipe} \tab Start an existing pipe\cr
\link[paws.application.integration:eventbridgepipes_stop_pipe]{stop_pipe} \tab Stop an existing pipe\cr
\link[paws.application.integration:eventbridgepipes_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified pipe\cr
\link[paws.application.integration:eventbridgepipes_untag_resource]{untag_resource} \tab Removes one or more tags from the specified pipes\cr
\link[paws.application.integration:eventbridgepipes_update_pipe]{update_pipe} \tab Update an existing pipe
}
}

\examples{
\dontrun{
svc <- eventbridgepipes()
svc$create_pipe(
  Foo = 123
)
}

}
