% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{serverlessapplicationrepository}
\alias{serverlessapplicationrepository}
\title{AWSServerlessApplicationRepository}
\usage{
serverlessapplicationrepository(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
The AWS Serverless Application Repository makes it easy for developers
and enterprises to quickly find and deploy serverless applications in
the AWS Cloud. For more information about serverless applications, see
Serverless Computing and Applications on the AWS website.

The AWS Serverless Application Repository is deeply integrated with the
AWS Lambda console, so that developers of all levels can get started
with serverless computing without needing to learn anything new. You can
use category keywords to browse for applications such as web and mobile
backends, data processing applications, or chatbots. You can also search
for applications by name, publisher, or event source. To use an
application, you simply choose it, configure any required fields, and
deploy it with a few clicks.

You can also easily publish applications, sharing them publicly with the
community at large, or privately within your team or across your
organization. To publish a serverless application (or app), you can use
the AWS Management Console, AWS Command Line Interface (AWS CLI), or AWS
SDKs to upload the code. Along with the code, you upload a simple
manifest file, also known as the AWS Serverless Application Model (AWS
SAM) template. For more information about AWS SAM, see AWS Serverless
Application Model (AWS SAM) on the AWS Labs GitHub repository.

The AWS Serverless Application Repository Developer Guide contains more
information about the two developer experiences available:
\itemize{
\item Consuming Applications -- Browse for applications and view
information about them, including source code and readme files. Also
install, configure, and deploy applications of your choosing.

Publishing Applications -- Configure and upload applications to make
them available to other developers, and publish new versions of
applications.
}
}
\section{Service syntax}{
\preformatted{svc <- serverlessapplicationrepository(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=serverlessapplicationrepository_create_application]{create_application} \tab Creates an application, optionally including an AWS SAM file to create the first application version in the same call\cr
\link[=serverlessapplicationrepository_create_application_version]{create_application_version} \tab Creates an application version \cr
\link[=serverlessapplicationrepository_create_cloud_formation_change_set]{create_cloud_formation_change_set} \tab Creates an AWS CloudFormation change set for the given application \cr
\link[=serverlessapplicationrepository_create_cloud_formation_template]{create_cloud_formation_template} \tab Creates an AWS CloudFormation template \cr
\link[=serverlessapplicationrepository_delete_application]{delete_application} \tab Deletes the specified application \cr
\link[=serverlessapplicationrepository_get_application]{get_application} \tab Gets the specified application \cr
\link[=serverlessapplicationrepository_get_application_policy]{get_application_policy} \tab Retrieves the policy for the application \cr
\link[=serverlessapplicationrepository_get_cloud_formation_template]{get_cloud_formation_template} \tab Gets the specified AWS CloudFormation template \cr
\link[=serverlessapplicationrepository_list_application_dependencies]{list_application_dependencies} \tab Retrieves the list of applications nested in the containing application \cr
\link[=serverlessapplicationrepository_list_applications]{list_applications} \tab Lists applications owned by the requester \cr
\link[=serverlessapplicationrepository_list_application_versions]{list_application_versions} \tab Lists versions for the specified application \cr
\link[=serverlessapplicationrepository_put_application_policy]{put_application_policy} \tab Sets the permission policy for an application \cr
\link[=serverlessapplicationrepository_update_application]{update_application} \tab Updates the specified application
}
}

\examples{
\dontrun{
svc <- serverlessapplicationrepository()
svc$create_application(
  Foo = 123
)
}

}
