% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{s3control}
\alias{s3control}
\title{AWS S3 Control}
\usage{
s3control(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS S3 Control provides access to Amazon S3 control plane operations.
}
\section{Service syntax}{
\preformatted{svc <- s3control(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=s3control_create_job]{create_job} \tab Creates an Amazon S3 batch operations job \cr
\link[=s3control_delete_public_access_block]{delete_public_access_block} \tab Deletes the block public access configuration for the specified account \cr
\link[=s3control_describe_job]{describe_job} \tab Retrieves the configuration parameters and status for a batch operations job \cr
\link[=s3control_get_public_access_block]{get_public_access_block} \tab Get public access block \cr
\link[=s3control_list_jobs]{list_jobs} \tab Lists current jobs and jobs that have ended within the last 30 days for the AWS account making the request\cr
\link[=s3control_put_public_access_block]{put_public_access_block} \tab Put public access block \cr
\link[=s3control_update_job_priority]{update_job_priority} \tab Updates an existing job's priority \cr
\link[=s3control_update_job_status]{update_job_status} \tab Updates the status for the specified job
}
}

\examples{
\donttest{svc <- s3control()
svc$create_job(
  Foo = 123
)}

}
