% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securitylake_operations.R
\name{securitylake_update_data_lake}
\alias{securitylake_update_data_lake}
\title{You can use UpdateDataLake to specify where to store your security data,
how it should be encrypted at rest and for how long}
\usage{
securitylake_update_data_lake(configurations, metaStoreManagerRoleArn = NULL)
}
\arguments{
\item{configurations}{[required] Specifies the Region or Regions that will contribute data to the rollup
region.}

\item{metaStoreManagerRoleArn}{The Amazon Resource Name (ARN) used to create and update the Glue table.
This table contains partitions generated by the ingestion and
normalization of Amazon Web Services log sources and custom sources.}
}
\description{
You can use \code{\link[=securitylake_update_data_lake]{update_data_lake}} to specify where to store your security data, how it should be encrypted at rest and for how long. You can add a \href{https://docs.aws.amazon.com/security-lake/latest/userguide/manage-regions.html#add-rollup-region}{Rollup Region} to consolidate data from multiple Amazon Web Services Regions, replace default encryption (SSE-S3) with \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{Customer Manged Key}, or specify transition and expiration actions through storage \href{https://docs.aws.amazon.com/security-lake/latest/userguide/lifecycle-management.html}{Lifecycle management}. The \code{\link[=securitylake_update_data_lake]{update_data_lake}} API works as an "upsert" operation that performs an insert if the specified item or record does not exist, or an update if it already exists. Security Lake securely stores your data at rest using Amazon Web Services encryption solutions. For more details, see \href{https://docs.aws.amazon.com/security-lake/latest/userguide/data-protection.html}{Data protection in Amazon Security Lake}.

See \url{https://www.paws-r-sdk.com/docs/securitylake_update_data_lake/} for full documentation.
}
\keyword{internal}
