% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_signing_certificate}
\alias{iam_delete_signing_certificate}
\title{Deletes a signing certificate associated with the specified IAM user}
\usage{
iam_delete_signing_certificate(UserName = NULL, CertificateId)
}
\arguments{
\item{UserName}{The name of the user the signing certificate belongs to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{CertificateId}{[required] The ID of the signing certificate to delete.

The format of this parameter, as described by its
\href{https://en.wikipedia.org/wiki/Regex}{regex} pattern, is a string of
characters that can be upper- or lower-cased letters or digits.}
}
\description{
Deletes a signing certificate associated with the specified IAM user.

See \url{https://www.paws-r-sdk.com/docs/iam_delete_signing_certificate/} for full documentation.
}
\keyword{internal}
