# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include wafv2_service.R
NULL

#' Associates a web ACL with a regional application resource, to protect
#' the resource
#'
#' @description
#' Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_associate_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_associate_web_acl/) for full documentation.
#'
#' @param WebACLArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL that you want to associate
#' with the resource.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to associate with the web
#' ACL.
#' 
#' The ARN must be in one of the following formats:
#' 
#' -   For an Application Load Balancer:
#'     `arn:partition:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id `
#' 
#' -   For an Amazon API Gateway REST API:
#'     `arn:partition:apigateway:region::/restapis/api-id/stages/stage-name `
#' 
#' -   For an AppSync GraphQL API:
#'     `arn:partition:appsync:region:account-id:apis/GraphQLApiId `
#' 
#' -   For an Amazon Cognito user pool:
#'     `arn:partition:cognito-idp:region:account-id:userpool/user-pool-id `
#' 
#' -   For an App Runner service:
#'     `arn:partition:apprunner:region:account-id:service/apprunner-service-name/apprunner-service-id `
#' 
#' -   For an Amazon Web Services Verified Access instance:
#'     `arn:partition:ec2:region:account-id:verified-access-instance/instance-id `
#'
#' @keywords internal
#'
#' @rdname wafv2_associate_web_acl
wafv2_associate_web_acl <- function(WebACLArn, ResourceArn) {
  op <- new_operation(
    name = "AssociateWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$associate_web_acl_input(WebACLArn = WebACLArn, ResourceArn = ResourceArn)
  output <- .wafv2$associate_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$associate_web_acl <- wafv2_associate_web_acl

#' Returns the web ACL capacity unit (WCU) requirements for a specified
#' scope and set of rules
#'
#' @description
#' Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a RuleGroup or WebACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_check_capacity/](https://www.paws-r-sdk.com/docs/wafv2_check_capacity/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Rules &#91;required&#93; An array of Rule that you're configuring to use in a rule group or web
#' ACL.
#'
#' @keywords internal
#'
#' @rdname wafv2_check_capacity
wafv2_check_capacity <- function(Scope, Rules) {
  op <- new_operation(
    name = "CheckCapacity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$check_capacity_input(Scope = Scope, Rules = Rules)
  output <- .wafv2$check_capacity_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$check_capacity <- wafv2_check_capacity

#' Creates an API key that contains a set of token domains
#'
#' @description
#' Creates an API key that contains a set of token domains.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_create_api_key/](https://www.paws-r-sdk.com/docs/wafv2_create_api_key/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param TokenDomains &#91;required&#93; The client application domains that you want to use this API key for.
#' 
#' Example JSON: `"TokenDomains": ["abc.com", "store.abc.com"]`
#' 
#' Public suffixes aren't allowed. For example, you can't use `gov.au` or
#' `co.uk` as token domains.
#'
#' @keywords internal
#'
#' @rdname wafv2_create_api_key
wafv2_create_api_key <- function(Scope, TokenDomains) {
  op <- new_operation(
    name = "CreateAPIKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$create_api_key_input(Scope = Scope, TokenDomains = TokenDomains)
  output <- .wafv2$create_api_key_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$create_api_key <- wafv2_create_api_key

#' Creates an IPSet, which you use to identify web requests that originate
#' from specific IP addresses or ranges of IP addresses
#'
#' @description
#' Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_create_ip_set/](https://www.paws-r-sdk.com/docs/wafv2_create_ip_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the IP set. You cannot change the name of an `IPSet` after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Description A description of the IP set that helps with identification.
#' @param IPAddressVersion &#91;required&#93; The version of the IP addresses, either `IPV4` or `IPV6`.
#' @param Addresses &#91;required&#93; Contains an array of strings that specifies zero or more IP addresses or
#' blocks of IP addresses that you want WAF to inspect for in incoming
#' requests. All addresses must be specified using Classless Inter-Domain
#' Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges
#' except for `/0`.
#' 
#' Example address strings:
#' 
#' -   For requests that originated from the IP address 192.0.2.44, specify
#'     `192.0.2.44/32`.
#' 
#' -   For requests that originated from IP addresses from 192.0.2.0 to
#'     192.0.2.255, specify `192.0.2.0/24`.
#' 
#' -   For requests that originated from the IP address
#'     1111:0000:0000:0000:0000:0000:0000:0111, specify
#'     `1111:0000:0000:0000:0000:0000:0000:0111/128`.
#' 
#' -   For requests that originated from IP addresses
#'     1111:0000:0000:0000:0000:0000:0000:0000 to
#'     1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
#'     `1111:0000:0000:0000:0000:0000:0000:0000/64`.
#' 
#' For more information about CIDR notation, see the Wikipedia entry
#' [Classless Inter-Domain
#' Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#' 
#' Example JSON `Addresses` specifications:
#' 
#' -   Empty array: `"Addresses": []`
#' 
#' -   Array with one address: `"Addresses": ["192.0.2.44/32"]`
#' 
#' -   Array with three addresses:
#'     `"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`
#' 
#' -   INVALID specification: `"Addresses": [""]` INVALID
#' @param Tags An array of key:value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname wafv2_create_ip_set
wafv2_create_ip_set <- function(Name, Scope, Description = NULL, IPAddressVersion, Addresses, Tags = NULL) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$create_ip_set_input(Name = Name, Scope = Scope, Description = Description, IPAddressVersion = IPAddressVersion, Addresses = Addresses, Tags = Tags)
  output <- .wafv2$create_ip_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$create_ip_set <- wafv2_create_ip_set

#' Creates a RegexPatternSet, which you reference in a
#' RegexPatternSetReferenceStatement, to have WAF inspect a web request
#' component for the specified patterns
#'
#' @description
#' Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_create_regex_pattern_set/](https://www.paws-r-sdk.com/docs/wafv2_create_regex_pattern_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the set. You cannot change the name after you create the
#' set.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Description A description of the set that helps with identification.
#' @param RegularExpressionList &#91;required&#93; Array of regular expression strings.
#' @param Tags An array of key:value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname wafv2_create_regex_pattern_set
wafv2_create_regex_pattern_set <- function(Name, Scope, Description = NULL, RegularExpressionList, Tags = NULL) {
  op <- new_operation(
    name = "CreateRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$create_regex_pattern_set_input(Name = Name, Scope = Scope, Description = Description, RegularExpressionList = RegularExpressionList, Tags = Tags)
  output <- .wafv2$create_regex_pattern_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$create_regex_pattern_set <- wafv2_create_regex_pattern_set

#' Creates a RuleGroup per the specifications provided
#'
#' @description
#' Creates a RuleGroup per the specifications provided.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_create_rule_group/](https://www.paws-r-sdk.com/docs/wafv2_create_rule_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule group. You cannot change the name of a rule group
#' after you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Capacity &#91;required&#93; The web ACL capacity units (WCUs) required for this rule group.
#' 
#' When you create your own rule group, you define this, and you cannot
#' change it after creation. When you add or modify the rules in a rule
#' group, WAF enforces this limit. You can check the capacity for a set of
#' rules using [`check_capacity`][wafv2_check_capacity].
#' 
#' WAF uses WCUs to calculate and control the operating resources that are
#' used to run your rules, rule groups, and web ACLs. WAF calculates
#' capacity differently for each rule type, to reflect the relative cost of
#' each rule. Simple rules that cost little to run use fewer WCUs than more
#' complex rules that use more processing power. Rule group capacity is
#' fixed at creation, which helps users plan their web ACL WCU usage when
#' they use a rule group. For more information, see [WAF web ACL capacity
#' units
#' (WCU)](https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html)
#' in the *WAF Developer Guide*.
#' @param Description A description of the rule group that helps with identification.
#' @param Rules The Rule statements used to identify the web requests that you want to
#' manage. Each rule includes one top-level statement that WAF uses to
#' identify matching web requests, and parameters that govern how WAF
#' handles them.
#' @param VisibilityConfig &#91;required&#93; Defines and enables Amazon CloudWatch metrics and web request sample
#' collection.
#' @param Tags An array of key:value pairs to associate with the resource.
#' @param CustomResponseBodies A map of custom response keys and content bodies. When you create a rule
#' with a block action, you can send a custom response to the web request.
#' You define these for the rule group, and then use them in the rules that
#' you define in the rule group.
#' 
#' For information about customizing web requests and responses, see
#' [Customizing web requests and responses in
#' WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
#' in the *WAF Developer Guide*.
#' 
#' For information about the limits on count and size for custom request
#' and response settings, see [WAF
#' quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
#' in the *WAF Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname wafv2_create_rule_group
wafv2_create_rule_group <- function(Name, Scope, Capacity, Description = NULL, Rules = NULL, VisibilityConfig, Tags = NULL, CustomResponseBodies = NULL) {
  op <- new_operation(
    name = "CreateRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$create_rule_group_input(Name = Name, Scope = Scope, Capacity = Capacity, Description = Description, Rules = Rules, VisibilityConfig = VisibilityConfig, Tags = Tags, CustomResponseBodies = CustomResponseBodies)
  output <- .wafv2$create_rule_group_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$create_rule_group <- wafv2_create_rule_group

#' Creates a WebACL per the specifications provided
#'
#' @description
#' Creates a WebACL per the specifications provided.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_create_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_create_web_acl/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the web ACL. You cannot change the name of a web ACL after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param DefaultAction &#91;required&#93; The action to perform if none of the `Rules` contained in the `WebACL`
#' match.
#' @param Description A description of the web ACL that helps with identification.
#' @param Rules The Rule statements used to identify the web requests that you want to
#' manage. Each rule includes one top-level statement that WAF uses to
#' identify matching web requests, and parameters that govern how WAF
#' handles them.
#' @param VisibilityConfig &#91;required&#93; Defines and enables Amazon CloudWatch metrics and web request sample
#' collection.
#' @param Tags An array of key:value pairs to associate with the resource.
#' @param CustomResponseBodies A map of custom response keys and content bodies. When you create a rule
#' with a block action, you can send a custom response to the web request.
#' You define these for the web ACL, and then use them in the rules and
#' default actions that you define in the web ACL.
#' 
#' For information about customizing web requests and responses, see
#' [Customizing web requests and responses in
#' WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
#' in the *WAF Developer Guide*.
#' 
#' For information about the limits on count and size for custom request
#' and response settings, see [WAF
#' quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
#' in the *WAF Developer Guide*.
#' @param CaptchaConfig Specifies how WAF should handle `CAPTCHA` evaluations for rules that
#' don't have their own `CaptchaConfig` settings. If you don't specify
#' this, WAF uses its default settings for `CaptchaConfig`.
#' @param ChallengeConfig Specifies how WAF should handle challenge evaluations for rules that
#' don't have their own `ChallengeConfig` settings. If you don't specify
#' this, WAF uses its default settings for `ChallengeConfig`.
#' @param TokenDomains Specifies the domains that WAF should accept in a web request token.
#' This enables the use of tokens across multiple protected websites. When
#' WAF provides a token, it uses the domain of the Amazon Web Services
#' resource that the web ACL is protecting. If you don't specify a list of
#' token domains, WAF accepts tokens only for the domain of the protected
#' resource. With a token domain list, WAF accepts the resource's host
#' domain plus all domains in the token domain list, including their
#' prefixed subdomains.
#' 
#' Example JSON:
#' `"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }`
#' 
#' Public suffixes aren't allowed. For example, you can't use `gov.au` or
#' `co.uk` as token domains.
#' @param AssociationConfig Specifies custom configurations for the associations between the web ACL
#' and protected resources.
#' 
#' Use this to customize the maximum size of the request body that your
#' protected resources forward to WAF for inspection. You can customize
#' this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or
#' Verified Access resources. The default setting is 16 KB (16,384 bytes).
#' 
#' You are charged additional fees when your protected resources forward
#' body sizes that are larger than the default. For more information, see
#' [WAF Pricing](https://aws.amazon.com/waf/pricing/).
#' 
#' For Application Load Balancer and AppSync, the limit is fixed at 8 KB
#' (8,192 bytes).
#'
#' @keywords internal
#'
#' @rdname wafv2_create_web_acl
wafv2_create_web_acl <- function(Name, Scope, DefaultAction, Description = NULL, Rules = NULL, VisibilityConfig, Tags = NULL, CustomResponseBodies = NULL, CaptchaConfig = NULL, ChallengeConfig = NULL, TokenDomains = NULL, AssociationConfig = NULL) {
  op <- new_operation(
    name = "CreateWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$create_web_acl_input(Name = Name, Scope = Scope, DefaultAction = DefaultAction, Description = Description, Rules = Rules, VisibilityConfig = VisibilityConfig, Tags = Tags, CustomResponseBodies = CustomResponseBodies, CaptchaConfig = CaptchaConfig, ChallengeConfig = ChallengeConfig, TokenDomains = TokenDomains, AssociationConfig = AssociationConfig)
  output <- .wafv2$create_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$create_web_acl <- wafv2_create_web_acl

#' Deletes the specified API key
#'
#' @description
#' Deletes the specified API key.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_api_key/](https://www.paws-r-sdk.com/docs/wafv2_delete_api_key/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param APIKey &#91;required&#93; The encrypted API key that you want to delete.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_api_key
wafv2_delete_api_key <- function(Scope, APIKey) {
  op <- new_operation(
    name = "DeleteAPIKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_api_key_input(Scope = Scope, APIKey = APIKey)
  output <- .wafv2$delete_api_key_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_api_key <- wafv2_delete_api_key

#' Deletes all rule groups that are managed by Firewall Manager from the
#' specified WebACL
#'
#' @description
#' Deletes all rule groups that are managed by Firewall Manager from the specified WebACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_firewall_manager_rule_groups/](https://www.paws-r-sdk.com/docs/wafv2_delete_firewall_manager_rule_groups/) for full documentation.
#'
#' @param WebACLArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL.
#' @param WebACLLockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_firewall_manager_rule_groups
wafv2_delete_firewall_manager_rule_groups <- function(WebACLArn, WebACLLockToken) {
  op <- new_operation(
    name = "DeleteFirewallManagerRuleGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_firewall_manager_rule_groups_input(WebACLArn = WebACLArn, WebACLLockToken = WebACLLockToken)
  output <- .wafv2$delete_firewall_manager_rule_groups_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_firewall_manager_rule_groups <- wafv2_delete_firewall_manager_rule_groups

#' Deletes the specified IPSet
#'
#' @description
#' Deletes the specified IPSet.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_ip_set/](https://www.paws-r-sdk.com/docs/wafv2_delete_ip_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the IP set. You cannot change the name of an `IPSet` after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the set. This ID is returned in the responses to
#' create and list commands. You provide it to operations like update and
#' delete.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_ip_set
wafv2_delete_ip_set <- function(Name, Scope, Id, LockToken) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_ip_set_input(Name = Name, Scope = Scope, Id = Id, LockToken = LockToken)
  output <- .wafv2$delete_ip_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_ip_set <- wafv2_delete_ip_set

#' Deletes the LoggingConfiguration from the specified web ACL
#'
#' @description
#' Deletes the LoggingConfiguration from the specified web ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_logging_configuration/](https://www.paws-r-sdk.com/docs/wafv2_delete_logging_configuration/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL from which you want to
#' delete the LoggingConfiguration.
#' @param LogType Used to distinguish between various logging options. Currently, there is
#' one option.
#' 
#' Default: `WAF_LOGS`
#' @param LogScope The owner of the logging configuration, which must be set to `CUSTOMER`
#' for the configurations that you manage.
#' 
#' The log scope `SECURITY_LAKE` indicates a configuration that is managed
#' through Amazon Security Lake. You can use Security Lake to collect log
#' and event data from various sources for normalization, analysis, and
#' management. For information, see [Collecting data from Amazon Web
#' Services
#' services](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html)
#' in the *Amazon Security Lake user guide*.
#' 
#' Default: `CUSTOMER`
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_logging_configuration
wafv2_delete_logging_configuration <- function(ResourceArn, LogType = NULL, LogScope = NULL) {
  op <- new_operation(
    name = "DeleteLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_logging_configuration_input(ResourceArn = ResourceArn, LogType = LogType, LogScope = LogScope)
  output <- .wafv2$delete_logging_configuration_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_logging_configuration <- wafv2_delete_logging_configuration

#' Permanently deletes an IAM policy from the specified rule group
#'
#' @description
#' Permanently deletes an IAM policy from the specified rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_permission_policy/](https://www.paws-r-sdk.com/docs/wafv2_delete_permission_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the rule group from which you want to
#' delete the policy.
#' 
#' You must be the owner of the rule group to perform this operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_permission_policy
wafv2_delete_permission_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeletePermissionPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_permission_policy_input(ResourceArn = ResourceArn)
  output <- .wafv2$delete_permission_policy_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_permission_policy <- wafv2_delete_permission_policy

#' Deletes the specified RegexPatternSet
#'
#' @description
#' Deletes the specified RegexPatternSet.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_regex_pattern_set/](https://www.paws-r-sdk.com/docs/wafv2_delete_regex_pattern_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the set. You cannot change the name after you create the
#' set.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the set. This ID is returned in the responses to
#' create and list commands. You provide it to operations like update and
#' delete.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_regex_pattern_set
wafv2_delete_regex_pattern_set <- function(Name, Scope, Id, LockToken) {
  op <- new_operation(
    name = "DeleteRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_regex_pattern_set_input(Name = Name, Scope = Scope, Id = Id, LockToken = LockToken)
  output <- .wafv2$delete_regex_pattern_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_regex_pattern_set <- wafv2_delete_regex_pattern_set

#' Deletes the specified RuleGroup
#'
#' @description
#' Deletes the specified RuleGroup.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_rule_group/](https://www.paws-r-sdk.com/docs/wafv2_delete_rule_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule group. You cannot change the name of a rule group
#' after you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the rule group. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_rule_group
wafv2_delete_rule_group <- function(Name, Scope, Id, LockToken) {
  op <- new_operation(
    name = "DeleteRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_rule_group_input(Name = Name, Scope = Scope, Id = Id, LockToken = LockToken)
  output <- .wafv2$delete_rule_group_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_rule_group <- wafv2_delete_rule_group

#' Deletes the specified WebACL
#'
#' @description
#' Deletes the specified WebACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_delete_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_delete_web_acl/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the web ACL. You cannot change the name of a web ACL after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; The unique identifier for the web ACL. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_delete_web_acl
wafv2_delete_web_acl <- function(Name, Scope, Id, LockToken) {
  op <- new_operation(
    name = "DeleteWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$delete_web_acl_input(Name = Name, Scope = Scope, Id = Id, LockToken = LockToken)
  output <- .wafv2$delete_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$delete_web_acl <- wafv2_delete_web_acl

#' Provides high-level information for the Amazon Web Services Managed
#' Rules rule groups and Amazon Web Services Marketplace managed rule
#' groups
#'
#' @description
#' Provides high-level information for the Amazon Web Services Managed Rules rule groups and Amazon Web Services Marketplace managed rule groups.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_describe_all_managed_products/](https://www.paws-r-sdk.com/docs/wafv2_describe_all_managed_products/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#'
#' @keywords internal
#'
#' @rdname wafv2_describe_all_managed_products
wafv2_describe_all_managed_products <- function(Scope) {
  op <- new_operation(
    name = "DescribeAllManagedProducts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$describe_all_managed_products_input(Scope = Scope)
  output <- .wafv2$describe_all_managed_products_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$describe_all_managed_products <- wafv2_describe_all_managed_products

#' Provides high-level information for the managed rule groups owned by a
#' specific vendor
#'
#' @description
#' Provides high-level information for the managed rule groups owned by a specific vendor.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_describe_managed_products_by_vendor/](https://www.paws-r-sdk.com/docs/wafv2_describe_managed_products_by_vendor/) for full documentation.
#'
#' @param VendorName &#91;required&#93; The name of the managed rule group vendor. You use this, along with the
#' rule group name, to identify a rule group.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#'
#' @keywords internal
#'
#' @rdname wafv2_describe_managed_products_by_vendor
wafv2_describe_managed_products_by_vendor <- function(VendorName, Scope) {
  op <- new_operation(
    name = "DescribeManagedProductsByVendor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$describe_managed_products_by_vendor_input(VendorName = VendorName, Scope = Scope)
  output <- .wafv2$describe_managed_products_by_vendor_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$describe_managed_products_by_vendor <- wafv2_describe_managed_products_by_vendor

#' Provides high-level information for a managed rule group, including
#' descriptions of the rules
#'
#' @description
#' Provides high-level information for a managed rule group, including descriptions of the rules.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_describe_managed_rule_group/](https://www.paws-r-sdk.com/docs/wafv2_describe_managed_rule_group/) for full documentation.
#'
#' @param VendorName &#91;required&#93; The name of the managed rule group vendor. You use this, along with the
#' rule group name, to identify a rule group.
#' @param Name &#91;required&#93; The name of the managed rule group. You use this, along with the vendor
#' name, to identify the rule group.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param VersionName The version of the rule group. You can only use a version that is not
#' scheduled for expiration. If you don't provide this, WAF uses the
#' vendor's default version.
#'
#' @keywords internal
#'
#' @rdname wafv2_describe_managed_rule_group
wafv2_describe_managed_rule_group <- function(VendorName, Name, Scope, VersionName = NULL) {
  op <- new_operation(
    name = "DescribeManagedRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$describe_managed_rule_group_input(VendorName = VendorName, Name = Name, Scope = Scope, VersionName = VersionName)
  output <- .wafv2$describe_managed_rule_group_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$describe_managed_rule_group <- wafv2_describe_managed_rule_group

#' Disassociates the specified regional application resource from any
#' existing web ACL association
#'
#' @description
#' Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool, an App Runner service, or an Amazon Web Services Verified Access instance.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_disassociate_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_disassociate_web_acl/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to disassociate from the
#' web ACL.
#' 
#' The ARN must be in one of the following formats:
#' 
#' -   For an Application Load Balancer:
#'     `arn:partition:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id `
#' 
#' -   For an Amazon API Gateway REST API:
#'     `arn:partition:apigateway:region::/restapis/api-id/stages/stage-name `
#' 
#' -   For an AppSync GraphQL API:
#'     `arn:partition:appsync:region:account-id:apis/GraphQLApiId `
#' 
#' -   For an Amazon Cognito user pool:
#'     `arn:partition:cognito-idp:region:account-id:userpool/user-pool-id `
#' 
#' -   For an App Runner service:
#'     `arn:partition:apprunner:region:account-id:service/apprunner-service-name/apprunner-service-id `
#' 
#' -   For an Amazon Web Services Verified Access instance:
#'     `arn:partition:ec2:region:account-id:verified-access-instance/instance-id `
#'
#' @keywords internal
#'
#' @rdname wafv2_disassociate_web_acl
wafv2_disassociate_web_acl <- function(ResourceArn) {
  op <- new_operation(
    name = "DisassociateWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$disassociate_web_acl_input(ResourceArn = ResourceArn)
  output <- .wafv2$disassociate_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$disassociate_web_acl <- wafv2_disassociate_web_acl

#' Generates a presigned download URL for the specified release of the
#' mobile SDK
#'
#' @description
#' Generates a presigned download URL for the specified release of the mobile SDK.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_generate_mobile_sdk_release_url/](https://www.paws-r-sdk.com/docs/wafv2_generate_mobile_sdk_release_url/) for full documentation.
#'
#' @param Platform &#91;required&#93; The device platform.
#' @param ReleaseVersion &#91;required&#93; The release version. For the latest available version, specify `LATEST`.
#'
#' @keywords internal
#'
#' @rdname wafv2_generate_mobile_sdk_release_url
wafv2_generate_mobile_sdk_release_url <- function(Platform, ReleaseVersion) {
  op <- new_operation(
    name = "GenerateMobileSdkReleaseUrl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$generate_mobile_sdk_release_url_input(Platform = Platform, ReleaseVersion = ReleaseVersion)
  output <- .wafv2$generate_mobile_sdk_release_url_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$generate_mobile_sdk_release_url <- wafv2_generate_mobile_sdk_release_url

#' Returns your API key in decrypted form
#'
#' @description
#' Returns your API key in decrypted form. Use this to check the token domains that you have defined for the key.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_decrypted_api_key/](https://www.paws-r-sdk.com/docs/wafv2_get_decrypted_api_key/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param APIKey &#91;required&#93; The encrypted API key.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_decrypted_api_key
wafv2_get_decrypted_api_key <- function(Scope, APIKey) {
  op <- new_operation(
    name = "GetDecryptedAPIKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_decrypted_api_key_input(Scope = Scope, APIKey = APIKey)
  output <- .wafv2$get_decrypted_api_key_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_decrypted_api_key <- wafv2_get_decrypted_api_key

#' Retrieves the specified IPSet
#'
#' @description
#' Retrieves the specified IPSet.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_ip_set/](https://www.paws-r-sdk.com/docs/wafv2_get_ip_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the IP set. You cannot change the name of an `IPSet` after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the set. This ID is returned in the responses to
#' create and list commands. You provide it to operations like update and
#' delete.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_ip_set
wafv2_get_ip_set <- function(Name, Scope, Id) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_ip_set_input(Name = Name, Scope = Scope, Id = Id)
  output <- .wafv2$get_ip_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_ip_set <- wafv2_get_ip_set

#' Returns the LoggingConfiguration for the specified web ACL
#'
#' @description
#' Returns the LoggingConfiguration for the specified web ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_logging_configuration/](https://www.paws-r-sdk.com/docs/wafv2_get_logging_configuration/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL for which you want to get
#' the LoggingConfiguration.
#' @param LogType Used to distinguish between various logging options. Currently, there is
#' one option.
#' 
#' Default: `WAF_LOGS`
#' @param LogScope The owner of the logging configuration, which must be set to `CUSTOMER`
#' for the configurations that you manage.
#' 
#' The log scope `SECURITY_LAKE` indicates a configuration that is managed
#' through Amazon Security Lake. You can use Security Lake to collect log
#' and event data from various sources for normalization, analysis, and
#' management. For information, see [Collecting data from Amazon Web
#' Services
#' services](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html)
#' in the *Amazon Security Lake user guide*.
#' 
#' Default: `CUSTOMER`
#'
#' @keywords internal
#'
#' @rdname wafv2_get_logging_configuration
wafv2_get_logging_configuration <- function(ResourceArn, LogType = NULL, LogScope = NULL) {
  op <- new_operation(
    name = "GetLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_logging_configuration_input(ResourceArn = ResourceArn, LogType = LogType, LogScope = LogScope)
  output <- .wafv2$get_logging_configuration_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_logging_configuration <- wafv2_get_logging_configuration

#' Retrieves the specified managed rule set
#'
#' @description
#' Retrieves the specified managed rule set.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_managed_rule_set/](https://www.paws-r-sdk.com/docs/wafv2_get_managed_rule_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the managed rule set. You use this, along with the rule set
#' ID, to identify the rule set.
#' 
#' This name is assigned to the corresponding managed rule group, which
#' your customers can access and use.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the managed rule set. The ID is returned in the
#' responses to commands like `list`. You provide it to operations like
#' `get` and `update`.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_managed_rule_set
wafv2_get_managed_rule_set <- function(Name, Scope, Id) {
  op <- new_operation(
    name = "GetManagedRuleSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_managed_rule_set_input(Name = Name, Scope = Scope, Id = Id)
  output <- .wafv2$get_managed_rule_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_managed_rule_set <- wafv2_get_managed_rule_set

#' Retrieves information for the specified mobile SDK release, including
#' release notes and tags
#'
#' @description
#' Retrieves information for the specified mobile SDK release, including release notes and tags.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_mobile_sdk_release/](https://www.paws-r-sdk.com/docs/wafv2_get_mobile_sdk_release/) for full documentation.
#'
#' @param Platform &#91;required&#93; The device platform.
#' @param ReleaseVersion &#91;required&#93; The release version. For the latest available version, specify `LATEST`.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_mobile_sdk_release
wafv2_get_mobile_sdk_release <- function(Platform, ReleaseVersion) {
  op <- new_operation(
    name = "GetMobileSdkRelease",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_mobile_sdk_release_input(Platform = Platform, ReleaseVersion = ReleaseVersion)
  output <- .wafv2$get_mobile_sdk_release_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_mobile_sdk_release <- wafv2_get_mobile_sdk_release

#' Returns the IAM policy that is attached to the specified rule group
#'
#' @description
#' Returns the IAM policy that is attached to the specified rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_permission_policy/](https://www.paws-r-sdk.com/docs/wafv2_get_permission_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the rule group for which you want to
#' get the policy.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_permission_policy
wafv2_get_permission_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetPermissionPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_permission_policy_input(ResourceArn = ResourceArn)
  output <- .wafv2$get_permission_policy_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_permission_policy <- wafv2_get_permission_policy

#' Retrieves the IP addresses that are currently blocked by a rate-based
#' rule instance
#'
#' @description
#' Retrieves the IP addresses that are currently blocked by a rate-based rule instance. This is only available for rate-based rules that aggregate solely on the IP address or on the forwarded IP address.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_rate_based_statement_managed_keys/](https://www.paws-r-sdk.com/docs/wafv2_get_rate_based_statement_managed_keys/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param WebACLName &#91;required&#93; The name of the web ACL. You cannot change the name of a web ACL after
#' you create it.
#' @param WebACLId &#91;required&#93; The unique identifier for the web ACL. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#' @param RuleGroupRuleName The name of the rule group reference statement in your web ACL. This is
#' required only when you have the rate-based rule nested inside a rule
#' group.
#' @param RuleName &#91;required&#93; The name of the rate-based rule to get the keys for. If you have the
#' rule defined inside a rule group that you're using in your web ACL, also
#' provide the name of the rule group reference statement in the request
#' parameter `RuleGroupRuleName`.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_rate_based_statement_managed_keys
wafv2_get_rate_based_statement_managed_keys <- function(Scope, WebACLName, WebACLId, RuleGroupRuleName = NULL, RuleName) {
  op <- new_operation(
    name = "GetRateBasedStatementManagedKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_rate_based_statement_managed_keys_input(Scope = Scope, WebACLName = WebACLName, WebACLId = WebACLId, RuleGroupRuleName = RuleGroupRuleName, RuleName = RuleName)
  output <- .wafv2$get_rate_based_statement_managed_keys_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_rate_based_statement_managed_keys <- wafv2_get_rate_based_statement_managed_keys

#' Retrieves the specified RegexPatternSet
#'
#' @description
#' Retrieves the specified RegexPatternSet.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_regex_pattern_set/](https://www.paws-r-sdk.com/docs/wafv2_get_regex_pattern_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the set. You cannot change the name after you create the
#' set.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the set. This ID is returned in the responses to
#' create and list commands. You provide it to operations like update and
#' delete.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_regex_pattern_set
wafv2_get_regex_pattern_set <- function(Name, Scope, Id) {
  op <- new_operation(
    name = "GetRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_regex_pattern_set_input(Name = Name, Scope = Scope, Id = Id)
  output <- .wafv2$get_regex_pattern_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_regex_pattern_set <- wafv2_get_regex_pattern_set

#' Retrieves the specified RuleGroup
#'
#' @description
#' Retrieves the specified RuleGroup.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_rule_group/](https://www.paws-r-sdk.com/docs/wafv2_get_rule_group/) for full documentation.
#'
#' @param Name The name of the rule group. You cannot change the name of a rule group
#' after you create it.
#' @param Scope Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id A unique identifier for the rule group. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#' @param ARN The Amazon Resource Name (ARN) of the entity.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_rule_group
wafv2_get_rule_group <- function(Name = NULL, Scope = NULL, Id = NULL, ARN = NULL) {
  op <- new_operation(
    name = "GetRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_rule_group_input(Name = Name, Scope = Scope, Id = Id, ARN = ARN)
  output <- .wafv2$get_rule_group_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_rule_group <- wafv2_get_rule_group

#' Gets detailed information about a specified number of requests--a
#' sample--that WAF randomly selects from among the first 5,000 requests
#' that your Amazon Web Services resource received during a time range that
#' you choose
#'
#' @description
#' Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_sampled_requests/](https://www.paws-r-sdk.com/docs/wafv2_get_sampled_requests/) for full documentation.
#'
#' @param WebAclArn &#91;required&#93; The Amazon resource name (ARN) of the `WebACL` for which you want a
#' sample of requests.
#' @param RuleMetricName &#91;required&#93; The metric name assigned to the `Rule` or `RuleGroup` dimension for
#' which you want a sample of requests.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param TimeWindow &#91;required&#93; The start date and time and the end date and time of the range for which
#' you want [`get_sampled_requests`][wafv2_get_sampled_requests] to return
#' a sample of requests. You must specify the times in Coordinated
#' Universal Time (UTC) format. UTC format includes the special designator,
#' `Z`. For example, `"2016-09-27T14:50Z"`. You can specify any time range
#' in the previous three hours. If you specify a start time that's earlier
#' than three hours ago, WAF sets it to three hours ago.
#' @param MaxItems &#91;required&#93; The number of requests that you want WAF to return from among the first
#' 5,000 requests that your Amazon Web Services resource received during
#' the time range. If your resource received fewer requests than the value
#' of `MaxItems`, [`get_sampled_requests`][wafv2_get_sampled_requests]
#' returns information about all of them.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_sampled_requests
wafv2_get_sampled_requests <- function(WebAclArn, RuleMetricName, Scope, TimeWindow, MaxItems) {
  op <- new_operation(
    name = "GetSampledRequests",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_sampled_requests_input(WebAclArn = WebAclArn, RuleMetricName = RuleMetricName, Scope = Scope, TimeWindow = TimeWindow, MaxItems = MaxItems)
  output <- .wafv2$get_sampled_requests_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_sampled_requests <- wafv2_get_sampled_requests

#' Retrieves the specified WebACL
#'
#' @description
#' Retrieves the specified WebACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_get_web_acl/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the web ACL. You cannot change the name of a web ACL after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; The unique identifier for the web ACL. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#'
#' @keywords internal
#'
#' @rdname wafv2_get_web_acl
wafv2_get_web_acl <- function(Name, Scope, Id) {
  op <- new_operation(
    name = "GetWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_web_acl_input(Name = Name, Scope = Scope, Id = Id)
  output <- .wafv2$get_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_web_acl <- wafv2_get_web_acl

#' Retrieves the WebACL for the specified resource
#'
#' @description
#' Retrieves the WebACL for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_get_web_acl_for_resource/](https://www.paws-r-sdk.com/docs/wafv2_get_web_acl_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose web ACL you want to
#' retrieve.
#' 
#' The ARN must be in one of the following formats:
#' 
#' -   For an Application Load Balancer:
#'     `arn:partition:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id `
#' 
#' -   For an Amazon API Gateway REST API:
#'     `arn:partition:apigateway:region::/restapis/api-id/stages/stage-name `
#' 
#' -   For an AppSync GraphQL API:
#'     `arn:partition:appsync:region:account-id:apis/GraphQLApiId `
#' 
#' -   For an Amazon Cognito user pool:
#'     `arn:partition:cognito-idp:region:account-id:userpool/user-pool-id `
#' 
#' -   For an App Runner service:
#'     `arn:partition:apprunner:region:account-id:service/apprunner-service-name/apprunner-service-id `
#' 
#' -   For an Amazon Web Services Verified Access instance:
#'     `arn:partition:ec2:region:account-id:verified-access-instance/instance-id `
#'
#' @keywords internal
#'
#' @rdname wafv2_get_web_acl_for_resource
wafv2_get_web_acl_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "GetWebACLForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$get_web_acl_for_resource_input(ResourceArn = ResourceArn)
  output <- .wafv2$get_web_acl_for_resource_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$get_web_acl_for_resource <- wafv2_get_web_acl_for_resource

#' Retrieves a list of the API keys that you've defined for the specified
#' scope
#'
#' @description
#' Retrieves a list of the API keys that you've defined for the specified scope.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_api_keys/](https://www.paws-r-sdk.com/docs/wafv2_list_api_keys/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_api_keys
wafv2_list_api_keys <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListAPIKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_api_keys_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_api_keys_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_api_keys <- wafv2_list_api_keys

#' Returns a list of the available versions for the specified managed rule
#' group
#'
#' @description
#' Returns a list of the available versions for the specified managed rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_available_managed_rule_group_versions/](https://www.paws-r-sdk.com/docs/wafv2_list_available_managed_rule_group_versions/) for full documentation.
#'
#' @param VendorName &#91;required&#93; The name of the managed rule group vendor. You use this, along with the
#' rule group name, to identify a rule group.
#' @param Name &#91;required&#93; The name of the managed rule group. You use this, along with the vendor
#' name, to identify the rule group.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_available_managed_rule_group_versions
wafv2_list_available_managed_rule_group_versions <- function(VendorName, Name, Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListAvailableManagedRuleGroupVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_available_managed_rule_group_versions_input(VendorName = VendorName, Name = Name, Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_available_managed_rule_group_versions_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_available_managed_rule_group_versions <- wafv2_list_available_managed_rule_group_versions

#' Retrieves an array of managed rule groups that are available for you to
#' use
#'
#' @description
#' Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_available_managed_rule_groups/](https://www.paws-r-sdk.com/docs/wafv2_list_available_managed_rule_groups/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_available_managed_rule_groups
wafv2_list_available_managed_rule_groups <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListAvailableManagedRuleGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_available_managed_rule_groups_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_available_managed_rule_groups_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_available_managed_rule_groups <- wafv2_list_available_managed_rule_groups

#' Retrieves an array of IPSetSummary objects for the IP sets that you
#' manage
#'
#' @description
#' Retrieves an array of IPSetSummary objects for the IP sets that you manage.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_ip_sets/](https://www.paws-r-sdk.com/docs/wafv2_list_ip_sets/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_ip_sets
wafv2_list_ip_sets <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_ip_sets_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_ip_sets_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_ip_sets <- wafv2_list_ip_sets

#' Retrieves an array of your LoggingConfiguration objects
#'
#' @description
#' Retrieves an array of your LoggingConfiguration objects.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_logging_configurations/](https://www.paws-r-sdk.com/docs/wafv2_list_logging_configurations/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#' @param LogScope The owner of the logging configuration, which must be set to `CUSTOMER`
#' for the configurations that you manage.
#' 
#' The log scope `SECURITY_LAKE` indicates a configuration that is managed
#' through Amazon Security Lake. You can use Security Lake to collect log
#' and event data from various sources for normalization, analysis, and
#' management. For information, see [Collecting data from Amazon Web
#' Services
#' services](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html)
#' in the *Amazon Security Lake user guide*.
#' 
#' Default: `CUSTOMER`
#'
#' @keywords internal
#'
#' @rdname wafv2_list_logging_configurations
wafv2_list_logging_configurations <- function(Scope, NextMarker = NULL, Limit = NULL, LogScope = NULL) {
  op <- new_operation(
    name = "ListLoggingConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_logging_configurations_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit, LogScope = LogScope)
  output <- .wafv2$list_logging_configurations_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_logging_configurations <- wafv2_list_logging_configurations

#' Retrieves the managed rule sets that you own
#'
#' @description
#' Retrieves the managed rule sets that you own.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_managed_rule_sets/](https://www.paws-r-sdk.com/docs/wafv2_list_managed_rule_sets/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_managed_rule_sets
wafv2_list_managed_rule_sets <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListManagedRuleSets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_managed_rule_sets_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_managed_rule_sets_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_managed_rule_sets <- wafv2_list_managed_rule_sets

#' Retrieves a list of the available releases for the mobile SDK and the
#' specified device platform
#'
#' @description
#' Retrieves a list of the available releases for the mobile SDK and the specified device platform.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_mobile_sdk_releases/](https://www.paws-r-sdk.com/docs/wafv2_list_mobile_sdk_releases/) for full documentation.
#'
#' @param Platform &#91;required&#93; The device platform to retrieve the list for.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_mobile_sdk_releases
wafv2_list_mobile_sdk_releases <- function(Platform, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListMobileSdkReleases",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_mobile_sdk_releases_input(Platform = Platform, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_mobile_sdk_releases_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_mobile_sdk_releases <- wafv2_list_mobile_sdk_releases

#' Retrieves an array of RegexPatternSetSummary objects for the regex
#' pattern sets that you manage
#'
#' @description
#' Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_regex_pattern_sets/](https://www.paws-r-sdk.com/docs/wafv2_list_regex_pattern_sets/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_regex_pattern_sets
wafv2_list_regex_pattern_sets <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRegexPatternSets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_regex_pattern_sets_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_regex_pattern_sets_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_regex_pattern_sets <- wafv2_list_regex_pattern_sets

#' Retrieves an array of the Amazon Resource Names (ARNs) for the regional
#' resources that are associated with the specified web ACL
#'
#' @description
#' Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_resources_for_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_list_resources_for_web_acl/) for full documentation.
#'
#' @param WebACLArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL.
#' @param ResourceType Used for web ACLs that are scoped for regional applications. A regional
#' application can be an Application Load Balancer (ALB), an Amazon API
#' Gateway REST API, an AppSync GraphQL API, an Amazon Cognito user pool,
#' an App Runner service, or an Amazon Web Services Verified Access
#' instance.
#' 
#' If you don't provide a resource type, the call uses the resource type
#' `APPLICATION_LOAD_BALANCER`.
#' 
#' Default: `APPLICATION_LOAD_BALANCER`
#'
#' @keywords internal
#'
#' @rdname wafv2_list_resources_for_web_acl
wafv2_list_resources_for_web_acl <- function(WebACLArn, ResourceType = NULL) {
  op <- new_operation(
    name = "ListResourcesForWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_resources_for_web_acl_input(WebACLArn = WebACLArn, ResourceType = ResourceType)
  output <- .wafv2$list_resources_for_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_resources_for_web_acl <- wafv2_list_resources_for_web_acl

#' Retrieves an array of RuleGroupSummary objects for the rule groups that
#' you manage
#'
#' @description
#' Retrieves an array of RuleGroupSummary objects for the rule groups that you manage.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_rule_groups/](https://www.paws-r-sdk.com/docs/wafv2_list_rule_groups/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_rule_groups
wafv2_list_rule_groups <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_rule_groups_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_rule_groups_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_rule_groups <- wafv2_list_rule_groups

#' Retrieves the TagInfoForResource for the specified resource
#'
#' @description
#' Retrieves the TagInfoForResource for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/wafv2_list_tags_for_resource/) for full documentation.
#'
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_tags_for_resource
wafv2_list_tags_for_resource <- function(NextMarker = NULL, Limit = NULL, ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_tags_for_resource_input(NextMarker = NextMarker, Limit = Limit, ResourceARN = ResourceARN)
  output <- .wafv2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_tags_for_resource <- wafv2_list_tags_for_resource

#' Retrieves an array of WebACLSummary objects for the web ACLs that you
#' manage
#'
#' @description
#' Retrieves an array of WebACLSummary objects for the web ACLs that you manage.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_list_web_ac_ls/](https://www.paws-r-sdk.com/docs/wafv2_list_web_ac_ls/) for full documentation.
#'
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param NextMarker When you request a list of objects with a `Limit` setting, if the number
#' of objects that are still available for retrieval exceeds the limit, WAF
#' returns a `NextMarker` value in the response. To retrieve the next batch
#' of objects, provide the marker from the prior call in your next request.
#' @param Limit The maximum number of objects that you want WAF to return for this
#' request. If more objects are available, in the response, WAF provides a
#' `NextMarker` value that you can use in a subsequent call to get the next
#' batch of objects.
#'
#' @keywords internal
#'
#' @rdname wafv2_list_web_ac_ls
wafv2_list_web_ac_ls <- function(Scope, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListWebACLs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$list_web_ac_ls_input(Scope = Scope, NextMarker = NextMarker, Limit = Limit)
  output <- .wafv2$list_web_ac_ls_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$list_web_ac_ls <- wafv2_list_web_ac_ls

#' Enables the specified LoggingConfiguration, to start logging from a web
#' ACL, according to the configuration provided
#'
#' @description
#' Enables the specified LoggingConfiguration, to start logging from a web ACL, according to the configuration provided.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_put_logging_configuration/](https://www.paws-r-sdk.com/docs/wafv2_put_logging_configuration/) for full documentation.
#'
#' @param LoggingConfiguration &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname wafv2_put_logging_configuration
wafv2_put_logging_configuration <- function(LoggingConfiguration) {
  op <- new_operation(
    name = "PutLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$put_logging_configuration_input(LoggingConfiguration = LoggingConfiguration)
  output <- .wafv2$put_logging_configuration_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$put_logging_configuration <- wafv2_put_logging_configuration

#' Defines the versions of your managed rule set that you are offering to
#' the customers
#'
#' @description
#' Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_put_managed_rule_set_versions/](https://www.paws-r-sdk.com/docs/wafv2_put_managed_rule_set_versions/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the managed rule set. You use this, along with the rule set
#' ID, to identify the rule set.
#' 
#' This name is assigned to the corresponding managed rule group, which
#' your customers can access and use.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the managed rule set. The ID is returned in the
#' responses to commands like `list`. You provide it to operations like
#' `get` and `update`.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#' @param RecommendedVersion The version of the named managed rule group that you'd like your
#' customers to choose, from among your version offerings.
#' @param VersionsToPublish The versions of the named managed rule group that you want to offer to
#' your customers.
#'
#' @keywords internal
#'
#' @rdname wafv2_put_managed_rule_set_versions
wafv2_put_managed_rule_set_versions <- function(Name, Scope, Id, LockToken, RecommendedVersion = NULL, VersionsToPublish = NULL) {
  op <- new_operation(
    name = "PutManagedRuleSetVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$put_managed_rule_set_versions_input(Name = Name, Scope = Scope, Id = Id, LockToken = LockToken, RecommendedVersion = RecommendedVersion, VersionsToPublish = VersionsToPublish)
  output <- .wafv2$put_managed_rule_set_versions_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$put_managed_rule_set_versions <- wafv2_put_managed_rule_set_versions

#' Use this to share a rule group with other accounts
#'
#' @description
#' Use this to share a rule group with other accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_put_permission_policy/](https://www.paws-r-sdk.com/docs/wafv2_put_permission_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup to which you want to
#' attach the policy.
#' @param Policy &#91;required&#93; The policy to attach to the specified rule group.
#' 
#' The policy specifications must conform to the following:
#' 
#' -   The policy must be composed using IAM Policy version 2012-10-17.
#' 
#' -   The policy must include specifications for `Effect`, `Action`, and
#'     `Principal`.
#' 
#' -   `Effect` must specify `Allow`.
#' 
#' -   `Action` must specify `wafv2:CreateWebACL`, `wafv2:UpdateWebACL`,
#'     and `wafv2:PutFirewallManagerRuleGroups` and may optionally specify
#'     `wafv2:GetRuleGroup`. WAF rejects any extra actions or wildcard
#'     actions in the policy.
#' 
#' -   The policy must not include a `Resource` parameter.
#' 
#' For more information, see [IAM
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
#'
#' @keywords internal
#'
#' @rdname wafv2_put_permission_policy
wafv2_put_permission_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutPermissionPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$put_permission_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .wafv2$put_permission_policy_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$put_permission_policy <- wafv2_put_permission_policy

#' Associates tags with the specified Amazon Web Services resource
#'
#' @description
#' Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_tag_resource/](https://www.paws-r-sdk.com/docs/wafv2_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; An array of key:value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname wafv2_tag_resource
wafv2_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .wafv2$tag_resource_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$tag_resource <- wafv2_tag_resource

#' Disassociates tags from an Amazon Web Services resource
#'
#' @description
#' Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_untag_resource/](https://www.paws-r-sdk.com/docs/wafv2_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; An array of keys identifying the tags to disassociate from the resource.
#'
#' @keywords internal
#'
#' @rdname wafv2_untag_resource
wafv2_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .wafv2$untag_resource_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$untag_resource <- wafv2_untag_resource

#' Updates the specified IPSet
#'
#' @description
#' Updates the specified IPSet.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_update_ip_set/](https://www.paws-r-sdk.com/docs/wafv2_update_ip_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the IP set. You cannot change the name of an `IPSet` after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the set. This ID is returned in the responses to
#' create and list commands. You provide it to operations like update and
#' delete.
#' @param Description A description of the IP set that helps with identification.
#' @param Addresses &#91;required&#93; Contains an array of strings that specifies zero or more IP addresses or
#' blocks of IP addresses that you want WAF to inspect for in incoming
#' requests. All addresses must be specified using Classless Inter-Domain
#' Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges
#' except for `/0`.
#' 
#' Example address strings:
#' 
#' -   For requests that originated from the IP address 192.0.2.44, specify
#'     `192.0.2.44/32`.
#' 
#' -   For requests that originated from IP addresses from 192.0.2.0 to
#'     192.0.2.255, specify `192.0.2.0/24`.
#' 
#' -   For requests that originated from the IP address
#'     1111:0000:0000:0000:0000:0000:0000:0111, specify
#'     `1111:0000:0000:0000:0000:0000:0000:0111/128`.
#' 
#' -   For requests that originated from IP addresses
#'     1111:0000:0000:0000:0000:0000:0000:0000 to
#'     1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
#'     `1111:0000:0000:0000:0000:0000:0000:0000/64`.
#' 
#' For more information about CIDR notation, see the Wikipedia entry
#' [Classless Inter-Domain
#' Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#' 
#' Example JSON `Addresses` specifications:
#' 
#' -   Empty array: `"Addresses": []`
#' 
#' -   Array with one address: `"Addresses": ["192.0.2.44/32"]`
#' 
#' -   Array with three addresses:
#'     `"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`
#' 
#' -   INVALID specification: `"Addresses": [""]` INVALID
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_update_ip_set
wafv2_update_ip_set <- function(Name, Scope, Id, Description = NULL, Addresses, LockToken) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$update_ip_set_input(Name = Name, Scope = Scope, Id = Id, Description = Description, Addresses = Addresses, LockToken = LockToken)
  output <- .wafv2$update_ip_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$update_ip_set <- wafv2_update_ip_set

#' Updates the expiration information for your managed rule set
#'
#' @description
#' Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the response to [`list_available_managed_rule_group_versions`][wafv2_list_available_managed_rule_group_versions] for the managed rule group.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_update_managed_rule_set_version_expiry_date/](https://www.paws-r-sdk.com/docs/wafv2_update_managed_rule_set_version_expiry_date/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the managed rule set. You use this, along with the rule set
#' ID, to identify the rule set.
#' 
#' This name is assigned to the corresponding managed rule group, which
#' your customers can access and use.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the managed rule set. The ID is returned in the
#' responses to commands like `list`. You provide it to operations like
#' `get` and `update`.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#' @param VersionToExpire &#91;required&#93; The version that you want to remove from your list of offerings for the
#' named managed rule group.
#' @param ExpiryTimestamp &#91;required&#93; The time that you want the version to expire.
#' 
#' Times are in Coordinated Universal Time (UTC) format. UTC format
#' includes the special designator, Z. For example, "2016-09-27T14:50Z".
#'
#' @keywords internal
#'
#' @rdname wafv2_update_managed_rule_set_version_expiry_date
wafv2_update_managed_rule_set_version_expiry_date <- function(Name, Scope, Id, LockToken, VersionToExpire, ExpiryTimestamp) {
  op <- new_operation(
    name = "UpdateManagedRuleSetVersionExpiryDate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$update_managed_rule_set_version_expiry_date_input(Name = Name, Scope = Scope, Id = Id, LockToken = LockToken, VersionToExpire = VersionToExpire, ExpiryTimestamp = ExpiryTimestamp)
  output <- .wafv2$update_managed_rule_set_version_expiry_date_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$update_managed_rule_set_version_expiry_date <- wafv2_update_managed_rule_set_version_expiry_date

#' Updates the specified RegexPatternSet
#'
#' @description
#' Updates the specified RegexPatternSet.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_update_regex_pattern_set/](https://www.paws-r-sdk.com/docs/wafv2_update_regex_pattern_set/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the set. You cannot change the name after you create the
#' set.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the set. This ID is returned in the responses to
#' create and list commands. You provide it to operations like update and
#' delete.
#' @param Description A description of the set that helps with identification.
#' @param RegularExpressionList &#91;required&#93; 
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#'
#' @keywords internal
#'
#' @rdname wafv2_update_regex_pattern_set
wafv2_update_regex_pattern_set <- function(Name, Scope, Id, Description = NULL, RegularExpressionList, LockToken) {
  op <- new_operation(
    name = "UpdateRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$update_regex_pattern_set_input(Name = Name, Scope = Scope, Id = Id, Description = Description, RegularExpressionList = RegularExpressionList, LockToken = LockToken)
  output <- .wafv2$update_regex_pattern_set_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$update_regex_pattern_set <- wafv2_update_regex_pattern_set

#' Updates the specified RuleGroup
#'
#' @description
#' Updates the specified RuleGroup.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_update_rule_group/](https://www.paws-r-sdk.com/docs/wafv2_update_rule_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule group. You cannot change the name of a rule group
#' after you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; A unique identifier for the rule group. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#' @param Description A description of the rule group that helps with identification.
#' @param Rules The Rule statements used to identify the web requests that you want to
#' manage. Each rule includes one top-level statement that WAF uses to
#' identify matching web requests, and parameters that govern how WAF
#' handles them.
#' @param VisibilityConfig &#91;required&#93; Defines and enables Amazon CloudWatch metrics and web request sample
#' collection.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#' @param CustomResponseBodies A map of custom response keys and content bodies. When you create a rule
#' with a block action, you can send a custom response to the web request.
#' You define these for the rule group, and then use them in the rules that
#' you define in the rule group.
#' 
#' For information about customizing web requests and responses, see
#' [Customizing web requests and responses in
#' WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
#' in the *WAF Developer Guide*.
#' 
#' For information about the limits on count and size for custom request
#' and response settings, see [WAF
#' quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
#' in the *WAF Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname wafv2_update_rule_group
wafv2_update_rule_group <- function(Name, Scope, Id, Description = NULL, Rules = NULL, VisibilityConfig, LockToken, CustomResponseBodies = NULL) {
  op <- new_operation(
    name = "UpdateRuleGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$update_rule_group_input(Name = Name, Scope = Scope, Id = Id, Description = Description, Rules = Rules, VisibilityConfig = VisibilityConfig, LockToken = LockToken, CustomResponseBodies = CustomResponseBodies)
  output <- .wafv2$update_rule_group_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$update_rule_group <- wafv2_update_rule_group

#' Updates the specified WebACL
#'
#' @description
#' Updates the specified WebACL. While updating a web ACL, WAF provides continuous coverage to the resources that you have associated with the web ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/wafv2_update_web_acl/](https://www.paws-r-sdk.com/docs/wafv2_update_web_acl/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the web ACL. You cannot change the name of a web ACL after
#' you create it.
#' @param Scope &#91;required&#93; Specifies whether this is for an Amazon CloudFront distribution or for a
#' regional application. A regional application can be an Application Load
#' Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
#' an Amazon Cognito user pool, an App Runner service, or an Amazon Web
#' Services Verified Access instance.
#' 
#' To work with CloudFront, you must also specify the Region US East (N.
#' Virginia) as follows:
#' 
#' -   CLI - Specify the Region when you use the CloudFront scope:
#'     `--scope=CLOUDFRONT --region=us-east-1`.
#' 
#' -   API and SDKs - For all calls, use the Region endpoint us-east-1.
#' @param Id &#91;required&#93; The unique identifier for the web ACL. This ID is returned in the
#' responses to create and list commands. You provide it to operations like
#' update and delete.
#' @param DefaultAction &#91;required&#93; The action to perform if none of the `Rules` contained in the `WebACL`
#' match.
#' @param Description A description of the web ACL that helps with identification.
#' @param Rules The Rule statements used to identify the web requests that you want to
#' manage. Each rule includes one top-level statement that WAF uses to
#' identify matching web requests, and parameters that govern how WAF
#' handles them.
#' @param VisibilityConfig &#91;required&#93; Defines and enables Amazon CloudWatch metrics and web request sample
#' collection.
#' @param LockToken &#91;required&#93; A token used for optimistic locking. WAF returns a token to your `get`
#' and `list` requests, to mark the state of the entity at the time of the
#' request. To make changes to the entity associated with the token, you
#' provide the token to operations like `update` and `delete`. WAF uses the
#' token to ensure that no changes have been made to the entity since you
#' last retrieved it. If a change has been made, the update fails with a
#' `WAFOptimisticLockException`. If this happens, perform another `get`,
#' and use the new token returned by that operation.
#' @param CustomResponseBodies A map of custom response keys and content bodies. When you create a rule
#' with a block action, you can send a custom response to the web request.
#' You define these for the web ACL, and then use them in the rules and
#' default actions that you define in the web ACL.
#' 
#' For information about customizing web requests and responses, see
#' [Customizing web requests and responses in
#' WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
#' in the *WAF Developer Guide*.
#' 
#' For information about the limits on count and size for custom request
#' and response settings, see [WAF
#' quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
#' in the *WAF Developer Guide*.
#' @param CaptchaConfig Specifies how WAF should handle `CAPTCHA` evaluations for rules that
#' don't have their own `CaptchaConfig` settings. If you don't specify
#' this, WAF uses its default settings for `CaptchaConfig`.
#' @param ChallengeConfig Specifies how WAF should handle challenge evaluations for rules that
#' don't have their own `ChallengeConfig` settings. If you don't specify
#' this, WAF uses its default settings for `ChallengeConfig`.
#' @param TokenDomains Specifies the domains that WAF should accept in a web request token.
#' This enables the use of tokens across multiple protected websites. When
#' WAF provides a token, it uses the domain of the Amazon Web Services
#' resource that the web ACL is protecting. If you don't specify a list of
#' token domains, WAF accepts tokens only for the domain of the protected
#' resource. With a token domain list, WAF accepts the resource's host
#' domain plus all domains in the token domain list, including their
#' prefixed subdomains.
#' 
#' Example JSON:
#' `"TokenDomains": { "mywebsite.com", "myotherwebsite.com" }`
#' 
#' Public suffixes aren't allowed. For example, you can't use `gov.au` or
#' `co.uk` as token domains.
#' @param AssociationConfig Specifies custom configurations for the associations between the web ACL
#' and protected resources.
#' 
#' Use this to customize the maximum size of the request body that your
#' protected resources forward to WAF for inspection. You can customize
#' this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or
#' Verified Access resources. The default setting is 16 KB (16,384 bytes).
#' 
#' You are charged additional fees when your protected resources forward
#' body sizes that are larger than the default. For more information, see
#' [WAF Pricing](https://aws.amazon.com/waf/pricing/).
#' 
#' For Application Load Balancer and AppSync, the limit is fixed at 8 KB
#' (8,192 bytes).
#'
#' @keywords internal
#'
#' @rdname wafv2_update_web_acl
wafv2_update_web_acl <- function(Name, Scope, Id, DefaultAction, Description = NULL, Rules = NULL, VisibilityConfig, LockToken, CustomResponseBodies = NULL, CaptchaConfig = NULL, ChallengeConfig = NULL, TokenDomains = NULL, AssociationConfig = NULL) {
  op <- new_operation(
    name = "UpdateWebACL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .wafv2$update_web_acl_input(Name = Name, Scope = Scope, Id = Id, DefaultAction = DefaultAction, Description = Description, Rules = Rules, VisibilityConfig = VisibilityConfig, LockToken = LockToken, CustomResponseBodies = CustomResponseBodies, CaptchaConfig = CaptchaConfig, ChallengeConfig = ChallengeConfig, TokenDomains = TokenDomains, AssociationConfig = AssociationConfig)
  output <- .wafv2$update_web_acl_output()
  config <- get_config()
  svc <- .wafv2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.wafv2$operations$update_web_acl <- wafv2_update_web_acl
