# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS SSO Identity Store
#'
#' @description
#' The Identity Store service used by IAM Identity Center provides a single
#' place to retrieve all of your identities (users and groups). For more
#' information, see the [IAM Identity Center User
#' Guide](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html).
#' 
#' This reference guide describes the identity store operations that you
#' can call programmatically and includes detailed information about data
#' types and errors.
#' 
#' IAM Identity Center uses the `sso` and `identitystore` API namespaces.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- identitystore(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- identitystore()
#' svc$create_group(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=identitystore_create_group]{create_group} \tab Creates a group within the specified identity store\cr
#'  \link[=identitystore_create_group_membership]{create_group_membership} \tab Creates a relationship between a member and a group\cr
#'  \link[=identitystore_create_user]{create_user} \tab Creates a user within the specified identity store\cr
#'  \link[=identitystore_delete_group]{delete_group} \tab Delete a group within an identity store given GroupId\cr
#'  \link[=identitystore_delete_group_membership]{delete_group_membership} \tab Delete a membership within a group given MembershipId\cr
#'  \link[=identitystore_delete_user]{delete_user} \tab Deletes a user within an identity store given UserId\cr
#'  \link[=identitystore_describe_group]{describe_group} \tab Retrieves the group metadata and attributes from GroupId in an identity store\cr
#'  \link[=identitystore_describe_group_membership]{describe_group_membership} \tab Retrieves membership metadata and attributes from MembershipId in an identity store\cr
#'  \link[=identitystore_describe_user]{describe_user} \tab Retrieves the user metadata and attributes from the UserId in an identity store\cr
#'  \link[=identitystore_get_group_id]{get_group_id} \tab Retrieves GroupId in an identity store\cr
#'  \link[=identitystore_get_group_membership_id]{get_group_membership_id} \tab Retrieves the MembershipId in an identity store\cr
#'  \link[=identitystore_get_user_id]{get_user_id} \tab Retrieves the UserId in an identity store\cr
#'  \link[=identitystore_is_member_in_groups]{is_member_in_groups} \tab Checks the user's membership in all requested groups and returns if the member exists in all queried groups\cr
#'  \link[=identitystore_list_group_memberships]{list_group_memberships} \tab For the specified group in the specified identity store, returns the list of all GroupMembership objects and returns results in paginated form\cr
#'  \link[=identitystore_list_group_memberships_for_member]{list_group_memberships_for_member} \tab For the specified member in the specified identity store, returns the list of all GroupMembership objects and returns results in paginated form\cr
#'  \link[=identitystore_list_groups]{list_groups} \tab Lists all groups in the identity store\cr
#'  \link[=identitystore_list_users]{list_users} \tab Lists all users in the identity store\cr
#'  \link[=identitystore_update_group]{update_group} \tab For the specified group in the specified identity store, updates the group metadata and attributes\cr
#'  \link[=identitystore_update_user]{update_user} \tab For the specified user in the specified identity store, updates the user metadata and attributes
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname identitystore
#' @export
identitystore <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .identitystore$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.identitystore <- list()

.identitystore$operations <- list()

.identitystore$metadata <- list(
  service_name = "identitystore",
  endpoints = list("*" = list(endpoint = "identitystore.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "identitystore.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "identitystore.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "identitystore.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "identitystore.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "identitystore.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "identitystore",
  api_version = "2020-06-15",
  signing_name = "identitystore",
  json_version = "1.1",
  target_prefix = "AWSIdentityStore"
)

.identitystore$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.identitystore$metadata, handlers, config, op)
}
