% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_associate_drt_role}
\alias{shield_associate_drt_role}
\title{Authorizes the Shield Response Team (SRT) using the specified role, to
access your Amazon Web Services account to assist with DDoS attack
mitigation during potential attacks}
\usage{
shield_associate_drt_role(RoleArn)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role the SRT will use to access
your Amazon Web Services account.

Prior to making the \code{\link[=shield_associate_drt_role]{associate_drt_role}}
request, you must attach the
\href{https://us-east-1.console.aws.amazon.com/iam/home#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy}{AWSShieldDRTAccessPolicy}
managed policy to this role. For more information see Attaching and
Detaching IAM Policies.}
}
\description{
Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.

See \url{https://www.paws-r-sdk.com/docs/shield_associate_drt_role/} for full documentation.
}
\keyword{internal}
