% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_key_rotations}
\alias{kms_list_key_rotations}
\title{Returns information about all completed key material rotations for the
specified KMS key}
\usage{
kms_list_key_rotations(KeyId, Limit = NULL, Marker = NULL)
}
\arguments{
\item{KeyId}{[required] Gets the key rotations for the specified KMS key.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, KMS does not return more than the specified
number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
1000, inclusive. If you do not include a value, it defaults to 100.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}
}
\description{
Returns information about all completed key material rotations for the specified KMS key.

See \url{https://www.paws-r-sdk.com/docs/kms_list_key_rotations/} for full documentation.
}
\keyword{internal}
