# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include directoryservice_service.R
NULL

#' Accepts a directory sharing request that was sent from the directory
#' owner account
#'
#' @description
#' Accepts a directory sharing request that was sent from the directory owner account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_accept_shared_directory/](https://www.paws-r-sdk.com/docs/directoryservice_accept_shared_directory/) for full documentation.
#'
#' @param SharedDirectoryId &#91;required&#93; Identifier of the shared directory in the directory consumer account.
#' This identifier is different for each directory owner account.
#'
#' @keywords internal
#'
#' @rdname directoryservice_accept_shared_directory
directoryservice_accept_shared_directory <- function(SharedDirectoryId) {
  op <- new_operation(
    name = "AcceptSharedDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$accept_shared_directory_input(SharedDirectoryId = SharedDirectoryId)
  output <- .directoryservice$accept_shared_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$accept_shared_directory <- directoryservice_accept_shared_directory

#' If the DNS server for your self-managed domain uses a publicly
#' addressable IP address, you must add a CIDR address block to correctly
#' route traffic to and from your Microsoft AD on Amazon Web Services
#'
#' @description
#' If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. *AddIpRoutes* adds this address block. You can also use *AddIpRoutes* to facilitate routing traffic that uses public IP ranges from your Microsoft AD on Amazon Web Services to a peer VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_add_ip_routes/](https://www.paws-r-sdk.com/docs/directoryservice_add_ip_routes/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier (ID) of the directory to which to add the address block.
#' @param IpRoutes &#91;required&#93; IP address blocks, using CIDR format, of the traffic to route. This is
#' often the IP address block of the DNS server used for your self-managed
#' domain.
#' @param UpdateSecurityGroupForDirectoryControllers If set to true, updates the inbound and outbound rules of the security
#' group that has the description: "Amazon Web Services created security
#' group for *directory ID* directory controllers." Following are the new
#' rules:
#' 
#' Inbound:
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
#' 
#' -   Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source:
#'     0.0.0.0/0
#' 
#' -   Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source:
#'     0.0.0.0/0
#' 
#' -   Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
#' 
#' -   Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
#' 
#' -   Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
#' 
#' -   Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
#' 
#' Outbound:
#' 
#' -   Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
#' 
#' These security rules impact an internal network interface that is not
#' exposed publicly.
#'
#' @keywords internal
#'
#' @rdname directoryservice_add_ip_routes
directoryservice_add_ip_routes <- function(DirectoryId, IpRoutes, UpdateSecurityGroupForDirectoryControllers = NULL) {
  op <- new_operation(
    name = "AddIpRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$add_ip_routes_input(DirectoryId = DirectoryId, IpRoutes = IpRoutes, UpdateSecurityGroupForDirectoryControllers = UpdateSecurityGroupForDirectoryControllers)
  output <- .directoryservice$add_ip_routes_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$add_ip_routes <- directoryservice_add_ip_routes

#' Adds two domain controllers in the specified Region for the specified
#' directory
#'
#' @description
#' Adds two domain controllers in the specified Region for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_add_region/](https://www.paws-r-sdk.com/docs/directoryservice_add_region/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory to which you want to add Region
#' replication.
#' @param RegionName &#91;required&#93; The name of the Region where you want to add domain controllers for
#' replication. For example, `us-east-1`.
#' @param VPCSettings &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname directoryservice_add_region
directoryservice_add_region <- function(DirectoryId, RegionName, VPCSettings) {
  op <- new_operation(
    name = "AddRegion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$add_region_input(DirectoryId = DirectoryId, RegionName = RegionName, VPCSettings = VPCSettings)
  output <- .directoryservice$add_region_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$add_region <- directoryservice_add_region

#' Adds or overwrites one or more tags for the specified directory
#'
#' @description
#' Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique to each resource.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_add_tags_to_resource/](https://www.paws-r-sdk.com/docs/directoryservice_add_tags_to_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Identifier (ID) for the directory to which to add the tag.
#' @param Tags &#91;required&#93; The tags to be assigned to the directory.
#'
#' @keywords internal
#'
#' @rdname directoryservice_add_tags_to_resource
directoryservice_add_tags_to_resource <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$add_tags_to_resource_input(ResourceId = ResourceId, Tags = Tags)
  output <- .directoryservice$add_tags_to_resource_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$add_tags_to_resource <- directoryservice_add_tags_to_resource

#' Cancels an in-progress schema extension to a Microsoft AD directory
#'
#' @description
#' Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled during any of the following states; `Initializing`, `CreatingSnapshot`, and `UpdatingSchema`.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_cancel_schema_extension/](https://www.paws-r-sdk.com/docs/directoryservice_cancel_schema_extension/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory whose schema extension will be canceled.
#' @param SchemaExtensionId &#91;required&#93; The identifier of the schema extension that will be canceled.
#'
#' @keywords internal
#'
#' @rdname directoryservice_cancel_schema_extension
directoryservice_cancel_schema_extension <- function(DirectoryId, SchemaExtensionId) {
  op <- new_operation(
    name = "CancelSchemaExtension",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$cancel_schema_extension_input(DirectoryId = DirectoryId, SchemaExtensionId = SchemaExtensionId)
  output <- .directoryservice$cancel_schema_extension_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$cancel_schema_extension <- directoryservice_cancel_schema_extension

#' Creates an AD Connector to connect to a self-managed directory
#'
#' @description
#' Creates an AD Connector to connect to a self-managed directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_connect_directory/](https://www.paws-r-sdk.com/docs/directoryservice_connect_directory/) for full documentation.
#'
#' @param Name &#91;required&#93; The fully qualified name of your self-managed directory, such as
#' `corp.example.com`.
#' @param ShortName The NetBIOS name of your self-managed directory, such as `CORP`.
#' @param Password &#91;required&#93; The password for your self-managed user account.
#' @param Description A description for the directory.
#' @param Size &#91;required&#93; The size of the directory.
#' @param ConnectSettings &#91;required&#93; A DirectoryConnectSettings object that contains additional information
#' for the operation.
#' @param Tags The tags to be assigned to AD Connector.
#'
#' @keywords internal
#'
#' @rdname directoryservice_connect_directory
directoryservice_connect_directory <- function(Name, ShortName = NULL, Password, Description = NULL, Size, ConnectSettings, Tags = NULL) {
  op <- new_operation(
    name = "ConnectDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$connect_directory_input(Name = Name, ShortName = ShortName, Password = Password, Description = Description, Size = Size, ConnectSettings = ConnectSettings, Tags = Tags)
  output <- .directoryservice$connect_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$connect_directory <- directoryservice_connect_directory

#' Creates an alias for a directory and assigns the alias to the directory
#'
#' @description
#' Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the access URL for the directory, such as `http://<alias>.awsapps.com`.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_alias/](https://www.paws-r-sdk.com/docs/directoryservice_create_alias/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to create the alias.
#' @param Alias &#91;required&#93; The requested alias.
#' 
#' The alias must be unique amongst all aliases in Amazon Web Services.
#' This operation throws an `EntityAlreadyExistsException` error if the
#' alias already exists.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_alias
directoryservice_create_alias <- function(DirectoryId, Alias) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_alias_input(DirectoryId = DirectoryId, Alias = Alias)
  output <- .directoryservice$create_alias_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_alias <- directoryservice_create_alias

#' Creates an Active Directory computer object in the specified directory
#'
#' @description
#' Creates an Active Directory computer object in the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_computer/](https://www.paws-r-sdk.com/docs/directoryservice_create_computer/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory in which to create the computer account.
#' @param ComputerName &#91;required&#93; The name of the computer account.
#' @param Password &#91;required&#93; A one-time password that is used to join the computer to the directory.
#' You should generate a random, strong password to use for this parameter.
#' @param OrganizationalUnitDistinguishedName The fully-qualified distinguished name of the organizational unit to
#' place the computer account in.
#' @param ComputerAttributes An array of Attribute objects that contain any LDAP attributes to apply
#' to the computer account.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_computer
directoryservice_create_computer <- function(DirectoryId, ComputerName, Password, OrganizationalUnitDistinguishedName = NULL, ComputerAttributes = NULL) {
  op <- new_operation(
    name = "CreateComputer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_computer_input(DirectoryId = DirectoryId, ComputerName = ComputerName, Password = Password, OrganizationalUnitDistinguishedName = OrganizationalUnitDistinguishedName, ComputerAttributes = ComputerAttributes)
  output <- .directoryservice$create_computer_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_computer <- directoryservice_create_computer

#' Creates a conditional forwarder associated with your Amazon Web Services
#' directory
#'
#' @description
#' Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are required in order to set up a trust relationship with another domain. The conditional forwarder points to the trusted domain.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_conditional_forwarder/](https://www.paws-r-sdk.com/docs/directoryservice_create_conditional_forwarder/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The directory ID of the Amazon Web Services directory for which you are
#' creating the conditional forwarder.
#' @param RemoteDomainName &#91;required&#93; The fully qualified domain name (FQDN) of the remote domain with which
#' you will set up a trust relationship.
#' @param DnsIpAddrs &#91;required&#93; The IP addresses of the remote DNS server associated with
#' RemoteDomainName.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_conditional_forwarder
directoryservice_create_conditional_forwarder <- function(DirectoryId, RemoteDomainName, DnsIpAddrs) {
  op <- new_operation(
    name = "CreateConditionalForwarder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_conditional_forwarder_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName, DnsIpAddrs = DnsIpAddrs)
  output <- .directoryservice$create_conditional_forwarder_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_conditional_forwarder <- directoryservice_create_conditional_forwarder

#' Creates a Simple AD directory
#'
#' @description
#' Creates a Simple AD directory. For more information, see [Simple Active Directory](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html) in the *Directory Service Admin Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_directory/](https://www.paws-r-sdk.com/docs/directoryservice_create_directory/) for full documentation.
#'
#' @param Name &#91;required&#93; The fully qualified name for the directory, such as `corp.example.com`.
#' @param ShortName The NetBIOS name of the directory, such as `CORP`.
#' @param Password &#91;required&#93; The password for the directory administrator. The directory creation
#' process creates a directory administrator account with the user name
#' `Administrator` and this password.
#' 
#' If you need to change the password for the administrator account, you
#' can use the
#' [`reset_user_password`][directoryservice_reset_user_password] API call.
#' 
#' The regex pattern for this string is made up of the following
#' conditions:
#' 
#' -   Length (?=^.\{8,64\}$) – Must be between 8 and 64 characters
#' 
#' AND any 3 of the following password complexity rules required by Active
#' Directory:
#' 
#' -   Numbers and upper case and lowercase
#'     (?=.*\\d)(?=.*\[A-Z\])(?=.*\[a-z\])
#' 
#' -   Numbers and special characters and lower case
#'     (?=.*\\d)(?=.*\[^A-Za-z0-9\\s\])(?=.*\[a-z\])
#' 
#' -   Special characters and upper case and lower case
#'     (?=.*\[^A-Za-z0-9\\s\])(?=.*\[A-Z\])(?=.*\[a-z\])
#' 
#' -   Numbers and upper case and special characters
#'     (?=.*\\d)(?=.*\[A-Z\])(?=.*\[^A-Za-z0-9\\s\])
#' 
#' For additional information about how Active Directory passwords are
#' enforced, see [Password must meet complexity
#' requirements](https://learn.microsoft.com/en-us/previous-versions/windows/it-pro/windows-10/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements)
#' on the Microsoft website.
#' @param Description A description for the directory.
#' @param Size &#91;required&#93; The size of the directory.
#' @param VpcSettings A DirectoryVpcSettings object that contains additional information for
#' the operation.
#' @param Tags The tags to be assigned to the Simple AD directory.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_directory
directoryservice_create_directory <- function(Name, ShortName = NULL, Password, Description = NULL, Size, VpcSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_directory_input(Name = Name, ShortName = ShortName, Password = Password, Description = Description, Size = Size, VpcSettings = VpcSettings, Tags = Tags)
  output <- .directoryservice$create_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_directory <- directoryservice_create_directory

#' Creates a subscription to forward real-time Directory Service domain
#' controller security logs to the specified Amazon CloudWatch log group in
#' your Amazon Web Services account
#'
#' @description
#' Creates a subscription to forward real-time Directory Service domain controller security logs to the specified Amazon CloudWatch log group in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_log_subscription/](https://www.paws-r-sdk.com/docs/directoryservice_create_log_subscription/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory to which you want to subscribe and receive
#' real-time logs to your specified CloudWatch log group.
#' @param LogGroupName &#91;required&#93; The name of the CloudWatch log group where the real-time domain
#' controller logs are forwarded.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_log_subscription
directoryservice_create_log_subscription <- function(DirectoryId, LogGroupName) {
  op <- new_operation(
    name = "CreateLogSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_log_subscription_input(DirectoryId = DirectoryId, LogGroupName = LogGroupName)
  output <- .directoryservice$create_log_subscription_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_log_subscription <- directoryservice_create_log_subscription

#' Creates a Microsoft AD directory in the Amazon Web Services Cloud
#'
#' @description
#' Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see [Managed Microsoft AD](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html) in the *Directory Service Admin Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_microsoft_ad/](https://www.paws-r-sdk.com/docs/directoryservice_create_microsoft_ad/) for full documentation.
#'
#' @param Name &#91;required&#93; The fully qualified domain name for the Managed Microsoft AD directory,
#' such as `corp.example.com`. This name will resolve inside your VPC only.
#' It does not need to be publicly resolvable.
#' @param ShortName The NetBIOS name for your domain, such as `CORP`. If you don't specify a
#' NetBIOS name, it will default to the first part of your directory DNS.
#' For example, `CORP` for the directory DNS `corp.example.com`.
#' @param Password &#91;required&#93; The password for the default administrative user named `Admin`.
#' 
#' If you need to change the password for the administrator account, you
#' can use the
#' [`reset_user_password`][directoryservice_reset_user_password] API call.
#' @param Description A description for the directory. This label will appear on the Amazon
#' Web Services console `Directory Details` page after the directory is
#' created.
#' @param VpcSettings &#91;required&#93; Contains VPC information for the
#' [`create_directory`][directoryservice_create_directory] or
#' [`create_microsoft_ad`][directoryservice_create_microsoft_ad] operation.
#' @param Edition Managed Microsoft AD is available in two editions: `Standard` and
#' `Enterprise`. `Enterprise` is the default.
#' @param Tags The tags to be assigned to the Managed Microsoft AD directory.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_microsoft_ad
directoryservice_create_microsoft_ad <- function(Name, ShortName = NULL, Password, Description = NULL, VpcSettings, Edition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMicrosoftAD",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_microsoft_ad_input(Name = Name, ShortName = ShortName, Password = Password, Description = Description, VpcSettings = VpcSettings, Edition = Edition, Tags = Tags)
  output <- .directoryservice$create_microsoft_ad_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_microsoft_ad <- directoryservice_create_microsoft_ad

#' Creates a snapshot of a Simple AD or Microsoft AD directory in the
#' Amazon Web Services cloud
#'
#' @description
#' Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_snapshot/](https://www.paws-r-sdk.com/docs/directoryservice_create_snapshot/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory of which to take a snapshot.
#' @param Name The descriptive name to apply to the snapshot.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_snapshot
directoryservice_create_snapshot <- function(DirectoryId, Name = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_snapshot_input(DirectoryId = DirectoryId, Name = Name)
  output <- .directoryservice$create_snapshot_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_snapshot <- directoryservice_create_snapshot

#' Directory Service for Microsoft Active Directory allows you to configure
#' trust relationships
#'
#' @description
#' Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft Active Directory. This would allow you to provide users and groups access to resources in either domain, with a single set of credentials.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_create_trust/](https://www.paws-r-sdk.com/docs/directoryservice_create_trust/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The Directory ID of the Managed Microsoft AD directory for which to
#' establish the trust relationship.
#' @param RemoteDomainName &#91;required&#93; The Fully Qualified Domain Name (FQDN) of the external domain for which
#' to create the trust relationship.
#' @param TrustPassword &#91;required&#93; The trust password. The must be the same password that was used when
#' creating the trust relationship on the external domain.
#' @param TrustDirection &#91;required&#93; The direction of the trust relationship.
#' @param TrustType The trust relationship type. `Forest` is the default.
#' @param ConditionalForwarderIpAddrs The IP addresses of the remote DNS server associated with
#' RemoteDomainName.
#' @param SelectiveAuth Optional parameter to enable selective authentication for the trust.
#'
#' @keywords internal
#'
#' @rdname directoryservice_create_trust
directoryservice_create_trust <- function(DirectoryId, RemoteDomainName, TrustPassword, TrustDirection, TrustType = NULL, ConditionalForwarderIpAddrs = NULL, SelectiveAuth = NULL) {
  op <- new_operation(
    name = "CreateTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$create_trust_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName, TrustPassword = TrustPassword, TrustDirection = TrustDirection, TrustType = TrustType, ConditionalForwarderIpAddrs = ConditionalForwarderIpAddrs, SelectiveAuth = SelectiveAuth)
  output <- .directoryservice$create_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$create_trust <- directoryservice_create_trust

#' Deletes a conditional forwarder that has been set up for your Amazon Web
#' Services directory
#'
#' @description
#' Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_delete_conditional_forwarder/](https://www.paws-r-sdk.com/docs/directoryservice_delete_conditional_forwarder/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The directory ID for which you are deleting the conditional forwarder.
#' @param RemoteDomainName &#91;required&#93; The fully qualified domain name (FQDN) of the remote domain with which
#' you are deleting the conditional forwarder.
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_conditional_forwarder
directoryservice_delete_conditional_forwarder <- function(DirectoryId, RemoteDomainName) {
  op <- new_operation(
    name = "DeleteConditionalForwarder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_conditional_forwarder_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName)
  output <- .directoryservice$delete_conditional_forwarder_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_conditional_forwarder <- directoryservice_delete_conditional_forwarder

#' Deletes an Directory Service directory
#'
#' @description
#' Deletes an Directory Service directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_delete_directory/](https://www.paws-r-sdk.com/docs/directoryservice_delete_directory/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory to delete.
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_directory
directoryservice_delete_directory <- function(DirectoryId) {
  op <- new_operation(
    name = "DeleteDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_directory_input(DirectoryId = DirectoryId)
  output <- .directoryservice$delete_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_directory <- directoryservice_delete_directory

#' Deletes the specified log subscription
#'
#' @description
#' Deletes the specified log subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_delete_log_subscription/](https://www.paws-r-sdk.com/docs/directoryservice_delete_log_subscription/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory whose log subscription you want to delete.
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_log_subscription
directoryservice_delete_log_subscription <- function(DirectoryId) {
  op <- new_operation(
    name = "DeleteLogSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_log_subscription_input(DirectoryId = DirectoryId)
  output <- .directoryservice$delete_log_subscription_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_log_subscription <- directoryservice_delete_log_subscription

#' Deletes a directory snapshot
#'
#' @description
#' Deletes a directory snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_delete_snapshot/](https://www.paws-r-sdk.com/docs/directoryservice_delete_snapshot/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The identifier of the directory snapshot to be deleted.
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_snapshot
directoryservice_delete_snapshot <- function(SnapshotId) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_snapshot_input(SnapshotId = SnapshotId)
  output <- .directoryservice$delete_snapshot_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_snapshot <- directoryservice_delete_snapshot

#' Deletes an existing trust relationship between your Managed Microsoft AD
#' directory and an external domain
#'
#' @description
#' Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_delete_trust/](https://www.paws-r-sdk.com/docs/directoryservice_delete_trust/) for full documentation.
#'
#' @param TrustId &#91;required&#93; The Trust ID of the trust relationship to be deleted.
#' @param DeleteAssociatedConditionalForwarder Delete a conditional forwarder as part of a DeleteTrustRequest.
#'
#' @keywords internal
#'
#' @rdname directoryservice_delete_trust
directoryservice_delete_trust <- function(TrustId, DeleteAssociatedConditionalForwarder = NULL) {
  op <- new_operation(
    name = "DeleteTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$delete_trust_input(TrustId = TrustId, DeleteAssociatedConditionalForwarder = DeleteAssociatedConditionalForwarder)
  output <- .directoryservice$delete_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$delete_trust <- directoryservice_delete_trust

#' Deletes from the system the certificate that was registered for secure
#' LDAP or client certificate authentication
#'
#' @description
#' Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_deregister_certificate/](https://www.paws-r-sdk.com/docs/directoryservice_deregister_certificate/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param CertificateId &#91;required&#93; The identifier of the certificate.
#'
#' @keywords internal
#'
#' @rdname directoryservice_deregister_certificate
directoryservice_deregister_certificate <- function(DirectoryId, CertificateId) {
  op <- new_operation(
    name = "DeregisterCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$deregister_certificate_input(DirectoryId = DirectoryId, CertificateId = CertificateId)
  output <- .directoryservice$deregister_certificate_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$deregister_certificate <- directoryservice_deregister_certificate

#' Removes the specified directory as a publisher to the specified Amazon
#' SNS topic
#'
#' @description
#' Removes the specified directory as a publisher to the specified Amazon SNS topic.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_deregister_event_topic/](https://www.paws-r-sdk.com/docs/directoryservice_deregister_event_topic/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The Directory ID to remove as a publisher. This directory will no longer
#' send messages to the specified Amazon SNS topic.
#' @param TopicName &#91;required&#93; The name of the Amazon SNS topic from which to remove the directory as a
#' publisher.
#'
#' @keywords internal
#'
#' @rdname directoryservice_deregister_event_topic
directoryservice_deregister_event_topic <- function(DirectoryId, TopicName) {
  op <- new_operation(
    name = "DeregisterEventTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$deregister_event_topic_input(DirectoryId = DirectoryId, TopicName = TopicName)
  output <- .directoryservice$deregister_event_topic_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$deregister_event_topic <- directoryservice_deregister_event_topic

#' Displays information about the certificate registered for secure LDAP or
#' client certificate authentication
#'
#' @description
#' Displays information about the certificate registered for secure LDAP or client certificate authentication.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_certificate/](https://www.paws-r-sdk.com/docs/directoryservice_describe_certificate/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param CertificateId &#91;required&#93; The identifier of the certificate.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_certificate
directoryservice_describe_certificate <- function(DirectoryId, CertificateId) {
  op <- new_operation(
    name = "DescribeCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_certificate_input(DirectoryId = DirectoryId, CertificateId = CertificateId)
  output <- .directoryservice$describe_certificate_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_certificate <- directoryservice_describe_certificate

#' Retrieves information about the type of client authentication for the
#' specified directory, if the type is specified
#'
#' @description
#' Retrieves information about the type of client authentication for the specified directory, if the type is specified. If no type is specified, information about all client authentication types that are supported for the specified directory is retrieved. Currently, only `SmartCard` is supported.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_client_authentication_settings/](https://www.paws-r-sdk.com/docs/directoryservice_describe_client_authentication_settings/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to retrieve information.
#' @param Type The type of client authentication for which to retrieve information. If
#' no type is specified, a list of all client authentication types that are
#' supported for the specified directory is retrieved.
#' @param NextToken The *DescribeClientAuthenticationSettingsResult.NextToken* value from a
#' previous call to
#' [`describe_client_authentication_settings`][directoryservice_describe_client_authentication_settings].
#' Pass null if this is the first call.
#' @param Limit The maximum number of items to return. If this value is zero, the
#' maximum number of items is specified by the limitations of the
#' operation.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_client_authentication_settings
directoryservice_describe_client_authentication_settings <- function(DirectoryId, Type = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeClientAuthenticationSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "ClientAuthenticationSettingsInfo")
  )
  input <- .directoryservice$describe_client_authentication_settings_input(DirectoryId = DirectoryId, Type = Type, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_client_authentication_settings_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_client_authentication_settings <- directoryservice_describe_client_authentication_settings

#' Obtains information about the conditional forwarders for this account
#'
#' @description
#' Obtains information about the conditional forwarders for this account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_conditional_forwarders/](https://www.paws-r-sdk.com/docs/directoryservice_describe_conditional_forwarders/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The directory ID for which to get the list of associated conditional
#' forwarders.
#' @param RemoteDomainNames The fully qualified domain names (FQDN) of the remote domains for which
#' to get the list of associated conditional forwarders. If this member is
#' null, all conditional forwarders are returned.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_conditional_forwarders
directoryservice_describe_conditional_forwarders <- function(DirectoryId, RemoteDomainNames = NULL) {
  op <- new_operation(
    name = "DescribeConditionalForwarders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_conditional_forwarders_input(DirectoryId = DirectoryId, RemoteDomainNames = RemoteDomainNames)
  output <- .directoryservice$describe_conditional_forwarders_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_conditional_forwarders <- directoryservice_describe_conditional_forwarders

#' Obtains information about the directories that belong to this account
#'
#' @description
#' Obtains information about the directories that belong to this account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_directories/](https://www.paws-r-sdk.com/docs/directoryservice_describe_directories/) for full documentation.
#'
#' @param DirectoryIds A list of identifiers of the directories for which to obtain the
#' information. If this member is null, all directories that belong to the
#' current account are returned.
#' 
#' An empty list results in an `InvalidParameterException` being thrown.
#' @param NextToken The `DescribeDirectoriesResult.NextToken` value from a previous call to
#' [`describe_directories`][directoryservice_describe_directories]. Pass
#' null if this is the first call.
#' @param Limit The maximum number of items to return. If this value is zero, the
#' maximum number of items is specified by the limitations of the
#' operation.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_directories
directoryservice_describe_directories <- function(DirectoryIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeDirectories",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "DirectoryDescriptions")
  )
  input <- .directoryservice$describe_directories_input(DirectoryIds = DirectoryIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_directories_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_directories <- directoryservice_describe_directories

#' Provides information about any domain controllers in your directory
#'
#' @description
#' Provides information about any domain controllers in your directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_domain_controllers/](https://www.paws-r-sdk.com/docs/directoryservice_describe_domain_controllers/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory for which to retrieve the domain controller
#' information.
#' @param DomainControllerIds A list of identifiers for the domain controllers whose information will
#' be provided.
#' @param NextToken The *DescribeDomainControllers.NextToken* value from a previous call to
#' [`describe_domain_controllers`][directoryservice_describe_domain_controllers].
#' Pass null if this is the first call.
#' @param Limit The maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_domain_controllers
directoryservice_describe_domain_controllers <- function(DirectoryId, DomainControllerIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeDomainControllers",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken")
  )
  input <- .directoryservice$describe_domain_controllers_input(DirectoryId = DirectoryId, DomainControllerIds = DomainControllerIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_domain_controllers_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_domain_controllers <- directoryservice_describe_domain_controllers

#' Obtains information about which Amazon SNS topics receive status
#' messages from the specified directory
#'
#' @description
#' Obtains information about which Amazon SNS topics receive status messages from the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_event_topics/](https://www.paws-r-sdk.com/docs/directoryservice_describe_event_topics/) for full documentation.
#'
#' @param DirectoryId The Directory ID for which to get the list of associated Amazon SNS
#' topics. If this member is null, associations for all Directory IDs are
#' returned.
#' @param TopicNames A list of Amazon SNS topic names for which to obtain the information. If
#' this member is null, all associations for the specified Directory ID are
#' returned.
#' 
#' An empty list results in an `InvalidParameterException` being thrown.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_event_topics
directoryservice_describe_event_topics <- function(DirectoryId = NULL, TopicNames = NULL) {
  op <- new_operation(
    name = "DescribeEventTopics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_event_topics_input(DirectoryId = DirectoryId, TopicNames = TopicNames)
  output <- .directoryservice$describe_event_topics_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_event_topics <- directoryservice_describe_event_topics

#' Describes the status of LDAP security for the specified directory
#'
#' @description
#' Describes the status of LDAP security for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_ldaps_settings/](https://www.paws-r-sdk.com/docs/directoryservice_describe_ldaps_settings/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param Type The type of LDAP security to enable. Currently only the value `Client`
#' is supported.
#' @param NextToken The type of next token used for pagination.
#' @param Limit Specifies the number of items that should be displayed on one page.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_ldaps_settings
directoryservice_describe_ldaps_settings <- function(DirectoryId, Type = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeLDAPSSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "LDAPSSettingsInfo")
  )
  input <- .directoryservice$describe_ldaps_settings_input(DirectoryId = DirectoryId, Type = Type, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_ldaps_settings_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_ldaps_settings <- directoryservice_describe_ldaps_settings

#' Provides information about the Regions that are configured for
#' multi-Region replication
#'
#' @description
#' Provides information about the Regions that are configured for multi-Region replication.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_regions/](https://www.paws-r-sdk.com/docs/directoryservice_describe_regions/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param RegionName The name of the Region. For example, `us-east-1`.
#' @param NextToken The `DescribeRegionsResult.NextToken` value from a previous call to
#' [`describe_regions`][directoryservice_describe_regions]. Pass null if
#' this is the first call.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_regions
directoryservice_describe_regions <- function(DirectoryId, RegionName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "RegionsDescription")
  )
  input <- .directoryservice$describe_regions_input(DirectoryId = DirectoryId, RegionName = RegionName, NextToken = NextToken)
  output <- .directoryservice$describe_regions_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_regions <- directoryservice_describe_regions

#' Retrieves information about the configurable settings for the specified
#' directory
#'
#' @description
#' Retrieves information about the configurable settings for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_settings/](https://www.paws-r-sdk.com/docs/directoryservice_describe_settings/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to retrieve information.
#' @param Status The status of the directory settings for which to retrieve information.
#' @param NextToken The `DescribeSettingsResult.NextToken` value from a previous call to
#' [`describe_settings`][directoryservice_describe_settings]. Pass null if
#' this is the first call.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_settings
directoryservice_describe_settings <- function(DirectoryId, Status = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$describe_settings_input(DirectoryId = DirectoryId, Status = Status, NextToken = NextToken)
  output <- .directoryservice$describe_settings_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_settings <- directoryservice_describe_settings

#' Returns the shared directories in your account
#'
#' @description
#' Returns the shared directories in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_shared_directories/](https://www.paws-r-sdk.com/docs/directoryservice_describe_shared_directories/) for full documentation.
#'
#' @param OwnerDirectoryId &#91;required&#93; Returns the identifier of the directory in the directory owner account.
#' @param SharedDirectoryIds A list of identifiers of all shared directories in your account.
#' @param NextToken The `DescribeSharedDirectoriesResult.NextToken` value from a previous
#' call to
#' [`describe_shared_directories`][directoryservice_describe_shared_directories].
#' Pass null if this is the first call.
#' @param Limit The number of shared directories to return in the response object.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_shared_directories
directoryservice_describe_shared_directories <- function(OwnerDirectoryId, SharedDirectoryIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeSharedDirectories",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "SharedDirectories")
  )
  input <- .directoryservice$describe_shared_directories_input(OwnerDirectoryId = OwnerDirectoryId, SharedDirectoryIds = SharedDirectoryIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_shared_directories_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_shared_directories <- directoryservice_describe_shared_directories

#' Obtains information about the directory snapshots that belong to this
#' account
#'
#' @description
#' Obtains information about the directory snapshots that belong to this account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_snapshots/](https://www.paws-r-sdk.com/docs/directoryservice_describe_snapshots/) for full documentation.
#'
#' @param DirectoryId The identifier of the directory for which to retrieve snapshot
#' information.
#' @param SnapshotIds A list of identifiers of the snapshots to obtain the information for. If
#' this member is null or empty, all snapshots are returned using the
#' *Limit* and *NextToken* members.
#' @param NextToken The *DescribeSnapshotsResult.NextToken* value from a previous call to
#' [`describe_snapshots`][directoryservice_describe_snapshots]. Pass null
#' if this is the first call.
#' @param Limit The maximum number of objects to return.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_snapshots
directoryservice_describe_snapshots <- function(DirectoryId = NULL, SnapshotIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "Snapshots")
  )
  input <- .directoryservice$describe_snapshots_input(DirectoryId = DirectoryId, SnapshotIds = SnapshotIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_snapshots_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_snapshots <- directoryservice_describe_snapshots

#' Obtains information about the trust relationships for this account
#'
#' @description
#' Obtains information about the trust relationships for this account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_trusts/](https://www.paws-r-sdk.com/docs/directoryservice_describe_trusts/) for full documentation.
#'
#' @param DirectoryId The Directory ID of the Amazon Web Services directory that is a part of
#' the requested trust relationship.
#' @param TrustIds A list of identifiers of the trust relationships for which to obtain the
#' information. If this member is null, all trust relationships that belong
#' to the current account are returned.
#' 
#' An empty list results in an `InvalidParameterException` being thrown.
#' @param NextToken The *DescribeTrustsResult.NextToken* value from a previous call to
#' [`describe_trusts`][directoryservice_describe_trusts]. Pass null if this
#' is the first call.
#' @param Limit The maximum number of objects to return.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_trusts
directoryservice_describe_trusts <- function(DirectoryId = NULL, TrustIds = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTrusts",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "Trusts")
  )
  input <- .directoryservice$describe_trusts_input(DirectoryId = DirectoryId, TrustIds = TrustIds, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$describe_trusts_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_trusts <- directoryservice_describe_trusts

#' Describes the updates of a directory for a particular update type
#'
#' @description
#' Describes the updates of a directory for a particular update type.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_describe_update_directory/](https://www.paws-r-sdk.com/docs/directoryservice_describe_update_directory/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The unique identifier of the directory.
#' @param UpdateType &#91;required&#93; The type of updates you want to describe for the directory.
#' @param RegionName The name of the Region.
#' @param NextToken The `DescribeUpdateDirectoryResult`. NextToken value from a previous
#' call to
#' [`describe_update_directory`][directoryservice_describe_update_directory].
#' Pass null if this is the first call.
#'
#' @keywords internal
#'
#' @rdname directoryservice_describe_update_directory
directoryservice_describe_update_directory <- function(DirectoryId, UpdateType, RegionName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUpdateDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "UpdateActivities")
  )
  input <- .directoryservice$describe_update_directory_input(DirectoryId = DirectoryId, UpdateType = UpdateType, RegionName = RegionName, NextToken = NextToken)
  output <- .directoryservice$describe_update_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$describe_update_directory <- directoryservice_describe_update_directory

#' Disables alternative client authentication methods for the specified
#' directory
#'
#' @description
#' Disables alternative client authentication methods for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_disable_client_authentication/](https://www.paws-r-sdk.com/docs/directoryservice_disable_client_authentication/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory
#' @param Type &#91;required&#93; The type of client authentication to disable. Currently, only the
#' parameter, `SmartCard` is supported.
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_client_authentication
directoryservice_disable_client_authentication <- function(DirectoryId, Type) {
  op <- new_operation(
    name = "DisableClientAuthentication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_client_authentication_input(DirectoryId = DirectoryId, Type = Type)
  output <- .directoryservice$disable_client_authentication_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_client_authentication <- directoryservice_disable_client_authentication

#' Deactivates LDAP secure calls for the specified directory
#'
#' @description
#' Deactivates LDAP secure calls for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_disable_ldaps/](https://www.paws-r-sdk.com/docs/directoryservice_disable_ldaps/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param Type &#91;required&#93; The type of LDAP security to enable. Currently only the value `Client`
#' is supported.
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_ldaps
directoryservice_disable_ldaps <- function(DirectoryId, Type) {
  op <- new_operation(
    name = "DisableLDAPS",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_ldaps_input(DirectoryId = DirectoryId, Type = Type)
  output <- .directoryservice$disable_ldaps_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_ldaps <- directoryservice_disable_ldaps

#' Disables multi-factor authentication (MFA) with the Remote
#' Authentication Dial In User Service (RADIUS) server for an AD Connector
#' or Microsoft AD directory
#'
#' @description
#' Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_disable_radius/](https://www.paws-r-sdk.com/docs/directoryservice_disable_radius/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to disable MFA.
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_radius
directoryservice_disable_radius <- function(DirectoryId) {
  op <- new_operation(
    name = "DisableRadius",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_radius_input(DirectoryId = DirectoryId)
  output <- .directoryservice$disable_radius_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_radius <- directoryservice_disable_radius

#' Disables single-sign on for a directory
#'
#' @description
#' Disables single-sign on for a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_disable_sso/](https://www.paws-r-sdk.com/docs/directoryservice_disable_sso/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to disable single-sign on.
#' @param UserName The username of an alternate account to use to disable single-sign on.
#' This is only used for AD Connector directories. This account must have
#' privileges to remove a service principal name.
#' 
#' If the AD Connector service account does not have privileges to remove a
#' service principal name, you can specify an alternate account with the
#' *UserName* and *Password* parameters. These credentials are only used to
#' disable single sign-on and are not stored by the service. The AD
#' Connector service account is not changed.
#' @param Password The password of an alternate account to use to disable single-sign on.
#' This is only used for AD Connector directories. For more information,
#' see the *UserName* parameter.
#'
#' @keywords internal
#'
#' @rdname directoryservice_disable_sso
directoryservice_disable_sso <- function(DirectoryId, UserName = NULL, Password = NULL) {
  op <- new_operation(
    name = "DisableSso",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$disable_sso_input(DirectoryId = DirectoryId, UserName = UserName, Password = Password)
  output <- .directoryservice$disable_sso_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$disable_sso <- directoryservice_disable_sso

#' Enables alternative client authentication methods for the specified
#' directory
#'
#' @description
#' Enables alternative client authentication methods for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_enable_client_authentication/](https://www.paws-r-sdk.com/docs/directoryservice_enable_client_authentication/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the specified directory.
#' @param Type &#91;required&#93; The type of client authentication to enable. Currently only the value
#' `SmartCard` is supported. Smart card authentication in AD Connector
#' requires that you enable Kerberos Constrained Delegation for the Service
#' User to the LDAP service in your self-managed AD.
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_client_authentication
directoryservice_enable_client_authentication <- function(DirectoryId, Type) {
  op <- new_operation(
    name = "EnableClientAuthentication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_client_authentication_input(DirectoryId = DirectoryId, Type = Type)
  output <- .directoryservice$enable_client_authentication_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_client_authentication <- directoryservice_enable_client_authentication

#' Activates the switch for the specific directory to always use LDAP
#' secure calls
#'
#' @description
#' Activates the switch for the specific directory to always use LDAP secure calls.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_enable_ldaps/](https://www.paws-r-sdk.com/docs/directoryservice_enable_ldaps/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param Type &#91;required&#93; The type of LDAP security to enable. Currently only the value `Client`
#' is supported.
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_ldaps
directoryservice_enable_ldaps <- function(DirectoryId, Type) {
  op <- new_operation(
    name = "EnableLDAPS",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_ldaps_input(DirectoryId = DirectoryId, Type = Type)
  output <- .directoryservice$enable_ldaps_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_ldaps <- directoryservice_enable_ldaps

#' Enables multi-factor authentication (MFA) with the Remote Authentication
#' Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD
#' directory
#'
#' @description
#' Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_enable_radius/](https://www.paws-r-sdk.com/docs/directoryservice_enable_radius/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to enable MFA.
#' @param RadiusSettings &#91;required&#93; A RadiusSettings object that contains information about the RADIUS
#' server.
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_radius
directoryservice_enable_radius <- function(DirectoryId, RadiusSettings) {
  op <- new_operation(
    name = "EnableRadius",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_radius_input(DirectoryId = DirectoryId, RadiusSettings = RadiusSettings)
  output <- .directoryservice$enable_radius_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_radius <- directoryservice_enable_radius

#' Enables single sign-on for a directory
#'
#' @description
#' Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon Web Services services from a computer joined to the directory without having to enter their credentials separately.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_enable_sso/](https://www.paws-r-sdk.com/docs/directoryservice_enable_sso/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to enable single-sign on.
#' @param UserName The username of an alternate account to use to enable single-sign on.
#' This is only used for AD Connector directories. This account must have
#' privileges to add a service principal name.
#' 
#' If the AD Connector service account does not have privileges to add a
#' service principal name, you can specify an alternate account with the
#' *UserName* and *Password* parameters. These credentials are only used to
#' enable single sign-on and are not stored by the service. The AD
#' Connector service account is not changed.
#' @param Password The password of an alternate account to use to enable single-sign on.
#' This is only used for AD Connector directories. For more information,
#' see the *UserName* parameter.
#'
#' @keywords internal
#'
#' @rdname directoryservice_enable_sso
directoryservice_enable_sso <- function(DirectoryId, UserName = NULL, Password = NULL) {
  op <- new_operation(
    name = "EnableSso",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$enable_sso_input(DirectoryId = DirectoryId, UserName = UserName, Password = Password)
  output <- .directoryservice$enable_sso_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$enable_sso <- directoryservice_enable_sso

#' Obtains directory limit information for the current Region
#'
#' @description
#' Obtains directory limit information for the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_get_directory_limits/](https://www.paws-r-sdk.com/docs/directoryservice_get_directory_limits/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname directoryservice_get_directory_limits
directoryservice_get_directory_limits <- function() {
  op <- new_operation(
    name = "GetDirectoryLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$get_directory_limits_input()
  output <- .directoryservice$get_directory_limits_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$get_directory_limits <- directoryservice_get_directory_limits

#' Obtains the manual snapshot limits for a directory
#'
#' @description
#' Obtains the manual snapshot limits for a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_get_snapshot_limits/](https://www.paws-r-sdk.com/docs/directoryservice_get_snapshot_limits/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Contains the identifier of the directory to obtain the limits for.
#'
#' @keywords internal
#'
#' @rdname directoryservice_get_snapshot_limits
directoryservice_get_snapshot_limits <- function(DirectoryId) {
  op <- new_operation(
    name = "GetSnapshotLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$get_snapshot_limits_input(DirectoryId = DirectoryId)
  output <- .directoryservice$get_snapshot_limits_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$get_snapshot_limits <- directoryservice_get_snapshot_limits

#' For the specified directory, lists all the certificates registered for a
#' secure LDAP or client certificate authentication
#'
#' @description
#' For the specified directory, lists all the certificates registered for a secure LDAP or client certificate authentication.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_list_certificates/](https://www.paws-r-sdk.com/docs/directoryservice_list_certificates/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param NextToken A token for requesting another page of certificates if the `NextToken`
#' response element indicates that more certificates are available. Use the
#' value of the returned `NextToken` element in your request until the
#' token comes back as `null`. Pass `null` if this is the first call.
#' @param Limit The number of items that should show up on one page
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_certificates
directoryservice_list_certificates <- function(DirectoryId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "CertificatesInfo")
  )
  input <- .directoryservice$list_certificates_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_certificates_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_certificates <- directoryservice_list_certificates

#' Lists the address blocks that you have added to a directory
#'
#' @description
#' Lists the address blocks that you have added to a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_list_ip_routes/](https://www.paws-r-sdk.com/docs/directoryservice_list_ip_routes/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier (ID) of the directory for which you want to retrieve the IP
#' addresses.
#' @param NextToken The *ListIpRoutes.NextToken* value from a previous call to
#' [`list_ip_routes`][directoryservice_list_ip_routes]. Pass null if this
#' is the first call.
#' @param Limit Maximum number of items to return. If this value is zero, the maximum
#' number of items is specified by the limitations of the operation.
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_ip_routes
directoryservice_list_ip_routes <- function(DirectoryId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListIpRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "IpRoutesInfo")
  )
  input <- .directoryservice$list_ip_routes_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_ip_routes_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_ip_routes <- directoryservice_list_ip_routes

#' Lists the active log subscriptions for the Amazon Web Services account
#'
#' @description
#' Lists the active log subscriptions for the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_list_log_subscriptions/](https://www.paws-r-sdk.com/docs/directoryservice_list_log_subscriptions/) for full documentation.
#'
#' @param DirectoryId If a *DirectoryID* is provided, lists only the log subscription
#' associated with that directory. If no *DirectoryId* is provided, lists
#' all log subscriptions associated with your Amazon Web Services account.
#' If there are no log subscriptions for the Amazon Web Services account or
#' the directory, an empty list will be returned.
#' @param NextToken The token for the next set of items to return.
#' @param Limit The maximum number of items returned.
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_log_subscriptions
directoryservice_list_log_subscriptions <- function(DirectoryId = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListLogSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "LogSubscriptions")
  )
  input <- .directoryservice$list_log_subscriptions_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_log_subscriptions_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_log_subscriptions <- directoryservice_list_log_subscriptions

#' Lists all schema extensions applied to a Microsoft AD Directory
#'
#' @description
#' Lists all schema extensions applied to a Microsoft AD Directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_list_schema_extensions/](https://www.paws-r-sdk.com/docs/directoryservice_list_schema_extensions/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory from which to retrieve the schema
#' extension information.
#' @param NextToken The `ListSchemaExtensions.NextToken` value from a previous call to
#' [`list_schema_extensions`][directoryservice_list_schema_extensions].
#' Pass null if this is the first call.
#' @param Limit The maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_schema_extensions
directoryservice_list_schema_extensions <- function(DirectoryId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSchemaExtensions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "SchemaExtensionsInfo")
  )
  input <- .directoryservice$list_schema_extensions_input(DirectoryId = DirectoryId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_schema_extensions_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_schema_extensions <- directoryservice_list_schema_extensions

#' Lists all tags on a directory
#'
#' @description
#' Lists all tags on a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/directoryservice_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Identifier (ID) of the directory for which you want to retrieve tags.
#' @param NextToken Reserved for future use.
#' @param Limit Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname directoryservice_list_tags_for_resource
directoryservice_list_tags_for_resource <- function(ResourceId, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "Tags")
  )
  input <- .directoryservice$list_tags_for_resource_input(ResourceId = ResourceId, NextToken = NextToken, Limit = Limit)
  output <- .directoryservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$list_tags_for_resource <- directoryservice_list_tags_for_resource

#' Registers a certificate for a secure LDAP or client certificate
#' authentication
#'
#' @description
#' Registers a certificate for a secure LDAP or client certificate authentication.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_register_certificate/](https://www.paws-r-sdk.com/docs/directoryservice_register_certificate/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param CertificateData &#91;required&#93; The certificate PEM string that needs to be registered.
#' @param Type The function that the registered certificate performs. Valid values
#' include `ClientLDAPS` or `ClientCertAuth`. The default value is
#' `ClientLDAPS`.
#' @param ClientCertAuthSettings A `ClientCertAuthSettings` object that contains client certificate
#' authentication settings.
#'
#' @keywords internal
#'
#' @rdname directoryservice_register_certificate
directoryservice_register_certificate <- function(DirectoryId, CertificateData, Type = NULL, ClientCertAuthSettings = NULL) {
  op <- new_operation(
    name = "RegisterCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$register_certificate_input(DirectoryId = DirectoryId, CertificateData = CertificateData, Type = Type, ClientCertAuthSettings = ClientCertAuthSettings)
  output <- .directoryservice$register_certificate_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$register_certificate <- directoryservice_register_certificate

#' Associates a directory with an Amazon SNS topic
#'
#' @description
#' Associates a directory with an Amazon SNS topic. This establishes the directory as a publisher to the specified Amazon SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes. You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also receive a notification when the directory returns to an Active status.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_register_event_topic/](https://www.paws-r-sdk.com/docs/directoryservice_register_event_topic/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The Directory ID that will publish status messages to the Amazon SNS
#' topic.
#' @param TopicName &#91;required&#93; The Amazon SNS topic name to which the directory will publish status
#' messages. This Amazon SNS topic must be in the same region as the
#' specified Directory ID.
#'
#' @keywords internal
#'
#' @rdname directoryservice_register_event_topic
directoryservice_register_event_topic <- function(DirectoryId, TopicName) {
  op <- new_operation(
    name = "RegisterEventTopic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$register_event_topic_input(DirectoryId = DirectoryId, TopicName = TopicName)
  output <- .directoryservice$register_event_topic_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$register_event_topic <- directoryservice_register_event_topic

#' Rejects a directory sharing request that was sent from the directory
#' owner account
#'
#' @description
#' Rejects a directory sharing request that was sent from the directory owner account.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_reject_shared_directory/](https://www.paws-r-sdk.com/docs/directoryservice_reject_shared_directory/) for full documentation.
#'
#' @param SharedDirectoryId &#91;required&#93; Identifier of the shared directory in the directory consumer account.
#' This identifier is different for each directory owner account.
#'
#' @keywords internal
#'
#' @rdname directoryservice_reject_shared_directory
directoryservice_reject_shared_directory <- function(SharedDirectoryId) {
  op <- new_operation(
    name = "RejectSharedDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$reject_shared_directory_input(SharedDirectoryId = SharedDirectoryId)
  output <- .directoryservice$reject_shared_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$reject_shared_directory <- directoryservice_reject_shared_directory

#' Removes IP address blocks from a directory
#'
#' @description
#' Removes IP address blocks from a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_remove_ip_routes/](https://www.paws-r-sdk.com/docs/directoryservice_remove_ip_routes/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier (ID) of the directory from which you want to remove the IP
#' addresses.
#' @param CidrIps &#91;required&#93; IP address blocks that you want to remove.
#'
#' @keywords internal
#'
#' @rdname directoryservice_remove_ip_routes
directoryservice_remove_ip_routes <- function(DirectoryId, CidrIps) {
  op <- new_operation(
    name = "RemoveIpRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$remove_ip_routes_input(DirectoryId = DirectoryId, CidrIps = CidrIps)
  output <- .directoryservice$remove_ip_routes_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$remove_ip_routes <- directoryservice_remove_ip_routes

#' Stops all replication and removes the domain controllers from the
#' specified Region
#'
#' @description
#' Stops all replication and removes the domain controllers from the specified Region. You cannot remove the primary Region with this operation. Instead, use the [`delete_directory`][directoryservice_delete_directory] API.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_remove_region/](https://www.paws-r-sdk.com/docs/directoryservice_remove_region/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which you want to remove Region
#' replication.
#'
#' @keywords internal
#'
#' @rdname directoryservice_remove_region
directoryservice_remove_region <- function(DirectoryId) {
  op <- new_operation(
    name = "RemoveRegion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$remove_region_input(DirectoryId = DirectoryId)
  output <- .directoryservice$remove_region_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$remove_region <- directoryservice_remove_region

#' Removes tags from a directory
#'
#' @description
#' Removes tags from a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_remove_tags_from_resource/](https://www.paws-r-sdk.com/docs/directoryservice_remove_tags_from_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Identifier (ID) of the directory from which to remove the tag.
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @keywords internal
#'
#' @rdname directoryservice_remove_tags_from_resource
directoryservice_remove_tags_from_resource <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$remove_tags_from_resource_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .directoryservice$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$remove_tags_from_resource <- directoryservice_remove_tags_from_resource

#' Resets the password for any user in your Managed Microsoft AD or Simple
#' AD directory
#'
#' @description
#' Resets the password for any user in your Managed Microsoft AD or Simple AD directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_reset_user_password/](https://www.paws-r-sdk.com/docs/directoryservice_reset_user_password/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier of the Managed Microsoft AD or Simple AD directory in which
#' the user resides.
#' @param UserName &#91;required&#93; The user name of the user whose password will be reset.
#' @param NewPassword &#91;required&#93; The new password that will be reset.
#'
#' @keywords internal
#'
#' @rdname directoryservice_reset_user_password
directoryservice_reset_user_password <- function(DirectoryId, UserName, NewPassword) {
  op <- new_operation(
    name = "ResetUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$reset_user_password_input(DirectoryId = DirectoryId, UserName = UserName, NewPassword = NewPassword)
  output <- .directoryservice$reset_user_password_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$reset_user_password <- directoryservice_reset_user_password

#' Restores a directory using an existing directory snapshot
#'
#' @description
#' Restores a directory using an existing directory snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_restore_from_snapshot/](https://www.paws-r-sdk.com/docs/directoryservice_restore_from_snapshot/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The identifier of the snapshot to restore from.
#'
#' @keywords internal
#'
#' @rdname directoryservice_restore_from_snapshot
directoryservice_restore_from_snapshot <- function(SnapshotId) {
  op <- new_operation(
    name = "RestoreFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$restore_from_snapshot_input(SnapshotId = SnapshotId)
  output <- .directoryservice$restore_from_snapshot_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$restore_from_snapshot <- directoryservice_restore_from_snapshot

#' Shares a specified directory (DirectoryId) in your Amazon Web Services
#' account (directory owner) with another Amazon Web Services account
#' (directory consumer)
#'
#' @description
#' Shares a specified directory (`DirectoryId`) in your Amazon Web Services account (directory owner) with another Amazon Web Services account (directory consumer). With this operation you can use your directory from any Amazon Web Services account and from any Amazon VPC within an Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_share_directory/](https://www.paws-r-sdk.com/docs/directoryservice_share_directory/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier of the Managed Microsoft AD directory that you want to share
#' with other Amazon Web Services accounts.
#' @param ShareNotes A directory share request that is sent by the directory owner to the
#' directory consumer. The request includes a typed message to help the
#' directory consumer administrator determine whether to approve or reject
#' the share invitation.
#' @param ShareTarget &#91;required&#93; Identifier for the directory consumer account with whom the directory is
#' to be shared.
#' @param ShareMethod &#91;required&#93; The method used when sharing a directory to determine whether the
#' directory should be shared within your Amazon Web Services organization
#' (`ORGANIZATIONS`) or with any Amazon Web Services account by sending a
#' directory sharing request (`HANDSHAKE`).
#'
#' @keywords internal
#'
#' @rdname directoryservice_share_directory
directoryservice_share_directory <- function(DirectoryId, ShareNotes = NULL, ShareTarget, ShareMethod) {
  op <- new_operation(
    name = "ShareDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$share_directory_input(DirectoryId = DirectoryId, ShareNotes = ShareNotes, ShareTarget = ShareTarget, ShareMethod = ShareMethod)
  output <- .directoryservice$share_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$share_directory <- directoryservice_share_directory

#' Applies a schema extension to a Microsoft AD directory
#'
#' @description
#' Applies a schema extension to a Microsoft AD directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_start_schema_extension/](https://www.paws-r-sdk.com/docs/directoryservice_start_schema_extension/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which the schema extension will be
#' applied to.
#' @param CreateSnapshotBeforeSchemaExtension &#91;required&#93; If true, creates a snapshot of the directory before applying the schema
#' extension.
#' @param LdifContent &#91;required&#93; The LDIF file represented as a string. To construct the LdifContent
#' string, precede each line as it would be formatted in an ldif file with
#' \\n. See the example request below for more details. The file size can
#' be no larger than 1MB.
#' @param Description &#91;required&#93; A description of the schema extension.
#'
#' @keywords internal
#'
#' @rdname directoryservice_start_schema_extension
directoryservice_start_schema_extension <- function(DirectoryId, CreateSnapshotBeforeSchemaExtension, LdifContent, Description) {
  op <- new_operation(
    name = "StartSchemaExtension",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$start_schema_extension_input(DirectoryId = DirectoryId, CreateSnapshotBeforeSchemaExtension = CreateSnapshotBeforeSchemaExtension, LdifContent = LdifContent, Description = Description)
  output <- .directoryservice$start_schema_extension_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$start_schema_extension <- directoryservice_start_schema_extension

#' Stops the directory sharing between the directory owner and consumer
#' accounts
#'
#' @description
#' Stops the directory sharing between the directory owner and consumer accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_unshare_directory/](https://www.paws-r-sdk.com/docs/directoryservice_unshare_directory/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the Managed Microsoft AD directory that you want to
#' stop sharing.
#' @param UnshareTarget &#91;required&#93; Identifier for the directory consumer account with whom the directory
#' has to be unshared.
#'
#' @keywords internal
#'
#' @rdname directoryservice_unshare_directory
directoryservice_unshare_directory <- function(DirectoryId, UnshareTarget) {
  op <- new_operation(
    name = "UnshareDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$unshare_directory_input(DirectoryId = DirectoryId, UnshareTarget = UnshareTarget)
  output <- .directoryservice$unshare_directory_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$unshare_directory <- directoryservice_unshare_directory

#' Updates a conditional forwarder that has been set up for your Amazon Web
#' Services directory
#'
#' @description
#' Updates a conditional forwarder that has been set up for your Amazon Web Services directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_update_conditional_forwarder/](https://www.paws-r-sdk.com/docs/directoryservice_update_conditional_forwarder/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The directory ID of the Amazon Web Services directory for which to
#' update the conditional forwarder.
#' @param RemoteDomainName &#91;required&#93; The fully qualified domain name (FQDN) of the remote domain with which
#' you will set up a trust relationship.
#' @param DnsIpAddrs &#91;required&#93; The updated IP addresses of the remote DNS server associated with the
#' conditional forwarder.
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_conditional_forwarder
directoryservice_update_conditional_forwarder <- function(DirectoryId, RemoteDomainName, DnsIpAddrs) {
  op <- new_operation(
    name = "UpdateConditionalForwarder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_conditional_forwarder_input(DirectoryId = DirectoryId, RemoteDomainName = RemoteDomainName, DnsIpAddrs = DnsIpAddrs)
  output <- .directoryservice$update_conditional_forwarder_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_conditional_forwarder <- directoryservice_update_conditional_forwarder

#' Updates the directory for a particular update type
#'
#' @description
#' Updates the directory for a particular update type.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_update_directory_setup/](https://www.paws-r-sdk.com/docs/directoryservice_update_directory_setup/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory on which you want to perform the update.
#' @param UpdateType &#91;required&#93; The type of update that needs to be performed on the directory. For
#' example, OS.
#' @param OSUpdateSettings The settings for the OS update that needs to be performed on the
#' directory.
#' @param CreateSnapshotBeforeUpdate The boolean that specifies if a snapshot for the directory needs to be
#' taken before updating the directory.
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_directory_setup
directoryservice_update_directory_setup <- function(DirectoryId, UpdateType, OSUpdateSettings = NULL, CreateSnapshotBeforeUpdate = NULL) {
  op <- new_operation(
    name = "UpdateDirectorySetup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_directory_setup_input(DirectoryId = DirectoryId, UpdateType = UpdateType, OSUpdateSettings = OSUpdateSettings, CreateSnapshotBeforeUpdate = CreateSnapshotBeforeUpdate)
  output <- .directoryservice$update_directory_setup_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_directory_setup <- directoryservice_update_directory_setup

#' Adds or removes domain controllers to or from the directory
#'
#' @description
#' Adds or removes domain controllers to or from the directory. Based on the difference between current value and new value (provided through this API call), domain controllers will be added or removed. It may take up to 45 minutes for any new domain controllers to become fully active once the requested number of domain controllers is updated. During this time, you cannot make another update request.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_update_number_of_domain_controllers/](https://www.paws-r-sdk.com/docs/directoryservice_update_number_of_domain_controllers/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; Identifier of the directory to which the domain controllers will be
#' added or removed.
#' @param DesiredNumber &#91;required&#93; The number of domain controllers desired in the directory.
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_number_of_domain_controllers
directoryservice_update_number_of_domain_controllers <- function(DirectoryId, DesiredNumber) {
  op <- new_operation(
    name = "UpdateNumberOfDomainControllers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_number_of_domain_controllers_input(DirectoryId = DirectoryId, DesiredNumber = DesiredNumber)
  output <- .directoryservice$update_number_of_domain_controllers_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_number_of_domain_controllers <- directoryservice_update_number_of_domain_controllers

#' Updates the Remote Authentication Dial In User Service (RADIUS) server
#' information for an AD Connector or Microsoft AD directory
#'
#' @description
#' Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or Microsoft AD directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_update_radius/](https://www.paws-r-sdk.com/docs/directoryservice_update_radius/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to update the RADIUS server
#' information.
#' @param RadiusSettings &#91;required&#93; A RadiusSettings object that contains information about the RADIUS
#' server.
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_radius
directoryservice_update_radius <- function(DirectoryId, RadiusSettings) {
  op <- new_operation(
    name = "UpdateRadius",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_radius_input(DirectoryId = DirectoryId, RadiusSettings = RadiusSettings)
  output <- .directoryservice$update_radius_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_radius <- directoryservice_update_radius

#' Updates the configurable settings for the specified directory
#'
#' @description
#' Updates the configurable settings for the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_update_settings/](https://www.paws-r-sdk.com/docs/directoryservice_update_settings/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory for which to update settings.
#' @param Settings &#91;required&#93; The list of Setting objects.
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_settings
directoryservice_update_settings <- function(DirectoryId, Settings) {
  op <- new_operation(
    name = "UpdateSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_settings_input(DirectoryId = DirectoryId, Settings = Settings)
  output <- .directoryservice$update_settings_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_settings <- directoryservice_update_settings

#' Updates the trust that has been set up between your Managed Microsoft AD
#' directory and an self-managed Active Directory
#'
#' @description
#' Updates the trust that has been set up between your Managed Microsoft AD directory and an self-managed Active Directory.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_update_trust/](https://www.paws-r-sdk.com/docs/directoryservice_update_trust/) for full documentation.
#'
#' @param TrustId &#91;required&#93; Identifier of the trust relationship.
#' @param SelectiveAuth Updates selective authentication for the trust.
#'
#' @keywords internal
#'
#' @rdname directoryservice_update_trust
directoryservice_update_trust <- function(TrustId, SelectiveAuth = NULL) {
  op <- new_operation(
    name = "UpdateTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$update_trust_input(TrustId = TrustId, SelectiveAuth = SelectiveAuth)
  output <- .directoryservice$update_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$update_trust <- directoryservice_update_trust

#' Directory Service for Microsoft Active Directory allows you to configure
#' and verify trust relationships
#'
#' @description
#' Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships.
#'
#' See [https://www.paws-r-sdk.com/docs/directoryservice_verify_trust/](https://www.paws-r-sdk.com/docs/directoryservice_verify_trust/) for full documentation.
#'
#' @param TrustId &#91;required&#93; The unique Trust ID of the trust relationship to verify.
#'
#' @keywords internal
#'
#' @rdname directoryservice_verify_trust
directoryservice_verify_trust <- function(TrustId) {
  op <- new_operation(
    name = "VerifyTrust",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .directoryservice$verify_trust_input(TrustId = TrustId)
  output <- .directoryservice$verify_trust_output()
  config <- get_config()
  svc <- .directoryservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.directoryservice$operations$verify_trust <- directoryservice_verify_trust
