% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_confirm_sign_up}
\alias{cognitoidentityprovider_admin_confirm_sign_up}
\title{This IAM-authenticated API operation provides a code that Amazon Cognito
sent to your user when they signed up in your user pool}
\usage{
cognitoidentityprovider_admin_confirm_sign_up(
  UserPoolId,
  Username,
  ClientMetadata = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for which you want to confirm user registration.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, you can also use their \code{sub} in this request.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

If your user pool configuration includes triggers, the
AdminConfirmSignUp API action invokes the Lambda function that is
specified for the \emph{post confirmation} trigger. When Amazon Cognito
invokes this function, it passes a JSON payload, which the function
receives as input. In this payload, the \code{clientMetadata} attribute
provides the data that you assigned to the ClientMetadata parameter in
your AdminConfirmSignUp request. In your function code in Lambda, you
can process the ClientMetadata value to enhance your workflow for your
specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}
}
\description{
This IAM-authenticated API operation provides a code that Amazon Cognito sent to your user when they signed up in your user pool. After your user enters their code, they confirm ownership of the email address or phone number that they provided, and their user account becomes active. Depending on your user pool configuration, your users will receive their confirmation code in an email or SMS message.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_confirm_sign_up/} for full documentation.
}
\keyword{internal}
