% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_object_parent_paths}
\alias{clouddirectory_list_object_parent_paths}
\title{Retrieves all available parent paths for any object type such as node,
leaf node, policy node, and index node objects}
\usage{
clouddirectory_list_object_parent_paths(
  DirectoryArn,
  ObjectReference,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DirectoryArn}{[required] The ARN of the directory to which the parent path applies.}

\item{ObjectReference}{[required] The reference that identifies the object whose parent paths are listed.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of items to be retrieved in a single call. This is an
approximate number.}
}
\description{
Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html}{Directory Structure}.

See \url{https://www.paws-r-sdk.com/docs/clouddirectory_list_object_parent_paths/} for full documentation.
}
\keyword{internal}
