# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Firewall Management Service
#'
#' @description
#' This is the *Firewall Manager API Reference*. This guide is for
#' developers who need detailed information about the Firewall Manager API
#' actions, data types, and errors. For detailed information about Firewall
#' Manager features, see the [Firewall Manager Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/fms-chapter.html).
#' 
#' Some API actions require explicit resource permissions. For information,
#' see the developer guide topic [Service roles for Firewall
#' Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-security_iam_service-with-iam.html#fms-security_iam_service-with-iam-roles-service).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- fms(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- fms()
#' svc$associate_admin_account(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=fms_associate_admin_account]{associate_admin_account} \tab Sets a Firewall Manager default administrator account\cr
#'  \link[=fms_associate_third_party_firewall]{associate_third_party_firewall} \tab Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service\cr
#'  \link[=fms_batch_associate_resource]{batch_associate_resource} \tab Associate resources to a Firewall Manager resource set\cr
#'  \link[=fms_batch_disassociate_resource]{batch_disassociate_resource} \tab Disassociates resources from a Firewall Manager resource set\cr
#'  \link[=fms_delete_apps_list]{delete_apps_list} \tab Permanently deletes an Firewall Manager applications list\cr
#'  \link[=fms_delete_notification_channel]{delete_notification_channel} \tab Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs\cr
#'  \link[=fms_delete_policy]{delete_policy} \tab Permanently deletes an Firewall Manager policy\cr
#'  \link[=fms_delete_protocols_list]{delete_protocols_list} \tab Permanently deletes an Firewall Manager protocols list\cr
#'  \link[=fms_delete_resource_set]{delete_resource_set} \tab Deletes the specified ResourceSet\cr
#'  \link[=fms_disassociate_admin_account]{disassociate_admin_account} \tab Disassociates an Firewall Manager administrator account\cr
#'  \link[=fms_disassociate_third_party_firewall]{disassociate_third_party_firewall} \tab Disassociates a Firewall Manager policy administrator from a third-party firewall tenant\cr
#'  \link[=fms_get_admin_account]{get_admin_account} \tab Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager default administrator\cr
#'  \link[=fms_get_admin_scope]{get_admin_scope} \tab Returns information about the specified account's administrative scope\cr
#'  \link[=fms_get_apps_list]{get_apps_list} \tab Returns information about the specified Firewall Manager applications list\cr
#'  \link[=fms_get_compliance_detail]{get_compliance_detail} \tab Returns detailed compliance information about the specified member account\cr
#'  \link[=fms_get_notification_channel]{get_notification_channel} \tab Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs\cr
#'  \link[=fms_get_policy]{get_policy} \tab Returns information about the specified Firewall Manager policy\cr
#'  \link[=fms_get_protection_status]{get_protection_status} \tab If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack\cr
#'  \link[=fms_get_protocols_list]{get_protocols_list} \tab Returns information about the specified Firewall Manager protocols list\cr
#'  \link[=fms_get_resource_set]{get_resource_set} \tab Gets information about a specific resource set\cr
#'  \link[=fms_get_third_party_firewall_association_status]{get_third_party_firewall_association_status} \tab The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant\cr
#'  \link[=fms_get_violation_details]{get_violation_details} \tab Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account\cr
#'  \link[=fms_list_admin_accounts_for_organization]{list_admin_accounts_for_organization} \tab Returns a AdminAccounts object that lists the Firewall Manager administrators within the organization that are onboarded to Firewall Manager by AssociateAdminAccount\cr
#'  \link[=fms_list_admins_managing_account]{list_admins_managing_account} \tab Lists the accounts that are managing the specified Organizations member account\cr
#'  \link[=fms_list_apps_lists]{list_apps_lists} \tab Returns an array of AppsListDataSummary objects\cr
#'  \link[=fms_list_compliance_status]{list_compliance_status} \tab Returns an array of PolicyComplianceStatus objects\cr
#'  \link[=fms_list_discovered_resources]{list_discovered_resources} \tab Returns an array of resources in the organization's accounts that are available to be associated with a resource set\cr
#'  \link[=fms_list_member_accounts]{list_member_accounts} \tab Returns a MemberAccounts object that lists the member accounts in the administrator's Amazon Web Services organization\cr
#'  \link[=fms_list_policies]{list_policies} \tab Returns an array of PolicySummary objects\cr
#'  \link[=fms_list_protocols_lists]{list_protocols_lists} \tab Returns an array of ProtocolsListDataSummary objects\cr
#'  \link[=fms_list_resource_set_resources]{list_resource_set_resources} \tab Returns an array of resources that are currently associated to a resource set\cr
#'  \link[=fms_list_resource_sets]{list_resource_sets} \tab Returns an array of ResourceSetSummary objects\cr
#'  \link[=fms_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves the list of tags for the specified Amazon Web Services resource\cr
#'  \link[=fms_list_third_party_firewall_firewall_policies]{list_third_party_firewall_firewall_policies} \tab Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator's account\cr
#'  \link[=fms_put_admin_account]{put_admin_account} \tab Creates or updates an Firewall Manager administrator account\cr
#'  \link[=fms_put_apps_list]{put_apps_list} \tab Creates an Firewall Manager applications list\cr
#'  \link[=fms_put_notification_channel]{put_notification_channel} \tab Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs\cr
#'  \link[=fms_put_policy]{put_policy} \tab Creates an Firewall Manager policy\cr
#'  \link[=fms_put_protocols_list]{put_protocols_list} \tab Creates an Firewall Manager protocols list\cr
#'  \link[=fms_put_resource_set]{put_resource_set} \tab Creates the resource set\cr
#'  \link[=fms_tag_resource]{tag_resource} \tab Adds one or more tags to an Amazon Web Services resource\cr
#'  \link[=fms_untag_resource]{untag_resource} \tab Removes one or more tags from an Amazon Web Services resource
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname fms
#' @export
fms <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .fms$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.fms <- list()

.fms$operations <- list()

.fms$metadata <- list(
  service_name = "fms",
  endpoints = list("*" = list(endpoint = "fms.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "fms.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "fms.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "fms.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "FMS",
  api_version = "2018-01-01",
  signing_name = "fms",
  json_version = "1.1",
  target_prefix = "AWSFMS_20180101"
)

.fms$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.fms$metadata, handlers, config)
}
