% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_create_classification_job}
\alias{macie2_create_classification_job}
\title{Creates and defines the settings for a classification job}
\usage{
macie2_create_classification_job(
  allowListIds = NULL,
  clientToken,
  customDataIdentifierIds = NULL,
  description = NULL,
  initialRun = NULL,
  jobType,
  managedDataIdentifierIds = NULL,
  managedDataIdentifierSelector = NULL,
  name,
  s3JobDefinition,
  samplingPercentage = NULL,
  scheduleFrequency = NULL,
  tags = NULL
)
}
\arguments{
\item{allowListIds}{An array of unique identifiers, one for each allow list for the job to
use when it analyzes data.}

\item{clientToken}{[required] A unique, case-sensitive token that you provide to ensure the
idempotency of the request.}

\item{customDataIdentifierIds}{An array of unique identifiers, one for each custom data identifier for
the job to use when it analyzes data. To use only managed data
identifiers, don't specify a value for this property and specify a value
other than NONE for the managedDataIdentifierSelector property.}

\item{description}{A custom description of the job. The description can contain as many as
200 characters.}

\item{initialRun}{For a recurring job, specifies whether to analyze all existing, eligible
objects immediately after the job is created (true). To analyze only
those objects that are created or changed after you create the job and
before the job's first scheduled run, set this value to false.

If you configure the job to run only once, don't specify a value for
this property.}

\item{jobType}{[required] The schedule for running the job. Valid values are:
\itemize{
\item ONE_TIME - Run the job only once. If you specify this value, don't
specify a value for the scheduleFrequency property.
\item SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you
specify this value, use the scheduleFrequency property to define the
recurrence pattern for the job.
}}

\item{managedDataIdentifierIds}{An array of unique identifiers, one for each managed data identifier for
the job to include (use) or exclude (not use) when it analyzes data.
Inclusion or exclusion depends on the managed data identifier selection
type that you specify for the job (managedDataIdentifierSelector).

To retrieve a list of valid values for this property, use the
ListManagedDataIdentifiers operation.}

\item{managedDataIdentifierSelector}{The selection type to apply when determining which managed data
identifiers the job uses to analyze data. Valid values are:
\itemize{
\item ALL (default) - Use all managed data identifiers. If you specify
this value, don't specify any values for the
managedDataIdentifierIds property.
\item EXCLUDE - Use all managed data identifiers except the ones specified
by the managedDataIdentifierIds property.
\item INCLUDE - Use only the managed data identifiers specified by the
managedDataIdentifierIds property.
\item NONE - Don't use any managed data identifiers. If you specify this
value, specify at least one custom data identifier for the job
(customDataIdentifierIds) and don't specify any values for the
managedDataIdentifierIds property.
\item RECOMMENDED - Use only the set of managed data identifiers that
Amazon Web Services recommends for jobs. If you specify this value,
don't specify any values for the managedDataIdentifierIds property.
}

If you don't specify a value for this property, the job uses all managed
data identifiers.

If the job is a recurring job and you don't specify a value for this
property or you specify ALL or EXCLUDE, each job run automatically uses
new managed data identifiers that are released. If you specify
RECOMMENDED for a recurring job, each job run automatically uses all the
managed data identifiers that are in the recommended set when the job
starts to run.

For information about individual managed data identifiers or to
determine which ones are in the recommended set, see \href{https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html}{Using managed data identifiers}
and \href{https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html}{Recommended managed data identifiers}
in the \emph{Amazon Macie User Guide}.}

\item{name}{[required] A custom name for the job. The name can contain as many as 500
characters.}

\item{s3JobDefinition}{[required] The S3 buckets that contain the objects to analyze, and the scope of
that analysis.}

\item{samplingPercentage}{The sampling depth, as a percentage, for the job to apply when
processing objects. This value determines the percentage of eligible
objects that the job analyzes. If this value is less than 100, Amazon
Macie selects the objects to analyze at random, up to the specified
percentage, and analyzes all the data in those objects.}

\item{scheduleFrequency}{The recurrence pattern for running the job. To run the job only once,
don't specify a value for this property and set the value for the
jobType property to ONE_TIME.}

\item{tags}{A map of key-value pairs that specifies the tags to associate with the
job.

A job can have a maximum of 50 tags. Each tag consists of a tag key and
an associated tag value. The maximum length of a tag key is 128
characters. The maximum length of a tag value is 256 characters.}
}
\description{
Creates and defines the settings for a classification job.

See \url{https://www.paws-r-sdk.com/docs/macie2_create_classification_job/} for full documentation.
}
\keyword{internal}
