# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include inspector_service.R
NULL

#' Assigns attributes (key and value pairs) to the findings that are
#' specified by the ARNs of the findings
#'
#' @description
#' Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_add_attributes_to_findings/](https://www.paws-r-sdk.com/docs/inspector_add_attributes_to_findings/) for full documentation.
#'
#' @param findingArns &#91;required&#93; The ARNs that specify the findings that you want to assign attributes
#' to.
#' @param attributes &#91;required&#93; The array of attributes that you want to assign to specified findings.
#'
#' @keywords internal
#'
#' @rdname inspector_add_attributes_to_findings
inspector_add_attributes_to_findings <- function(findingArns, attributes) {
  op <- new_operation(
    name = "AddAttributesToFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$add_attributes_to_findings_input(findingArns = findingArns, attributes = attributes)
  output <- .inspector$add_attributes_to_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$add_attributes_to_findings <- inspector_add_attributes_to_findings

#' Creates a new assessment target using the ARN of the resource group that
#' is generated by CreateResourceGroup
#'
#' @description
#' Creates a new assessment target using the ARN of the resource group that is generated by [`create_resource_group`][inspector_create_resource_group]. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/v1/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see [Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/v1/userguide/inspector_applications.html).
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_create_assessment_target/](https://www.paws-r-sdk.com/docs/inspector_create_assessment_target/) for full documentation.
#'
#' @param assessmentTargetName &#91;required&#93; The user-defined name that identifies the assessment target that you
#' want to create. The name must be unique within the AWS account.
#' @param resourceGroupArn The ARN that specifies the resource group that is used to create the
#' assessment target. If resourceGroupArn is not specified, all EC2
#' instances in the current AWS account and region are included in the
#' assessment target.
#'
#' @keywords internal
#'
#' @rdname inspector_create_assessment_target
inspector_create_assessment_target <- function(assessmentTargetName, resourceGroupArn = NULL) {
  op <- new_operation(
    name = "CreateAssessmentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_assessment_target_input(assessmentTargetName = assessmentTargetName, resourceGroupArn = resourceGroupArn)
  output <- .inspector$create_assessment_target_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_assessment_target <- inspector_create_assessment_target

#' Creates an assessment template for the assessment target that is
#' specified by the ARN of the assessment target
#'
#' @description
#' Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/v1/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_create_assessment_template/](https://www.paws-r-sdk.com/docs/inspector_create_assessment_template/) for full documentation.
#'
#' @param assessmentTargetArn &#91;required&#93; The ARN that specifies the assessment target for which you want to
#' create the assessment template.
#' @param assessmentTemplateName &#91;required&#93; The user-defined name that identifies the assessment template that you
#' want to create. You can create several assessment templates for an
#' assessment target. The names of the assessment templates that correspond
#' to a particular assessment target must be unique.
#' @param durationInSeconds &#91;required&#93; The duration of the assessment run in seconds.
#' @param rulesPackageArns &#91;required&#93; The ARNs that specify the rules packages that you want to attach to the
#' assessment template.
#' @param userAttributesForFindings The user-defined attributes that are assigned to every finding that is
#' generated by the assessment run that uses this assessment template. An
#' attribute is a key and value pair (an Attribute object). Within an
#' assessment template, each key must be unique.
#'
#' @keywords internal
#'
#' @rdname inspector_create_assessment_template
inspector_create_assessment_template <- function(assessmentTargetArn, assessmentTemplateName, durationInSeconds, rulesPackageArns, userAttributesForFindings = NULL) {
  op <- new_operation(
    name = "CreateAssessmentTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_assessment_template_input(assessmentTargetArn = assessmentTargetArn, assessmentTemplateName = assessmentTemplateName, durationInSeconds = durationInSeconds, rulesPackageArns = rulesPackageArns, userAttributesForFindings = userAttributesForFindings)
  output <- .inspector$create_assessment_template_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_assessment_template <- inspector_create_assessment_template

#' Starts the generation of an exclusions preview for the specified
#' assessment template
#'
#' @description
#' Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_create_exclusions_preview/](https://www.paws-r-sdk.com/docs/inspector_create_exclusions_preview/) for full documentation.
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN that specifies the assessment template for which you want to
#' create an exclusions preview.
#'
#' @keywords internal
#'
#' @rdname inspector_create_exclusions_preview
inspector_create_exclusions_preview <- function(assessmentTemplateArn) {
  op <- new_operation(
    name = "CreateExclusionsPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_exclusions_preview_input(assessmentTemplateArn = assessmentTemplateArn)
  output <- .inspector$create_exclusions_preview_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_exclusions_preview <- inspector_create_exclusions_preview

#' Creates a resource group using the specified set of tags (key and value
#' pairs) that are used to select the EC2 instances to be included in an
#' Amazon Inspector assessment target
#'
#' @description
#' Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see [`create_assessment_target`][inspector_create_assessment_target].
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_create_resource_group/](https://www.paws-r-sdk.com/docs/inspector_create_resource_group/) for full documentation.
#'
#' @param resourceGroupTags &#91;required&#93; A collection of keys and an array of possible values,
#' '\[\{"key":"key1","values":\["Value1","Value2"\]\},\{"key":"Key2","values":\["Value3"\]\}\]'.
#' 
#' For example,'\[\{"key":"Name","values":\["TestEC2Instance"\]\}\]'.
#'
#' @keywords internal
#'
#' @rdname inspector_create_resource_group
inspector_create_resource_group <- function(resourceGroupTags) {
  op <- new_operation(
    name = "CreateResourceGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_resource_group_input(resourceGroupTags = resourceGroupTags)
  output <- .inspector$create_resource_group_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_resource_group <- inspector_create_resource_group

#' Deletes the assessment run that is specified by the ARN of the
#' assessment run
#'
#' @description
#' Deletes the assessment run that is specified by the ARN of the assessment run.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_delete_assessment_run/](https://www.paws-r-sdk.com/docs/inspector_delete_assessment_run/) for full documentation.
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run that you want to delete.
#'
#' @keywords internal
#'
#' @rdname inspector_delete_assessment_run
inspector_delete_assessment_run <- function(assessmentRunArn) {
  op <- new_operation(
    name = "DeleteAssessmentRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$delete_assessment_run_input(assessmentRunArn = assessmentRunArn)
  output <- .inspector$delete_assessment_run_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$delete_assessment_run <- inspector_delete_assessment_run

#' Deletes the assessment target that is specified by the ARN of the
#' assessment target
#'
#' @description
#' Deletes the assessment target that is specified by the ARN of the assessment target.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_delete_assessment_target/](https://www.paws-r-sdk.com/docs/inspector_delete_assessment_target/) for full documentation.
#'
#' @param assessmentTargetArn &#91;required&#93; The ARN that specifies the assessment target that you want to delete.
#'
#' @keywords internal
#'
#' @rdname inspector_delete_assessment_target
inspector_delete_assessment_target <- function(assessmentTargetArn) {
  op <- new_operation(
    name = "DeleteAssessmentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$delete_assessment_target_input(assessmentTargetArn = assessmentTargetArn)
  output <- .inspector$delete_assessment_target_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$delete_assessment_target <- inspector_delete_assessment_target

#' Deletes the assessment template that is specified by the ARN of the
#' assessment template
#'
#' @description
#' Deletes the assessment template that is specified by the ARN of the assessment template.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_delete_assessment_template/](https://www.paws-r-sdk.com/docs/inspector_delete_assessment_template/) for full documentation.
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN that specifies the assessment template that you want to delete.
#'
#' @keywords internal
#'
#' @rdname inspector_delete_assessment_template
inspector_delete_assessment_template <- function(assessmentTemplateArn) {
  op <- new_operation(
    name = "DeleteAssessmentTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$delete_assessment_template_input(assessmentTemplateArn = assessmentTemplateArn)
  output <- .inspector$delete_assessment_template_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$delete_assessment_template <- inspector_delete_assessment_template

#' Describes the assessment runs that are specified by the ARNs of the
#' assessment runs
#'
#' @description
#' Describes the assessment runs that are specified by the ARNs of the assessment runs.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_assessment_runs/](https://www.paws-r-sdk.com/docs/inspector_describe_assessment_runs/) for full documentation.
#'
#' @param assessmentRunArns &#91;required&#93; The ARN that specifies the assessment run that you want to describe.
#'
#' @keywords internal
#'
#' @rdname inspector_describe_assessment_runs
inspector_describe_assessment_runs <- function(assessmentRunArns) {
  op <- new_operation(
    name = "DescribeAssessmentRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_assessment_runs_input(assessmentRunArns = assessmentRunArns)
  output <- .inspector$describe_assessment_runs_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_assessment_runs <- inspector_describe_assessment_runs

#' Describes the assessment targets that are specified by the ARNs of the
#' assessment targets
#'
#' @description
#' Describes the assessment targets that are specified by the ARNs of the assessment targets.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_assessment_targets/](https://www.paws-r-sdk.com/docs/inspector_describe_assessment_targets/) for full documentation.
#'
#' @param assessmentTargetArns &#91;required&#93; The ARNs that specifies the assessment targets that you want to
#' describe.
#'
#' @keywords internal
#'
#' @rdname inspector_describe_assessment_targets
inspector_describe_assessment_targets <- function(assessmentTargetArns) {
  op <- new_operation(
    name = "DescribeAssessmentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_assessment_targets_input(assessmentTargetArns = assessmentTargetArns)
  output <- .inspector$describe_assessment_targets_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_assessment_targets <- inspector_describe_assessment_targets

#' Describes the assessment templates that are specified by the ARNs of the
#' assessment templates
#'
#' @description
#' Describes the assessment templates that are specified by the ARNs of the assessment templates.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_assessment_templates/](https://www.paws-r-sdk.com/docs/inspector_describe_assessment_templates/) for full documentation.
#'
#' @param assessmentTemplateArns &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname inspector_describe_assessment_templates
inspector_describe_assessment_templates <- function(assessmentTemplateArns) {
  op <- new_operation(
    name = "DescribeAssessmentTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_assessment_templates_input(assessmentTemplateArns = assessmentTemplateArns)
  output <- .inspector$describe_assessment_templates_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_assessment_templates <- inspector_describe_assessment_templates

#' Describes the IAM role that enables Amazon Inspector to access your AWS
#' account
#'
#' @description
#' Describes the IAM role that enables Amazon Inspector to access your AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_cross_account_access_role/](https://www.paws-r-sdk.com/docs/inspector_describe_cross_account_access_role/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname inspector_describe_cross_account_access_role
inspector_describe_cross_account_access_role <- function() {
  op <- new_operation(
    name = "DescribeCrossAccountAccessRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_cross_account_access_role_input()
  output <- .inspector$describe_cross_account_access_role_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_cross_account_access_role <- inspector_describe_cross_account_access_role

#' Describes the exclusions that are specified by the exclusions' ARNs
#'
#' @description
#' Describes the exclusions that are specified by the exclusions' ARNs.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_exclusions/](https://www.paws-r-sdk.com/docs/inspector_describe_exclusions/) for full documentation.
#'
#' @param exclusionArns &#91;required&#93; The list of ARNs that specify the exclusions that you want to describe.
#' @param locale The locale into which you want to translate the exclusion's title,
#' description, and recommendation.
#'
#' @keywords internal
#'
#' @rdname inspector_describe_exclusions
inspector_describe_exclusions <- function(exclusionArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeExclusions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_exclusions_input(exclusionArns = exclusionArns, locale = locale)
  output <- .inspector$describe_exclusions_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_exclusions <- inspector_describe_exclusions

#' Describes the findings that are specified by the ARNs of the findings
#'
#' @description
#' Describes the findings that are specified by the ARNs of the findings.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_findings/](https://www.paws-r-sdk.com/docs/inspector_describe_findings/) for full documentation.
#'
#' @param findingArns &#91;required&#93; The ARN that specifies the finding that you want to describe.
#' @param locale The locale into which you want to translate a finding description,
#' recommendation, and the short description that identifies the finding.
#'
#' @keywords internal
#'
#' @rdname inspector_describe_findings
inspector_describe_findings <- function(findingArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_findings_input(findingArns = findingArns, locale = locale)
  output <- .inspector$describe_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_findings <- inspector_describe_findings

#' Describes the resource groups that are specified by the ARNs of the
#' resource groups
#'
#' @description
#' Describes the resource groups that are specified by the ARNs of the resource groups.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_resource_groups/](https://www.paws-r-sdk.com/docs/inspector_describe_resource_groups/) for full documentation.
#'
#' @param resourceGroupArns &#91;required&#93; The ARN that specifies the resource group that you want to describe.
#'
#' @keywords internal
#'
#' @rdname inspector_describe_resource_groups
inspector_describe_resource_groups <- function(resourceGroupArns) {
  op <- new_operation(
    name = "DescribeResourceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_resource_groups_input(resourceGroupArns = resourceGroupArns)
  output <- .inspector$describe_resource_groups_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_resource_groups <- inspector_describe_resource_groups

#' Describes the rules packages that are specified by the ARNs of the rules
#' packages
#'
#' @description
#' Describes the rules packages that are specified by the ARNs of the rules packages.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_describe_rules_packages/](https://www.paws-r-sdk.com/docs/inspector_describe_rules_packages/) for full documentation.
#'
#' @param rulesPackageArns &#91;required&#93; The ARN that specifies the rules package that you want to describe.
#' @param locale The locale that you want to translate a rules package description into.
#'
#' @keywords internal
#'
#' @rdname inspector_describe_rules_packages
inspector_describe_rules_packages <- function(rulesPackageArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeRulesPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_rules_packages_input(rulesPackageArns = rulesPackageArns, locale = locale)
  output <- .inspector$describe_rules_packages_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_rules_packages <- inspector_describe_rules_packages

#' Produces an assessment report that includes detailed and comprehensive
#' results of a specified assessment run
#'
#' @description
#' Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_get_assessment_report/](https://www.paws-r-sdk.com/docs/inspector_get_assessment_report/) for full documentation.
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run for which you want to generate
#' a report.
#' @param reportFileFormat &#91;required&#93; Specifies the file format (html or pdf) of the assessment report that
#' you want to generate.
#' @param reportType &#91;required&#93; Specifies the type of the assessment report that you want to generate.
#' There are two types of assessment reports: a finding report and a full
#' report. For more information, see [Assessment
#' Reports](https://docs.aws.amazon.com/inspector/v1/userguide/inspector_reports.html).
#'
#' @keywords internal
#'
#' @rdname inspector_get_assessment_report
inspector_get_assessment_report <- function(assessmentRunArn, reportFileFormat, reportType) {
  op <- new_operation(
    name = "GetAssessmentReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$get_assessment_report_input(assessmentRunArn = assessmentRunArn, reportFileFormat = reportFileFormat, reportType = reportType)
  output <- .inspector$get_assessment_report_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$get_assessment_report <- inspector_get_assessment_report

#' Retrieves the exclusions preview (a list of ExclusionPreview objects)
#' specified by the preview token
#'
#' @description
#' Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_get_exclusions_preview/](https://www.paws-r-sdk.com/docs/inspector_get_exclusions_preview/) for full documentation.
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN that specifies the assessment template for which the exclusions
#' preview was requested.
#' @param previewToken &#91;required&#93; The unique identifier associated of the exclusions preview.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' GetExclusionsPreviewRequest action. Subsequent calls to the action fill
#' nextToken in the request with the value of nextToken from the previous
#' response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 100. The maximum value is
#' 500.
#' @param locale The locale into which you want to translate the exclusion's title,
#' description, and recommendation.
#'
#' @keywords internal
#'
#' @rdname inspector_get_exclusions_preview
inspector_get_exclusions_preview <- function(assessmentTemplateArn, previewToken, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "GetExclusionsPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$get_exclusions_preview_input(assessmentTemplateArn = assessmentTemplateArn, previewToken = previewToken, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .inspector$get_exclusions_preview_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$get_exclusions_preview <- inspector_get_exclusions_preview

#' Information about the data that is collected for the specified
#' assessment run
#'
#' @description
#' Information about the data that is collected for the specified assessment run.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_get_telemetry_metadata/](https://www.paws-r-sdk.com/docs/inspector_get_telemetry_metadata/) for full documentation.
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run that has the telemetry data
#' that you want to obtain.
#'
#' @keywords internal
#'
#' @rdname inspector_get_telemetry_metadata
inspector_get_telemetry_metadata <- function(assessmentRunArn) {
  op <- new_operation(
    name = "GetTelemetryMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$get_telemetry_metadata_input(assessmentRunArn = assessmentRunArn)
  output <- .inspector$get_telemetry_metadata_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$get_telemetry_metadata <- inspector_get_telemetry_metadata

#' Lists the agents of the assessment runs that are specified by the ARNs
#' of the assessment runs
#'
#' @description
#' Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_assessment_run_agents/](https://www.paws-r-sdk.com/docs/inspector_list_assessment_run_agents/) for full documentation.
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run whose agents you want to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListAssessmentRunAgents** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 10. The maximum value is
#' 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_run_agents
inspector_list_assessment_run_agents <- function(assessmentRunArn, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentRunAgents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_assessment_run_agents_input(assessmentRunArn = assessmentRunArn, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_run_agents_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_run_agents <- inspector_list_assessment_run_agents

#' Lists the assessment runs that correspond to the assessment templates
#' that are specified by the ARNs of the assessment templates
#'
#' @description
#' Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_assessment_runs/](https://www.paws-r-sdk.com/docs/inspector_list_assessment_runs/) for full documentation.
#'
#' @param assessmentTemplateArns The ARNs that specify the assessment templates whose assessment runs you
#' want to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **ListAssessmentRuns**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 10. The maximum value is
#' 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_runs
inspector_list_assessment_runs <- function(assessmentTemplateArns = NULL, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_assessment_runs_input(assessmentTemplateArns = assessmentTemplateArns, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_runs_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_runs <- inspector_list_assessment_runs

#' Lists the ARNs of the assessment targets within this AWS account
#'
#' @description
#' Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see [Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/v1/userguide/inspector_applications.html).
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_assessment_targets/](https://www.paws-r-sdk.com/docs/inspector_list_assessment_targets/) for full documentation.
#'
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListAssessmentTargets** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_targets
inspector_list_assessment_targets <- function(filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_assessment_targets_input(filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_targets_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_targets <- inspector_list_assessment_targets

#' Lists the assessment templates that correspond to the assessment targets
#' that are specified by the ARNs of the assessment targets
#'
#' @description
#' Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_assessment_templates/](https://www.paws-r-sdk.com/docs/inspector_list_assessment_templates/) for full documentation.
#'
#' @param assessmentTargetArns A list of ARNs that specifies the assessment targets whose assessment
#' templates you want to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListAssessmentTemplates** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_templates
inspector_list_assessment_templates <- function(assessmentTargetArns = NULL, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_assessment_templates_input(assessmentTargetArns = assessmentTargetArns, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_templates_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_templates <- inspector_list_assessment_templates

#' Lists all the event subscriptions for the assessment template that is
#' specified by the ARN of the assessment template
#'
#' @description
#' Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see [`subscribe_to_event`][inspector_subscribe_to_event] and [`unsubscribe_from_event`][inspector_unsubscribe_from_event].
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_event_subscriptions/](https://www.paws-r-sdk.com/docs/inspector_list_event_subscriptions/) for full documentation.
#'
#' @param resourceArn The ARN of the assessment template for which you want to list the
#' existing event subscriptions.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListEventSubscriptions** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_event_subscriptions
inspector_list_event_subscriptions <- function(resourceArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_event_subscriptions_input(resourceArn = resourceArn, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_event_subscriptions_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_event_subscriptions <- inspector_list_event_subscriptions

#' List exclusions that are generated by the assessment run
#'
#' @description
#' List exclusions that are generated by the assessment run.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_exclusions/](https://www.paws-r-sdk.com/docs/inspector_list_exclusions/) for full documentation.
#'
#' @param assessmentRunArn &#91;required&#93; The ARN of the assessment run that generated the exclusions that you
#' want to list.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the ListExclusionsRequest
#' action. Subsequent calls to the action fill nextToken in the request
#' with the value of nextToken from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 100. The maximum value is
#' 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_exclusions
inspector_list_exclusions <- function(assessmentRunArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListExclusions",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_exclusions_input(assessmentRunArn = assessmentRunArn, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_exclusions_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_exclusions <- inspector_list_exclusions

#' Lists findings that are generated by the assessment runs that are
#' specified by the ARNs of the assessment runs
#'
#' @description
#' Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_findings/](https://www.paws-r-sdk.com/docs/inspector_list_findings/) for full documentation.
#'
#' @param assessmentRunArns The ARNs of the assessment runs that generate the findings that you want
#' to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **ListFindings**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_findings
inspector_list_findings <- function(assessmentRunArns = NULL, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_findings_input(assessmentRunArns = assessmentRunArns, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_findings <- inspector_list_findings

#' Lists all available Amazon Inspector rules packages
#'
#' @description
#' Lists all available Amazon Inspector rules packages.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_rules_packages/](https://www.paws-r-sdk.com/docs/inspector_list_rules_packages/) for full documentation.
#'
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **ListRulesPackages**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname inspector_list_rules_packages
inspector_list_rules_packages <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRulesPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$list_rules_packages_input(nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_rules_packages_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_rules_packages <- inspector_list_rules_packages

#' Lists all tags associated with an assessment template
#'
#' @description
#' Lists all tags associated with an assessment template.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/inspector_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN that specifies the assessment template whose tags you want to
#' list.
#'
#' @keywords internal
#'
#' @rdname inspector_list_tags_for_resource
inspector_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .inspector$list_tags_for_resource_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_tags_for_resource <- inspector_list_tags_for_resource

#' Previews the agents installed on the EC2 instances that are part of the
#' specified assessment target
#'
#' @description
#' Previews the agents installed on the EC2 instances that are part of the specified assessment target.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_preview_agents/](https://www.paws-r-sdk.com/docs/inspector_preview_agents/) for full documentation.
#'
#' @param previewAgentsArn &#91;required&#93; The ARN of the assessment target whose agents you want to preview.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **PreviewAgents**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @keywords internal
#'
#' @rdname inspector_preview_agents
inspector_preview_agents <- function(previewAgentsArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "PreviewAgents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .inspector$preview_agents_input(previewAgentsArn = previewAgentsArn, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$preview_agents_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$preview_agents <- inspector_preview_agents

#' Registers the IAM role that grants Amazon Inspector access to AWS
#' Services needed to perform security assessments
#'
#' @description
#' Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_register_cross_account_access_role/](https://www.paws-r-sdk.com/docs/inspector_register_cross_account_access_role/) for full documentation.
#'
#' @param roleArn &#91;required&#93; The ARN of the IAM role that grants Amazon Inspector access to AWS
#' Services needed to perform security assessments.
#'
#' @keywords internal
#'
#' @rdname inspector_register_cross_account_access_role
inspector_register_cross_account_access_role <- function(roleArn) {
  op <- new_operation(
    name = "RegisterCrossAccountAccessRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$register_cross_account_access_role_input(roleArn = roleArn)
  output <- .inspector$register_cross_account_access_role_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$register_cross_account_access_role <- inspector_register_cross_account_access_role

#' Removes entire attributes (key and value pairs) from the findings that
#' are specified by the ARNs of the findings where an attribute with the
#' specified key exists
#'
#' @description
#' Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_remove_attributes_from_findings/](https://www.paws-r-sdk.com/docs/inspector_remove_attributes_from_findings/) for full documentation.
#'
#' @param findingArns &#91;required&#93; The ARNs that specify the findings that you want to remove attributes
#' from.
#' @param attributeKeys &#91;required&#93; The array of attribute keys that you want to remove from specified
#' findings.
#'
#' @keywords internal
#'
#' @rdname inspector_remove_attributes_from_findings
inspector_remove_attributes_from_findings <- function(findingArns, attributeKeys) {
  op <- new_operation(
    name = "RemoveAttributesFromFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$remove_attributes_from_findings_input(findingArns = findingArns, attributeKeys = attributeKeys)
  output <- .inspector$remove_attributes_from_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$remove_attributes_from_findings <- inspector_remove_attributes_from_findings

#' Sets tags (key and value pairs) to the assessment template that is
#' specified by the ARN of the assessment template
#'
#' @description
#' Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_set_tags_for_resource/](https://www.paws-r-sdk.com/docs/inspector_set_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the assessment template that you want to set tags to.
#' @param tags A collection of key and value pairs that you want to set to the
#' assessment template.
#'
#' @keywords internal
#'
#' @rdname inspector_set_tags_for_resource
inspector_set_tags_for_resource <- function(resourceArn, tags = NULL) {
  op <- new_operation(
    name = "SetTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$set_tags_for_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .inspector$set_tags_for_resource_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$set_tags_for_resource <- inspector_set_tags_for_resource

#' Starts the assessment run specified by the ARN of the assessment
#' template
#'
#' @description
#' Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_start_assessment_run/](https://www.paws-r-sdk.com/docs/inspector_start_assessment_run/) for full documentation.
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN of the assessment template of the assessment run that you want
#' to start.
#' @param assessmentRunName You can specify the name for the assessment run. The name must be unique
#' for the assessment template whose ARN is used to start the assessment
#' run.
#'
#' @keywords internal
#'
#' @rdname inspector_start_assessment_run
inspector_start_assessment_run <- function(assessmentTemplateArn, assessmentRunName = NULL) {
  op <- new_operation(
    name = "StartAssessmentRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$start_assessment_run_input(assessmentTemplateArn = assessmentTemplateArn, assessmentRunName = assessmentRunName)
  output <- .inspector$start_assessment_run_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$start_assessment_run <- inspector_start_assessment_run

#' Stops the assessment run that is specified by the ARN of the assessment
#' run
#'
#' @description
#' Stops the assessment run that is specified by the ARN of the assessment run.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_stop_assessment_run/](https://www.paws-r-sdk.com/docs/inspector_stop_assessment_run/) for full documentation.
#'
#' @param assessmentRunArn &#91;required&#93; The ARN of the assessment run that you want to stop.
#' @param stopAction An input option that can be set to either START_EVALUATION or
#' SKIP_EVALUATION. START_EVALUATION (the default value), stops the AWS
#' agent from collecting data and begins the results evaluation and the
#' findings generation process. SKIP_EVALUATION cancels the assessment run
#' immediately, after which no findings are generated.
#'
#' @keywords internal
#'
#' @rdname inspector_stop_assessment_run
inspector_stop_assessment_run <- function(assessmentRunArn, stopAction = NULL) {
  op <- new_operation(
    name = "StopAssessmentRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$stop_assessment_run_input(assessmentRunArn = assessmentRunArn, stopAction = stopAction)
  output <- .inspector$stop_assessment_run_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$stop_assessment_run <- inspector_stop_assessment_run

#' Enables the process of sending Amazon Simple Notification Service (SNS)
#' notifications about a specified event to a specified SNS topic
#'
#' @description
#' Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_subscribe_to_event/](https://www.paws-r-sdk.com/docs/inspector_subscribe_to_event/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the assessment template that is used during the event for
#' which you want to receive SNS notifications.
#' @param event &#91;required&#93; The event for which you want to receive SNS notifications.
#' @param topicArn &#91;required&#93; The ARN of the SNS topic to which the SNS notifications are sent.
#'
#' @keywords internal
#'
#' @rdname inspector_subscribe_to_event
inspector_subscribe_to_event <- function(resourceArn, event, topicArn) {
  op <- new_operation(
    name = "SubscribeToEvent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$subscribe_to_event_input(resourceArn = resourceArn, event = event, topicArn = topicArn)
  output <- .inspector$subscribe_to_event_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$subscribe_to_event <- inspector_subscribe_to_event

#' Disables the process of sending Amazon Simple Notification Service (SNS)
#' notifications about a specified event to a specified SNS topic
#'
#' @description
#' Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_unsubscribe_from_event/](https://www.paws-r-sdk.com/docs/inspector_unsubscribe_from_event/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the assessment template that is used during the event for
#' which you want to stop receiving SNS notifications.
#' @param event &#91;required&#93; The event for which you want to stop receiving SNS notifications.
#' @param topicArn &#91;required&#93; The ARN of the SNS topic to which SNS notifications are sent.
#'
#' @keywords internal
#'
#' @rdname inspector_unsubscribe_from_event
inspector_unsubscribe_from_event <- function(resourceArn, event, topicArn) {
  op <- new_operation(
    name = "UnsubscribeFromEvent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$unsubscribe_from_event_input(resourceArn = resourceArn, event = event, topicArn = topicArn)
  output <- .inspector$unsubscribe_from_event_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$unsubscribe_from_event <- inspector_unsubscribe_from_event

#' Updates the assessment target that is specified by the ARN of the
#' assessment target
#'
#' @description
#' Updates the assessment target that is specified by the ARN of the assessment target.
#'
#' See [https://www.paws-r-sdk.com/docs/inspector_update_assessment_target/](https://www.paws-r-sdk.com/docs/inspector_update_assessment_target/) for full documentation.
#'
#' @param assessmentTargetArn &#91;required&#93; The ARN of the assessment target that you want to update.
#' @param assessmentTargetName &#91;required&#93; The name of the assessment target that you want to update.
#' @param resourceGroupArn The ARN of the resource group that is used to specify the new resource
#' group to associate with the assessment target.
#'
#' @keywords internal
#'
#' @rdname inspector_update_assessment_target
inspector_update_assessment_target <- function(assessmentTargetArn, assessmentTargetName, resourceGroupArn = NULL) {
  op <- new_operation(
    name = "UpdateAssessmentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$update_assessment_target_input(assessmentTargetArn = assessmentTargetArn, assessmentTargetName = assessmentTargetName, resourceGroupArn = resourceGroupArn)
  output <- .inspector$update_assessment_target_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$update_assessment_target <- inspector_update_assessment_target
