% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_create_rate_based_rule}
\alias{waf_create_rate_based_rule}
\title{This is AWS WAF Classic documentation}
\usage{
waf_create_rate_based_rule(
  Name,
  MetricName,
  RateKey,
  RateLimit,
  ChangeToken,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] A friendly name or description of the RateBasedRule. You can't change
the name of a \code{RateBasedRule} after you create it.}

\item{MetricName}{[required] A friendly name or description for the metrics for this \code{RateBasedRule}.
The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
maximum length 128 and minimum length one. It can't contain whitespace
or metric names reserved for AWS WAF, including "All" and
"Default_Action." You can't change the name of the metric after you
create the \code{RateBasedRule}.}

\item{RateKey}{[required] The field that AWS WAF uses to determine if requests are likely arriving
from a single source and thus subject to rate monitoring. The only valid
value for \code{RateKey} is \code{IP}. \code{IP} indicates that requests that arrive
from the same IP address are subject to the \code{RateLimit} that is
specified in the \code{RateBasedRule}.}

\item{RateLimit}{[required] The maximum number of requests, which have an identical value in the
field that is specified by \code{RateKey}, allowed in a five-minute period.
If the number of requests exceeds the \code{RateLimit} and the other
predicates specified in the rule are also met, AWS WAF triggers the
action that is specified for this rule.}

\item{ChangeToken}{[required] The \code{ChangeToken} that you used to submit the
\code{\link[=waf_create_rate_based_rule]{create_rate_based_rule}} request. You can
also use this value to query the status of the request. For more
information, see
\code{\link[=waf_get_change_token_status]{get_change_token_status}}.}

\item{Tags}{}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic} in the developer guide.

See \url{https://www.paws-r-sdk.com/docs/waf_create_rate_based_rule/} for full documentation.
}
\keyword{internal}
