# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Single Sign-On
#'
#' @description
#' AWS IAM Identity Center (successor to AWS Single Sign-On) Portal is a
#' web service that makes it easy for you to assign user access to IAM
#' Identity Center resources such as the AWS access portal. Users can get
#' AWS account applications and roles assigned to them and get federated
#' into the application.
#' 
#' Although AWS Single Sign-On was renamed, the `sso` and `identitystore`
#' API namespaces will continue to retain their original name for backward
#' compatibility purposes. For more information, see [IAM Identity Center
#' rename](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed).
#' 
#' This reference guide describes the IAM Identity Center Portal operations
#' that you can call programatically and includes detailed information on
#' data types and errors.
#' 
#' AWS provides SDKs that consist of libraries and sample code for various
#' programming languages and platforms, such as Java, Ruby, .Net, iOS, or
#' Android. The SDKs provide a convenient way to create programmatic access
#' to IAM Identity Center and other AWS services. For more information
#' about the AWS SDKs, including how to download and install them, see
#' [Tools for Amazon Web
#' Services](https://aws.amazon.com/developer/tools/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- sso(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- sso()
#' svc$get_role_credentials(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sso_get_role_credentials]{get_role_credentials} \tab Returns the STS short-term credentials for a given role name that is assigned to the user\cr
#'  \link[=sso_list_account_roles]{list_account_roles} \tab Lists all roles that are assigned to the user for a given AWS account\cr
#'  \link[=sso_list_accounts]{list_accounts} \tab Lists all AWS accounts assigned to the user\cr
#'  \link[=sso_logout]{logout} \tab Removes the locally stored SSO tokens from the client-side cache and sends an API call to the IAM Identity Center service to invalidate the corresponding server-side IAM Identity Center sign in session
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname sso
#' @export
sso <- function(config = list()) {
  svc <- .sso$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.sso <- list()

.sso$operations <- list()

.sso$metadata <- list(
  service_name = "sso",
  endpoints = list("*" = list(endpoint = "portal.sso.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "portal.sso.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "portal.sso.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "portal.sso.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "SSO",
  api_version = "2019-06-10",
  signing_name = "awsssoportal",
  json_version = "1.1",
  target_prefix = ""
)

.sso$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.sso$metadata, handlers, config)
}
