% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssooidc_operations.R
\name{ssooidc_start_device_authorization}
\alias{ssooidc_start_device_authorization}
\title{Initiates device authorization by requesting a pair of verification
codes from the authorization service}
\usage{
ssooidc_start_device_authorization(clientId, clientSecret, startUrl)
}
\arguments{
\item{clientId}{[required] The unique identifier string for the client that is registered with
Amazon Web Services SSO. This value should come from the persisted
result of the \code{\link[=ssooidc_register_client]{register_client}} API
operation.}

\item{clientSecret}{[required] A secret string that is generated for the client. This value should come
from the persisted result of the
\code{\link[=ssooidc_register_client]{register_client}} API operation.}

\item{startUrl}{[required] The URL for the AWS access portal. For more information, see \href{https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html}{Using the AWS access portal}
in the \emph{Amazon Web Services SSO User Guide}.}
}
\description{
Initiates device authorization by requesting a pair of verification codes from the authorization service.

See \url{https://paws-r.github.io/docs/ssooidc/start_device_authorization.html} for full documentation.
}
\keyword{internal}
