% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_custom_key_store}
\alias{kms_create_custom_key_store}
\title{Creates a custom key store that is associated with an CloudHSM cluster
that you own and manage}
\usage{
kms_create_custom_key_store(
  CustomKeyStoreName,
  CloudHsmClusterId = NULL,
  TrustAnchorCertificate = NULL,
  KeyStorePassword = NULL
)
}
\arguments{
\item{CustomKeyStoreName}{[required] Specifies a friendly name for the custom key store. The name must be
unique in your Amazon Web Services account.}

\item{CloudHsmClusterId}{Identifies the CloudHSM cluster for the custom key store. Enter the
cluster ID of any active CloudHSM cluster that is not already associated
with a custom key store. To find the cluster ID, use the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html}{DescribeClusters}
operation.}

\item{TrustAnchorCertificate}{Enter the content of the trust anchor certificate for the cluster. This
is the content of the \code{customerCA.crt} file that you created when you
\href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html}{initialized the cluster}.}

\item{KeyStorePassword}{Enter the password of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/#concept-kmsuser}{\code{kmsuser} crypto user (CU) account}
in the specified CloudHSM cluster. KMS logs into the cluster as this
user to manage key material on your behalf.

The password must be a string of 7 to 32 characters. Its value is case
sensitive.

This parameter tells KMS the \code{kmsuser} account password; it does not
change the password in the CloudHSM cluster.}
}
\description{
Creates a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store} that is associated with an \href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html}{CloudHSM cluster} that you own and manage.

See \url{https://paws-r.github.io/docs/kms/create_custom_key_store.html} for full documentation.
}
\keyword{internal}
