% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_threat_intel_set}
\alias{guardduty_create_threat_intel_set}
\title{Creates a new ThreatIntelSet}
\usage{
guardduty_create_threat_intel_set(
  DetectorId,
  Name,
  Format,
  Location,
  Activate,
  ClientToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account that you want to
create a threatIntelSet for.}

\item{Name}{[required] A user-friendly ThreatIntelSet name displayed in all findings that are
generated by activity that involves IP addresses included in this
ThreatIntelSet.}

\item{Format}{[required] The format of the file that contains the ThreatIntelSet.}

\item{Location}{[required] The URI of the file that contains the ThreatIntelSet.}

\item{Activate}{[required] A Boolean value that indicates whether GuardDuty is to start using the
uploaded ThreatIntelSet.}

\item{ClientToken}{The idempotency token for the create request.}

\item{Tags}{The tags to be added to a new threat list resource.}
}
\description{
Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator account can use this operation.

See \url{https://paws-r.github.io/docs/guardduty/create_threat_intel_set.html} for full documentation.
}
\keyword{internal}
