% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_create_finding_aggregator}
\alias{securityhub_create_finding_aggregator}
\title{Used to enable finding aggregation}
\usage{
securityhub_create_finding_aggregator(RegionLinkingMode, Regions = NULL)
}
\arguments{
\item{RegionLinkingMode}{[required] Indicates whether to aggregate findings from all of the available
Regions in the current partition. Also determines whether to
automatically aggregate findings from new Regions as Security Hub
supports them and you opt into them.

The selected option also determines how to use the Regions provided in
the Regions list.

The options are as follows:
\itemize{
\item \code{ALL_REGIONS} - Indicates to aggregate findings from all of the
Regions where Security Hub is enabled. When you choose this option,
Security Hub also automatically aggregates findings from new Regions
as Security Hub supports them and you opt into them.
\item \code{ALL_REGIONS_EXCEPT_SPECIFIED} - Indicates to aggregate findings
from all of the Regions where Security Hub is enabled, except for
the Regions listed in the \code{Regions} parameter. When you choose this
option, Security Hub also automatically aggregates findings from new
Regions as Security Hub supports them and you opt into them.
\item \code{SPECIFIED_REGIONS} - Indicates to aggregate findings only from the
Regions listed in the \code{Regions} parameter. Security Hub does not
automatically aggregate findings from new Regions.
}}

\item{Regions}{If \code{RegionLinkingMode} is \code{ALL_REGIONS_EXCEPT_SPECIFIED}, then this is a
comma-separated list of Regions that do not aggregate findings to the
aggregation Region.

If \code{RegionLinkingMode} is \code{SPECIFIED_REGIONS}, then this is a
comma-separated list of Regions that do aggregate findings to the
aggregation Region.}
}
\description{
Used to enable finding aggregation. Must be called from the aggregation Region.

See \url{https://paws-r.github.io/docs/securityhub/create_finding_aggregator.html} for full documentation.
}
\keyword{internal}
