% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_create_alias}
\alias{directoryservice_create_alias}
\title{Creates an alias for a directory and assigns the alias to the directory}
\usage{
directoryservice_create_alias(DirectoryId, Alias)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory for which to create the alias.}

\item{Alias}{[required] The requested alias.

The alias must be unique amongst all aliases in AWS. This operation
throws an \code{EntityAlreadyExistsException} error if the alias already
exists.}
}
\description{
Creates an alias for a directory and assigns the alias to the directory.
The alias is used to construct the access URL for the directory, such as
\verb{http://&lt;alias&gt;.awsapps.com}.
}
\details{
After an alias has been created, it cannot be deleted or reused, so this
operation should only be used when absolutely necessary.
}
\section{Request syntax}{
\preformatted{svc$create_alias(
  DirectoryId = "string",
  Alias = "string"
)
}
}

\keyword{internal}
