% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_initialize_cluster}
\alias{cloudhsmv2_initialize_cluster}
\title{Claims an AWS CloudHSM cluster by submitting the cluster certificate
issued by your issuing certificate authority (CA) and the CA's root
certificate}
\usage{
cloudhsmv2_initialize_cluster(ClusterId, SignedCert, TrustAnchor)
}
\arguments{
\item{ClusterId}{[required] The identifier (ID) of the cluster that you are claiming. To find the
cluster ID, use DescribeClusters.}

\item{SignedCert}{[required] The cluster certificate issued (signed) by your issuing certificate
authority (CA). The certificate must be in PEM format and can contain a
maximum of 5000 characters.}

\item{TrustAnchor}{[required] The issuing certificate of the issuing certificate authority (CA) that
issued (signed) the cluster certificate. You must use a self-signed
certificate. The certificate used to sign the HSM CSR must be directly
available, and thus must be the root certificate. The certificate must
be in PEM format and can contain a maximum of 5000 characters.}
}
\description{
Claims an AWS CloudHSM cluster by submitting the cluster certificate
issued by your issuing certificate authority (CA) and the CA\'s root
certificate. Before you can claim a cluster, you must sign the
cluster\'s certificate signing request (CSR) with your issuing CA. To
get the cluster\'s CSR, use DescribeClusters.
}
\section{Request syntax}{
\preformatted{svc$initialize_cluster(
  ClusterId = "string",
  SignedCert = "string",
  TrustAnchor = "string"
)
}
}

\keyword{internal}
