% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_create_xss_match_set}
\alias{waf_create_xss_match_set}
\title{This is AWS WAF CLASSIC documentation}
\usage{
waf_create_xss_match_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description for the XssMatchSet that you\'re
creating. You can\'t change \code{Name} after you create the \code{XssMatchSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Creates an XssMatchSet, which you use to allow, block, or count requests
that contain cross-site scripting attacks in the specified part of web
requests. AWS WAF searches for character sequences that are likely to be
malicious strings.

To create and configure an \code{XssMatchSet}, perform the following steps:
\enumerate{
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateXssMatchSet} request.
\item Submit a \code{CreateXssMatchSet} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateXssMatchSet request.
\item Submit an UpdateXssMatchSet request to specify the parts of web
requests in which you want to allow, block, or count cross-site
scripting attacks.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_xss_match_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example creates an XSS match set named
# MySampleXssMatchSet.
svc$create_xss_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MySampleXssMatchSet"
)
}

}
\keyword{internal}
