% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_unlink_developer_identity}
\alias{cognitoidentity_unlink_developer_identity}
\title{Unlinks a DeveloperUserIdentifier from an existing identity}
\usage{
cognitoidentity_unlink_developer_identity(IdentityId, IdentityPoolId,
  DeveloperProviderName, DeveloperUserIdentifier)
}
\arguments{
\item{IdentityId}{[required] A unique identifier in the format REGION:GUID.}

\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}

\item{DeveloperProviderName}{[required] The \"domain\" by which Cognito will refer to your users.}

\item{DeveloperUserIdentifier}{[required] A unique ID used by your backend authentication process to identify a
user.}
}
\description{
Unlinks a \code{DeveloperUserIdentifier} from an existing identity. Unlinked
developer users will be considered new identities next time they are
seen. If, for a given Cognito identity, you remove all federated
identities as well as the developer user identifier, the Cognito
identity becomes inaccessible.
}
\details{
You must use AWS Developer credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$unlink_developer_identity(
  IdentityId = "string",
  IdentityPoolId = "string",
  DeveloperProviderName = "string",
  DeveloperUserIdentifier = "string"
)
}
}

\keyword{internal}
