% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_open_id_connect_provider}
\alias{iam_create_open_id_connect_provider}
\title{Creates an IAM entity to describe an identity provider (IdP) that
supports OpenID Connect (OIDC)}
\usage{
iam_create_open_id_connect_provider(Url, ClientIDList, ThumbprintList)
}
\arguments{
\item{Url}{[required] The URL of the identity provider. The URL must begin with \verb{https://} and
should correspond to the \code{iss} claim in the provider\'s OpenID Connect
ID tokens. Per the OIDC standard, path components are allowed but query
parameters are not. Typically the URL consists of only a hostname, like
\verb{https://server.example.org} or \verb{https://example.com}.

You cannot register the same provider multiple times in a single AWS
account. If you try to submit a URL that has already been used for an
OpenID Connect provider in the AWS account, you will get an error.}

\item{ClientIDList}{A list of client IDs (also known as audiences). When a mobile or web app
registers with an OpenID Connect provider, they establish a value that
identifies the application. (This is the value that\'s sent as the
\code{client_id} parameter on OAuth requests.)

You can register multiple client IDs with the same provider. For
example, you might have multiple applications that use the same OIDC
provider. You cannot register more than 100 client IDs with a single IAM
OIDC provider.

There is no defined format for a client ID. The
\code{CreateOpenIDConnectProviderRequest} operation accepts client IDs up to
255 characters long.}

\item{ThumbprintList}{[required] A list of server certificate thumbprints for the OpenID Connect (OIDC)
identity provider\'s server certificates. Typically this list includes
only one entry. However, IAM lets you have up to five thumbprints for an
OIDC provider. This lets you maintain multiple thumbprints if the
identity provider is rotating certificates.

The server certificate thumbprint is the hex-encoded SHA-1 hash value of
the X.509 certificate used by the domain where the OpenID Connect
provider makes its keys available. It is always a 40-character string.

You must provide at least one thumbprint when creating an IAM OIDC
provider. For example, assume that the OIDC provider is
\code{server.example.com} and the provider stores its keys at
https://keys.server.example.com/openid-connect. In that case, the
thumbprint string would be the hex-encoded SHA-1 hash value of the
certificate used by https://keys.server.example.com.

For more information about obtaining the OIDC provider\'s thumbprint,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html}{Obtaining the Thumbprint for an OpenID Connect Provider}
in the \emph{IAM User Guide}.}
}
\description{
Creates an IAM entity to describe an identity provider (IdP) that
supports \href{http://openid.net/connect/}{OpenID Connect (OIDC)}.
}
\details{
The OIDC provider that you create with this operation can be used as a
principal in a role\'s trust policy. Such a policy establishes a trust
relationship between AWS and the OIDC provider.

When you create the IAM OIDC provider, you specify the following:
\itemize{
\item The URL of the OIDC identity provider (IdP) to trust
\item A list of client IDs (also known as audiences) that identify the
application or applications that are allowed to authenticate using
the OIDC provider
\item A list of thumbprints of the server certificate(s) that the IdP uses
}

You get all of this information from the OIDC IdP that you want to use
to access AWS.

The trust for the OIDC provider is derived from the IAM provider that
this operation creates. Therefore, it is best to limit access to the
CreateOpenIDConnectProvider operation to highly privileged users.
}
\section{Request syntax}{
\preformatted{svc$create_open_id_connect_provider(
  Url = "string",
  ClientIDList = list(
    "string"
  ),
  ThumbprintList = list(
    "string"
  )
)
}
}

\examples{
# The following example defines a new OIDC provider in IAM with a client
# ID of my-application-id and pointing at the server with a URL of
# https://server.example.com.
\dontrun{svc$create_open_id_connect_provider(
  ClientIDList = list(
    "my-application-id"
  ),
  ThumbprintList = list(
    "3768084dfb3d2b68b7897bf5f565da8efEXAMPLE"
  ),
  Url = "https://server.example.com"
)}

}
\keyword{internal}
