# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include macie_service.R
NULL

#' Associates a specified AWS account with Amazon Macie as a member account
#'
#' Associates a specified AWS account with Amazon Macie as a member
#' account.
#'
#' @usage
#' macie_associate_member_account(memberAccountId)
#'
#' @param memberAccountId &#91;required&#93; The ID of the AWS account that you want to associate with Amazon Macie
#' as a member account.
#'
#' @section Request syntax:
#' ```
#' svc$associate_member_account(
#'   memberAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_associate_member_account
macie_associate_member_account <- function(memberAccountId) {
  op <- new_operation(
    name = "AssociateMemberAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$associate_member_account_input(memberAccountId = memberAccountId)
  output <- .macie$associate_member_account_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$associate_member_account <- macie_associate_member_account

#' Associates specified S3 resources with Amazon Macie for monitoring and
#' data classification
#'
#' Associates specified S3 resources with Amazon Macie for monitoring and
#' data classification. If memberAccountId isn\'t specified, the action
#' associates specified S3 resources with Macie for the current master
#' account. If memberAccountId is specified, the action associates
#' specified S3 resources with Macie for the specified member account.
#'
#' @usage
#' macie_associate_s3_resources(memberAccountId, s3Resources)
#'
#' @param memberAccountId The ID of the Amazon Macie member account whose resources you want to
#' associate with Macie.
#' @param s3Resources &#91;required&#93; The S3 resources that you want to associate with Amazon Macie for
#' monitoring and data classification.
#'
#' @section Request syntax:
#' ```
#' svc$associate_s3_resources(
#'   memberAccountId = "string",
#'   s3Resources = list(
#'     list(
#'       bucketName = "string",
#'       prefix = "string",
#'       classificationType = list(
#'         oneTime = "FULL"|"NONE",
#'         continuous = "FULL"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_associate_s3_resources
macie_associate_s3_resources <- function(memberAccountId = NULL, s3Resources) {
  op <- new_operation(
    name = "AssociateS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$associate_s3_resources_input(memberAccountId = memberAccountId, s3Resources = s3Resources)
  output <- .macie$associate_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$associate_s3_resources <- macie_associate_s3_resources

#' Removes the specified member account from Amazon Macie
#'
#' Removes the specified member account from Amazon Macie.
#'
#' @usage
#' macie_disassociate_member_account(memberAccountId)
#'
#' @param memberAccountId &#91;required&#93; The ID of the member account that you want to remove from Amazon Macie.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_member_account(
#'   memberAccountId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_disassociate_member_account
macie_disassociate_member_account <- function(memberAccountId) {
  op <- new_operation(
    name = "DisassociateMemberAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$disassociate_member_account_input(memberAccountId = memberAccountId)
  output <- .macie$disassociate_member_account_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$disassociate_member_account <- macie_disassociate_member_account

#' Removes specified S3 resources from being monitored by Amazon Macie
#'
#' Removes specified S3 resources from being monitored by Amazon Macie. If
#' memberAccountId isn\'t specified, the action removes specified S3
#' resources from Macie for the current master account. If memberAccountId
#' is specified, the action removes specified S3 resources from Macie for
#' the specified member account.
#'
#' @usage
#' macie_disassociate_s3_resources(memberAccountId, associatedS3Resources)
#'
#' @param memberAccountId The ID of the Amazon Macie member account whose resources you want to
#' remove from being monitored by Amazon Macie.
#' @param associatedS3Resources &#91;required&#93; The S3 resources (buckets or prefixes) that you want to remove from
#' being monitored and classified by Amazon Macie.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_s3_resources(
#'   memberAccountId = "string",
#'   associatedS3Resources = list(
#'     list(
#'       bucketName = "string",
#'       prefix = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_disassociate_s3_resources
macie_disassociate_s3_resources <- function(memberAccountId = NULL, associatedS3Resources) {
  op <- new_operation(
    name = "DisassociateS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$disassociate_s3_resources_input(memberAccountId = memberAccountId, associatedS3Resources = associatedS3Resources)
  output <- .macie$disassociate_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$disassociate_s3_resources <- macie_disassociate_s3_resources

#' Lists all Amazon Macie member accounts for the current Amazon Macie
#' master account
#'
#' Lists all Amazon Macie member accounts for the current Amazon Macie
#' master account.
#'
#' @usage
#' macie_list_member_accounts(nextToken, maxResults)
#'
#' @param nextToken Use this parameter when paginating results. Set the value of this
#' parameter to null on your first call to the ListMemberAccounts action.
#' Subsequent calls to the action fill nextToken in the request with the
#' value of nextToken from the previous response to continue listing data.
#' @param maxResults Use this parameter to indicate the maximum number of items that you want
#' in the response. The default value is 250.
#'
#' @section Request syntax:
#' ```
#' svc$list_member_accounts(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_list_member_accounts
macie_list_member_accounts <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListMemberAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$list_member_accounts_input(nextToken = nextToken, maxResults = maxResults)
  output <- .macie$list_member_accounts_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$list_member_accounts <- macie_list_member_accounts

#' Lists all the S3 resources associated with Amazon Macie
#'
#' Lists all the S3 resources associated with Amazon Macie. If
#' memberAccountId isn\'t specified, the action lists the S3 resources
#' associated with Amazon Macie for the current master account. If
#' memberAccountId is specified, the action lists the S3 resources
#' associated with Amazon Macie for the specified member account.
#'
#' @usage
#' macie_list_s3_resources(memberAccountId, nextToken, maxResults)
#'
#' @param memberAccountId The Amazon Macie member account ID whose associated S3 resources you
#' want to list.
#' @param nextToken Use this parameter when paginating results. Set its value to null on
#' your first call to the ListS3Resources action. Subsequent calls to the
#' action fill nextToken in the request with the value of nextToken from
#' the previous response to continue listing data.
#' @param maxResults Use this parameter to indicate the maximum number of items that you want
#' in the response. The default value is 250.
#'
#' @section Request syntax:
#' ```
#' svc$list_s3_resources(
#'   memberAccountId = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_list_s3_resources
macie_list_s3_resources <- function(memberAccountId = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$list_s3_resources_input(memberAccountId = memberAccountId, nextToken = nextToken, maxResults = maxResults)
  output <- .macie$list_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$list_s3_resources <- macie_list_s3_resources

#' Updates the classification types for the specified S3 resources
#'
#' Updates the classification types for the specified S3 resources. If
#' memberAccountId isn\'t specified, the action updates the classification
#' types of the S3 resources associated with Amazon Macie for the current
#' master account. If memberAccountId is specified, the action updates the
#' classification types of the S3 resources associated with Amazon Macie
#' for the specified member account.
#'
#' @usage
#' macie_update_s3_resources(memberAccountId, s3ResourcesUpdate)
#'
#' @param memberAccountId The AWS ID of the Amazon Macie member account whose S3 resources\'
#' classification types you want to update.
#' @param s3ResourcesUpdate &#91;required&#93; The S3 resources whose classification types you want to update.
#'
#' @section Request syntax:
#' ```
#' svc$update_s3_resources(
#'   memberAccountId = "string",
#'   s3ResourcesUpdate = list(
#'     list(
#'       bucketName = "string",
#'       prefix = "string",
#'       classificationTypeUpdate = list(
#'         oneTime = "FULL"|"NONE",
#'         continuous = "FULL"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname macie_update_s3_resources
macie_update_s3_resources <- function(memberAccountId = NULL, s3ResourcesUpdate) {
  op <- new_operation(
    name = "UpdateS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$update_s3_resources_input(memberAccountId = memberAccountId, s3ResourcesUpdate = s3ResourcesUpdate)
  output <- .macie$update_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$update_s3_resources <- macie_update_s3_resources
