% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_user_pool_domain}
\alias{cognitoidentityprovider_create_user_pool_domain}
\title{Creates a new domain for a user pool}
\usage{
cognitoidentityprovider_create_user_pool_domain(Domain, UserPoolId,
  CustomDomainConfig)
}
\arguments{
\item{Domain}{[required] The domain string.}

\item{UserPoolId}{[required] The user pool ID.}

\item{CustomDomainConfig}{The configuration for a custom domain that hosts the sign-up and sign-in
webpages for your application.

Provide this parameter only if you want to use a custom domain for your
user pool. Otherwise, you can exclude this parameter and use the Amazon
Cognito hosted domain instead.

For more information about the hosted domain and custom domains, see
\href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html}{Configuring a User Pool Domain}.}
}
\description{
Creates a new domain for a user pool.
}
\section{Request syntax}{
\preformatted{svc$create_user_pool_domain(
  Domain = "string",
  UserPoolId = "string",
  CustomDomainConfig = list(
    CertificateArn = "string"
  )
)
}
}

\keyword{internal}
