% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_delete_assessment_target}
\alias{inspector_delete_assessment_target}
\title{Deletes the assessment target that is specified by the ARN of the
assessment target}
\usage{
inspector_delete_assessment_target(assessmentTargetArn)
}
\arguments{
\item{assessmentTargetArn}{[required] The ARN that specifies the assessment target that you want to delete.}
}
\description{
Deletes the assessment target that is specified by the ARN of the
assessment target.
}
\section{Request syntax}{
\preformatted{svc$delete_assessment_target(
  assessmentTargetArn = "string"
)
}
}

\examples{
# Deletes the assessment target that is specified by the ARN of the
# assessment target.
\donttest{svc$delete_assessment_target(
  assessmentTargetArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
)}

}
\keyword{internal}
