% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_virtual_mfa_device}
\alias{iam_create_virtual_mfa_device}
\title{Creates a new virtual MFA device for the AWS account}
\usage{
iam_create_virtual_mfa_device(Path, VirtualMFADeviceName)
}
\arguments{
\item{Path}{The path for the virtual MFA device. For more information about paths,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\code{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{VirtualMFADeviceName}{[required] The name of the virtual MFA device. Use with path to uniquely identify a
virtual MFA device.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}
}
\description{
Creates a new virtual MFA device for the AWS account. After creating the
virtual MFA, use EnableMFADevice to attach the MFA device to an IAM
user. For more information about creating and working with virtual MFA
devices, go to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html}{Using a Virtual MFA Device}
in the \emph{IAM User Guide}.
}
\details{
For information about limits on the number of MFA devices you can
create, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html}{Limitations on Entities}
in the \emph{IAM User Guide}.

The seed information contained in the QR code and the Base32 string
should be treated like any other secret access information. In other
words, protect the seed information as you would your AWS access keys or
your passwords. After you provision your virtual device, you should
ensure that the information is destroyed following secure procedures.
}
\section{Request syntax}{
\preformatted{svc$create_virtual_mfa_device(
  Path = "string",
  VirtualMFADeviceName = "string"
)
}
}

\keyword{internal}
