% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsm_operations.R
\name{cloudhsm_modify_hsm}
\alias{cloudhsm_modify_hsm}
\title{This is documentation for AWS CLOUDHSM CLASSIC}
\usage{
cloudhsm_modify_hsm(HsmArn, SubnetId, EniIp, IamRoleArn, ExternalId,
  SyslogIp)
}
\arguments{
\item{HsmArn}{[required] The ARN of the HSM to modify.}

\item{SubnetId}{The new identifier of the subnet that the HSM is in. The new subnet must
be in the same Availability Zone as the current subnet.}

\item{EniIp}{The new IP address for the elastic network interface (ENI) attached to
the HSM.

If the HSM is moved to a different subnet, and an IP address is not
specified, an IP address will be randomly chosen from the CIDR range of
the new subnet.}

\item{IamRoleArn}{The new IAM role ARN.}

\item{ExternalId}{The new external ID.}

\item{SyslogIp}{The new IP address for the syslog monitoring server. The AWS CloudHSM
service only supports one syslog monitoring server.}
}
\description{
This is documentation for \strong{AWS CloudHSM Classic}. For more
information, see \href{http://aws.amazon.com/cloudhsm/faqs-classic/}{AWS CloudHSM Classic FAQs}, the \href{http://docs.aws.amazon.com/cloudhsm/classic/userguide/}{AWS CloudHSM Classic User Guide}, and the
\href{http://docs.aws.amazon.com/cloudhsm/classic/APIReference/}{AWS CloudHSM Classic API Reference}.
}
\details{
\strong{For information about the current version of AWS CloudHSM}, see \href{http://aws.amazon.com/cloudhsm/}{AWS CloudHSM}, the \href{http://docs.aws.amazon.com/cloudhsm/latest/userguide/}{AWS CloudHSM User Guide}, and the
\href{http://docs.aws.amazon.com/cloudhsm/latest/APIReference/}{AWS CloudHSM API Reference}.

Modifies an HSM.

This operation can result in the HSM being offline for up to 15 minutes
while the AWS CloudHSM service is reconfigured. If you are modifying a
production HSM, you should ensure that your AWS CloudHSM service is
configured for high availability, and consider executing this operation
during a maintenance window.
}
\section{Request syntax}{
\preformatted{svc$modify_hsm(
  HsmArn = "string",
  SubnetId = "string",
  EniIp = "string",
  IamRoleArn = "string",
  ExternalId = "string",
  SyslogIp = "string"
)
}
}

\keyword{internal}
