% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_describe_certificate}
\alias{acm_describe_certificate}
\title{Returns detailed metadata about the specified ACM certificate}
\usage{
acm_describe_certificate(CertificateArn)
}
\arguments{
\item{CertificateArn}{[required] The Amazon Resource Name (ARN) of the ACM certificate. The ARN must have
the following form:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}
}
\description{
Returns detailed metadata about the specified ACM certificate.
}
\section{Request syntax}{
\preformatted{svc$describe_certificate(
  CertificateArn = "string"
)
}
}

\keyword{internal}
