% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie_service.R
\name{macie}
\alias{macie}
\title{Amazon Macie}
\usage{
macie(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Macie Classic

Amazon Macie Classic is a security service that uses machine learning to
automatically discover, classify, and protect sensitive data in AWS.
Macie Classic recognizes sensitive data such as personally identifiable
information (PII) or intellectual property, and provides you with
dashboards and alerts that give visibility into how this data is being
accessed or moved. For more information, see the \href{https://docs.aws.amazon.com/macie/latest/userguide/what-is-macie.html}{Amazon Macie Classic User Guide}.

A new Amazon Macie is now available with significant design improvements
and additional features, at a lower price and in most AWS Regions. We
encourage you to explore and use the new and improved features, and
benefit from the reduced cost. To learn about features and pricing for
the new Amazon Macie, see \href{https://aws.amazon.com/macie/}{Amazon Macie}.
}
\section{Service syntax}{
\preformatted{svc <- macie(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=macie_associate_member_account]{associate_member_account} \tab Associates a specified AWS account with Amazon Macie Classic as a member account\cr
\link[=macie_associate_s3_resources]{associate_s3_resources} \tab Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification\cr
\link[=macie_disassociate_member_account]{disassociate_member_account} \tab Removes the specified member account from Amazon Macie Classic\cr
\link[=macie_disassociate_s3_resources]{disassociate_s3_resources} \tab Removes specified S3 resources from being monitored by Amazon Macie Classic\cr
\link[=macie_list_member_accounts]{list_member_accounts} \tab Lists all Amazon Macie Classic member accounts for the current Amazon Macie Classic master account\cr
\link[=macie_list_s3_resources]{list_s3_resources} \tab Lists all the S3 resources associated with Amazon Macie Classic\cr
\link[=macie_update_s3_resources]{update_s3_resources} \tab Updates the classification types for the specified S3 resources
}
}

\examples{
\dontrun{
svc <- macie()
svc$associate_member_account(
  Foo = 123
)
}

}
