% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_mfa_devices}
\alias{iam_list_mfa_devices}
\title{Lists the MFA devices for an IAM user}
\usage{
iam_list_mfa_devices(UserName, Marker, MaxItems)
}
\arguments{
\item{UserName}{The name of the user whose MFA devices you want to list.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\value{
A list with the following syntax:\preformatted{list(
  MFADevices = list(
    list(
      UserName = "string",
      SerialNumber = "string",
      EnableDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  IsTruncated = TRUE|FALSE,
  Marker = "string"
)
}
}
\description{
Lists the MFA devices for an IAM user. If the request includes a IAM
user name, then this operation lists all the MFA devices associated with
the specified user. If you do not specify a user name, IAM determines
the user name implicitly based on the AWS access key ID signing the
request for this API.

You can paginate the results using the \code{MaxItems} and \code{Marker}
parameters.
}
\section{Request syntax}{
\preformatted{svc$list_mfa_devices(
  UserName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
