% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_auth_event_feedback}
\alias{cognitoidentityprovider_update_auth_event_feedback}
\title{Provides the feedback for an authentication event whether it was from a
valid user or not}
\usage{
cognitoidentityprovider_update_auth_event_feedback(UserPoolId, Username,
  EventId, FeedbackToken, FeedbackValue)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{Username}{[required] The user pool username.}

\item{EventId}{[required] The event ID.}

\item{FeedbackToken}{[required] The feedback token.}

\item{FeedbackValue}{[required] The authentication event feedback value.}
}
\value{
An empty list.
}
\description{
Provides the feedback for an authentication event whether it was from a
valid user or not. This feedback is used for improving the risk
evaluation decision for the user pool as part of Amazon Cognito advanced
security.
}
\section{Request syntax}{
\preformatted{svc$update_auth_event_feedback(
  UserPoolId = "string",
  Username = "string",
  EventId = "string",
  FeedbackToken = "string",
  FeedbackValue = "Valid"|"Invalid"
)
}
}

\keyword{internal}
