% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_attached_indices}
\alias{clouddirectory_list_attached_indices}
\title{Lists indices attached to the specified object}
\usage{
clouddirectory_list_attached_indices(DirectoryArn, TargetReference,
  NextToken, MaxResults, ConsistencyLevel)
}
\arguments{
\item{DirectoryArn}{[required] The ARN of the directory.}

\item{TargetReference}{[required] A reference to the object that has indices attached.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of results to retrieve.}

\item{ConsistencyLevel}{The consistency level to use for this operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  IndexAttachments = list(
    list(
      IndexedAttributes = list(
        list(
          Key = list(
            SchemaArn = "string",
            FacetName = "string",
            Name = "string"
          ),
          Value = list(
            StringValue = "string",
            BinaryValue = raw,
            BooleanValue = TRUE|FALSE,
            NumberValue = "string",
            DatetimeValue = as.POSIXct(
              "2015-01-01"
            )
          )
        )
      ),
      ObjectIdentifier = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists indices attached to the specified object.
}
\section{Request syntax}{
\preformatted{svc$list_attached_indices(
  DirectoryArn = "string",
  TargetReference = list(
    Selector = "string"
  ),
  NextToken = "string",
  MaxResults = 123,
  ConsistencyLevel = "SERIALIZABLE"|"EVENTUAL"
)
}
}

\keyword{internal}
