% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_web_acl_migration_stack}
\alias{wafregional_create_web_acl_migration_stack}
\title{Creates an AWS CloudFormation WAFV2 template for the specified web ACL
in the specified Amazon S3 bucket}
\usage{
wafregional_create_web_acl_migration_stack(WebACLId, S3BucketName,
  IgnoreUnsupportedType)
}
\arguments{
\item{WebACLId}{[required] The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.}

\item{S3BucketName}{[required] The name of the Amazon S3 bucket to store the CloudFormation template
in. The S3 bucket must be configured as follows for the migration:
\itemize{
\item The bucket name must start with \verb{aws-waf-migration-}. For example,
\code{aws-waf-migration-my-web-acl}.
\item The bucket must be in the Region where you are deploying the
template. For example, for a web ACL in us-west-2, you must use an
Amazon S3 bucket in us-west-2 and you must deploy the template stack
to us-west-2.
\item The bucket policies must permit the migration process to write data.
For listings of the bucket policies, see the Examples section.
}}

\item{IgnoreUnsupportedType}{[required] Indicates whether to exclude entities that can't be migrated or to stop
the migration. Set this to true to ignore unsupported entities in the
web ACL during the migration. Otherwise, if AWS WAF encounters
unsupported entities, it stops the process and throws an exception.}
}
\value{
A list with the following syntax:\preformatted{list(
  S3ObjectUrl = "string"
)
}
}
\description{
Creates an AWS CloudFormation WAFV2 template for the specified web ACL
in the specified Amazon S3 bucket. Then, in CloudFormation, you create a
stack from the template, to create the web ACL and its resources in AWS
WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest
version of AWS WAF.

This is part of a larger migration procedure for web ACLs from AWS WAF
Classic to the latest version of AWS WAF. For the full procedure,
including caveats and manual steps to complete the migration and switch
over to the new web ACL, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-migrating-from-classic.html}{Migrating your AWS WAF Classic resources to AWS WAF}
in the \href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_web_acl_migration_stack(
  WebACLId = "string",
  S3BucketName = "string",
  IgnoreUnsupportedType = TRUE|FALSE
)
}
}

\keyword{internal}
