% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_disassociate_health_check}
\alias{shield_disassociate_health_check}
\title{Removes health-based detection from the Shield Advanced protection for a
resource}
\usage{
shield_disassociate_health_check(ProtectionId, HealthCheckArn)
}
\arguments{
\item{ProtectionId}{[required] The unique identifier (ID) for the Protection object to remove the
health check association from.}

\item{HealthCheckArn}{[required] The Amazon Resource Name (ARN) of the health check that is associated
with the protection.}
}
\value{
An empty list.
}
\description{
Removes health-based detection from the Shield Advanced protection for a
resource. Shield Advanced health-based detection uses the health of your
AWS resource to improve responsiveness and accuracy in attack detection
and mitigation.

You define the health check in Route 53 and then associate or
disassociate it with your Shield Advanced protection. For more
information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option}{Shield Advanced Health-Based Detection}
in the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF and AWS Shield Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$disassociate_health_check(
  ProtectionId = "string",
  HealthCheckArn = "string"
)
}
}

\keyword{internal}
