% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_permissions}
\alias{ram_list_permissions}
\title{Lists the AWS RAM permissions}
\usage{
ram_list_permissions(resourceType, nextToken, maxResults)
}
\arguments{
\item{resourceType}{Specifies the resource type for which to list permissions. For example,
to list only permissions that apply to EC2 subnets, specify
\code{ec2:Subnet}.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\value{
A list with the following syntax:\preformatted{list(
  permissions = list(
    list(
      arn = "string",
      version = "string",
      defaultVersion = TRUE|FALSE,
      name = "string",
      resourceType = "string",
      status = "string",
      creationTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists the AWS RAM permissions.
}
\section{Request syntax}{
\preformatted{svc$list_permissions(
  resourceType = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
